/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.util;

import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.NoSuchElementException;
import org.eclipse.jdt.internal.core.JavaElement;
import org.eclipse.jdt.internal.core.util.ICacheEnumeration;
import org.eclipse.jdt.internal.core.util.ILRUCacheable;
import org.eclipse.jdt.internal.core.util.ToStringSorter;

public class LRUCache<K, V>
implements Cloneable {
    protected int currentSpace = 0;
    protected int spaceLimit;
    protected int timestampCounter = 0;
    protected Hashtable<K, LRUCacheEntry<K, V>> entryTable;
    protected LRUCacheEntry<K, V> entryQueue = null;
    protected LRUCacheEntry<K, V> entryQueueTail = null;
    protected static final int DEFAULT_SPACELIMIT = 100;

    public LRUCache() {
        this(100);
    }

    public LRUCache(int size) {
        this.entryTable = new Hashtable(size);
        this.spaceLimit = size;
    }

    public LRUCache<K, V> clone() {
        LRUCache newCache = this.newInstance(this.spaceLimit);
        LRUCacheEntry<K, V> qEntry = this.entryQueueTail;
        while (qEntry != null) {
            newCache.privateAdd(qEntry.key, qEntry.value, qEntry.space);
            qEntry = qEntry.previous;
        }
        return newCache;
    }

    public double fillingRatio() {
        return (double)this.currentSpace * 100.0 / (double)this.spaceLimit;
    }

    public void flush() {
        this.currentSpace = 0;
        LRUCacheEntry<K, V> entry = this.entryQueueTail;
        this.entryTable = new Hashtable();
        this.entryQueueTail = null;
        this.entryQueue = null;
        while (entry != null) {
            entry = entry.previous;
        }
    }

    public void flush(K key) {
        LRUCacheEntry<K, V> entry = this.entryTable.get(key);
        if (entry == null) {
            return;
        }
        this.privateRemoveEntry(entry, false);
    }

    public K getKey(K key) {
        LRUCacheEntry<K, V> entry = this.entryTable.get(key);
        if (entry == null) {
            return key;
        }
        return entry.key;
    }

    public V get(K key) {
        LRUCacheEntry<K, V> entry = this.entryTable.get(key);
        if (entry == null) {
            return null;
        }
        this.updateTimestamp(entry);
        return entry.value;
    }

    public int getCurrentSpace() {
        return this.currentSpace;
    }

    public int getNewestTimestampCounter() {
        return this.entryQueue == null ? 0 : this.entryQueue.timestamp;
    }

    public int getOldestTimestampCounter() {
        return this.entryQueueTail == null ? 0 : this.entryQueueTail.timestamp;
    }

    public K getOldestElement() {
        return this.entryQueueTail == null ? null : (K)this.entryQueueTail.key;
    }

    public int getSpaceLimit() {
        return this.spaceLimit;
    }

    public Enumeration<K> keys() {
        return this.entryTable.keys();
    }

    public ICacheEnumeration<K, V> keysAndValues() {
        return new ICacheEnumeration<K, V>(){
            Enumeration<LRUCacheEntry<K, V>> values;
            LRUCacheEntry<K, V> entry;
            {
                this.values = LRUCache.this.entryTable.elements();
            }

            @Override
            public boolean hasMoreElements() {
                return this.values.hasMoreElements();
            }

            @Override
            public K nextElement() {
                this.entry = this.values.nextElement();
                return this.entry.key;
            }

            @Override
            public V getValue() {
                if (this.entry == null) {
                    throw new NoSuchElementException();
                }
                return this.entry.value;
            }
        };
    }

    /*
     * Unable to fully structure code
     */
    protected boolean makeSpace(int space) {
        limit = this.getSpaceLimit();
        if (this.currentSpace + space <= limit) {
            return true;
        }
        if (space <= limit) ** GOTO lbl7
        return false;
lbl-1000:
        // 1 sources

        {
            this.privateRemoveEntry(this.entryQueueTail, false);
lbl7:
            // 2 sources

            ** while (this.currentSpace + space > limit && this.entryQueueTail != null)
        }
lbl8:
        // 1 sources

        return true;
    }

    protected LRUCache<K, V> newInstance(int size) {
        return new LRUCache<K, V>(size);
    }

    public V peek(K key) {
        LRUCacheEntry<K, V> entry = this.entryTable.get(key);
        if (entry == null) {
            return null;
        }
        return entry.value;
    }

    protected void privateAdd(K key, V value, int space) {
        LRUCacheEntry<K, V> entry = new LRUCacheEntry<K, V>(key, value, space);
        this.privateAddEntry(entry, false);
    }

    protected void privateAddEntry(LRUCacheEntry<K, V> entry, boolean shuffle) {
        if (!shuffle) {
            this.entryTable.put(entry.key, entry);
            this.currentSpace += entry.space;
        }
        entry.timestamp = this.timestampCounter++;
        entry.next = this.entryQueue;
        entry.previous = null;
        if (this.entryQueue == null) {
            this.entryQueueTail = entry;
        } else {
            this.entryQueue.previous = entry;
        }
        this.entryQueue = entry;
    }

    protected void privateRemoveEntry(LRUCacheEntry<K, V> entry, boolean shuffle) {
        LRUCacheEntry previous = entry.previous;
        LRUCacheEntry next = entry.next;
        if (!shuffle) {
            this.entryTable.remove(entry.key);
            this.currentSpace -= entry.space;
        }
        if (previous == null) {
            this.entryQueue = next;
        } else {
            previous.next = next;
        }
        if (next == null) {
            this.entryQueueTail = previous;
        } else {
            next.previous = previous;
        }
    }

    public V put(K key, V value) {
        int newSpace = this.spaceFor(value);
        LRUCacheEntry<K, V> entry = this.entryTable.get(key);
        if (entry != null) {
            int oldSpace = entry.space;
            int newTotal = this.getCurrentSpace() - oldSpace + newSpace;
            if (newTotal <= this.getSpaceLimit()) {
                this.updateTimestamp(entry);
                entry.value = value;
                entry.space = newSpace;
                this.currentSpace = newTotal;
                return value;
            }
            this.privateRemoveEntry(entry, false);
        }
        if (this.makeSpace(newSpace)) {
            this.privateAdd(key, value, newSpace);
        }
        return value;
    }

    public V removeKey(K key) {
        LRUCacheEntry<K, V> entry = this.entryTable.get(key);
        if (entry == null) {
            return null;
        }
        Object value = entry.value;
        this.privateRemoveEntry(entry, false);
        return value;
    }

    public void setSpaceLimit(int limit) {
        if (limit < this.spaceLimit) {
            this.makeSpace(this.spaceLimit - limit);
        }
        this.spaceLimit = limit;
    }

    protected int spaceFor(V value) {
        if (value instanceof ILRUCacheable) {
            return ((ILRUCacheable)value).getCacheFootprint();
        }
        return 1;
    }

    public String toString() {
        return String.valueOf(this.toStringFillingRation("LRUCache")) + this.toStringContents();
    }

    protected String toStringContents() {
        StringBuilder result = new StringBuilder();
        ToStringSorter<Object> sorter = new ToStringSorter<Object>(o -> o instanceof JavaElement ? ((JavaElement)o).getElementName() : o.toString());
        List<ToStringSorter.Pair<Object>> sortedObjects = sorter.sort(this.entryTable.keySet());
        for (ToStringSorter.Pair<Object> pair : sortedObjects) {
            String toString = pair.string;
            V value = this.get(pair.object);
            result.append(toString);
            result.append(" -> ");
            result.append(value);
            result.append("\n");
        }
        return result.toString();
    }

    public String toStringFillingRation(String cacheName) {
        StringBuilder buffer = new StringBuilder(cacheName);
        buffer.append('[');
        buffer.append(this.getSpaceLimit());
        buffer.append("]: ");
        buffer.append(NumberFormat.getInstance().format(this.fillingRatio()));
        buffer.append("% full");
        return buffer.toString();
    }

    protected void updateTimestamp(LRUCacheEntry<K, V> entry) {
        entry.timestamp = this.timestampCounter++;
        if (this.entryQueue != entry) {
            this.privateRemoveEntry(entry, true);
            this.privateAddEntry(entry, true);
        }
    }

    public static class LRUCacheEntry<K, V> {
        public K key;
        public V value;
        public int timestamp;
        public int space;
        public LRUCacheEntry<K, V> previous;
        public LRUCacheEntry<K, V> next;

        public LRUCacheEntry(K key, V value, int space) {
            this.key = key;
            this.value = value;
            this.space = space;
        }

        public String toString() {
            return "LRUCacheEntry [" + this.key + "-->" + this.value + "]";
        }
    }

    public class Stats {
        private int[] counters = new int[20];
        private long[] timestamps = new long[20];
        private int counterIndex = -1;

        private void add(int counter) {
            int i = 0;
            while (i <= this.counterIndex) {
                if (this.counters[i] == counter) {
                    return;
                }
                ++i;
            }
            int length = this.counters.length;
            if (++this.counterIndex == length) {
                int newLength = this.counters.length * 2;
                this.counters = new int[newLength];
                System.arraycopy(this.counters, 0, this.counters, 0, length);
                this.timestamps = new long[newLength];
                System.arraycopy(this.timestamps, 0, this.timestamps, 0, length);
            }
            this.counters[this.counterIndex] = counter;
            this.timestamps[this.counterIndex] = System.currentTimeMillis();
        }

        private String getAverageAge(long totalTime, int numberOfElements, long currentTime) {
            if (numberOfElements == 0) {
                return "N/A";
            }
            long time = totalTime / (long)numberOfElements;
            long age = currentTime - time;
            long ageInSeconds = age / 1000L;
            int seconds = 0;
            int minutes = 0;
            int hours = 0;
            int days = 0;
            if (ageInSeconds > 60L) {
                long ageInMin = ageInSeconds / 60L;
                seconds = (int)(ageInSeconds - 60L * ageInMin);
                if (ageInMin > 60L) {
                    long ageInHours = ageInMin / 60L;
                    minutes = (int)(ageInMin - 60L * ageInHours);
                    if (ageInHours > 24L) {
                        long ageInDays = ageInHours / 24L;
                        hours = (int)(ageInHours - 24L * ageInDays);
                        days = (int)ageInDays;
                    } else {
                        hours = (int)ageInHours;
                    }
                } else {
                    minutes = (int)ageInMin;
                }
            } else {
                seconds = (int)ageInSeconds;
            }
            StringBuilder buffer = new StringBuilder();
            if (days > 0) {
                buffer.append(days);
                buffer.append(" days ");
            }
            if (hours > 0) {
                buffer.append(hours);
                buffer.append(" hours ");
            }
            if (minutes > 0) {
                buffer.append(minutes);
                buffer.append(" minutes ");
            }
            buffer.append(seconds);
            buffer.append(" seconds");
            return buffer.toString();
        }

        private long getTimestamps(int counter) {
            int i = 0;
            while (i <= this.counterIndex) {
                if (this.counters[i] >= counter) {
                    return this.timestamps[i];
                }
                ++i;
            }
            return -1L;
        }

        public synchronized String printStats() {
            int numberOfElements = LRUCache.this.currentSpace;
            if (numberOfElements == 0) {
                return "No elements in cache";
            }
            StringBuilder buffer = new StringBuilder();
            buffer.append("Number of elements in cache: ");
            buffer.append(numberOfElements);
            int numberOfGroups = 5;
            int numberOfElementsPerGroup = numberOfElements / 5;
            buffer.append("\n(");
            buffer.append(5);
            buffer.append(" groups of ");
            buffer.append(numberOfElementsPerGroup);
            buffer.append(" elements)");
            buffer.append("\n\nAverage age:");
            int groupNumber = 1;
            int elementCounter = 0;
            LRUCacheEntry entry = LRUCache.this.entryQueueTail;
            long currentTime = System.currentTimeMillis();
            long accumulatedTime = 0L;
            while (entry != null) {
                long timeStamps = this.getTimestamps(entry.timestamp);
                if (timeStamps > 0L) {
                    accumulatedTime += timeStamps;
                    ++elementCounter;
                }
                if (elementCounter >= numberOfElementsPerGroup && groupNumber < 5) {
                    buffer.append("\nGroup ");
                    buffer.append(groupNumber);
                    if (groupNumber == 1) {
                        buffer.append(" (oldest)\t: ");
                    } else {
                        buffer.append("\t\t: ");
                    }
                    ++groupNumber;
                    buffer.append(this.getAverageAge(accumulatedTime, elementCounter, currentTime));
                    elementCounter = 0;
                    accumulatedTime = 0L;
                }
                entry = entry.previous;
            }
            buffer.append("\nGroup ");
            buffer.append(5);
            buffer.append(" (youngest)\t: ");
            buffer.append(this.getAverageAge(accumulatedTime, elementCounter, currentTime));
            return buffer.toString();
        }

        private void removeCountersOlderThan(int counter) {
            int i = 0;
            while (i <= this.counterIndex) {
                if (this.counters[i] >= counter) {
                    if (i > 0) {
                        int length = this.counterIndex - i + 1;
                        System.arraycopy(this.counters, i, this.counters, 0, length);
                        System.arraycopy(this.timestamps, i, this.timestamps, 0, length);
                        this.counterIndex = length;
                    }
                    return;
                }
                ++i;
            }
        }

        public K getOldestElement() {
            return LRUCache.this.getOldestElement();
        }

        public long getOldestTimestamps() {
            return this.getTimestamps(LRUCache.this.getOldestTimestampCounter());
        }

        public synchronized void snapshot() {
            this.removeCountersOlderThan(LRUCache.this.getOldestTimestampCounter());
            this.add(LRUCache.this.getNewestTimestampCounter());
        }
    }
}

