/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.manipulation.util;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.internal.core.manipulation.util.Strings;
import org.eclipse.osgi.util.TextProcessor;

public class BasicElementLabels {
    private static final String CODE_DELIMITERS = TextProcessor.getDefaultDelimiters() + "<>()?,{}+-*!%=^|&;[]~";
    private static final String FILE_PATTERN_DELIMITERS = TextProcessor.getDefaultDelimiters() + "*.?";
    private static final String URL_DELIMITERS = TextProcessor.getDefaultDelimiters() + ":@?-";

    public static String getPathLabel(IPath path, boolean isOSPath) {
        String label = isOSPath ? path.toOSString() : path.makeRelative().toString();
        return Strings.markLTR(label);
    }

    public static String getPathLabel(File file) {
        return Strings.markLTR(file.getAbsolutePath());
    }

    public static String getFilePattern(String name) {
        return Strings.markLTR(name, FILE_PATTERN_DELIMITERS);
    }

    public static String getURLPart(String name) {
        return Strings.markLTR(name, URL_DELIMITERS);
    }

    public static String getResourceName(IResource resource) {
        return Strings.markLTR(resource.getName());
    }

    public static String getResourceName(String resourceName) {
        return Strings.markLTR(resourceName);
    }

    public static String getFileName(ITypeRoot typeRoot) {
        return Strings.markLTR(typeRoot.getElementName());
    }

    public static String getJavaElementName(String name) {
        return Strings.markJavaElementLabelLTR(name);
    }

    public static String getJavaCodeString(String string) {
        return Strings.markLTR(string, CODE_DELIMITERS);
    }

    public static String getVersionName(String name) {
        return Strings.markLTR(name);
    }
}

