/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionMethodReference;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMemberValuePairBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.IPackageBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.JdtCoreDomPackagePrivateUtility;
import org.eclipse.jdt.core.dom.LambdaExpression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.MethodReference;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.QualifiedType;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.SuperMethodInvocation;
import org.eclipse.jdt.core.dom.SuperMethodReference;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.TypeMethodReference;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.core.BinaryMethod;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.search.BasicSearchEngine;
import org.eclipse.jdt.internal.core.search.DOMASTNodeUtils;
import org.eclipse.jdt.internal.core.search.LocatorResponse;
import org.eclipse.jdt.internal.core.search.matching.DOMPatternLocator;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.MethodLocator;
import org.eclipse.jdt.internal.core.search.matching.MethodPattern;
import org.eclipse.jdt.internal.core.search.matching.NodeSetWrapper;
import org.eclipse.jdt.internal.core.search.matching.PatternLocator;
import org.eclipse.jdt.internal.core.search.matching.SearchMatchingUtility;
import org.eclipse.jdt.internal.core.search.matching.SuperTypeNamesCollector;
import org.eclipse.jdt.internal.core.search.matching.TypeArgumentMatchingUtility;

public class DOMMethodLocator
extends DOMPatternLocator {
    private MethodLocator locator;
    private MethodPattern pattern;
    private char[][][] allSuperDeclaringTypeNames;
    private char[][][] samePkgSuperDeclaringTypeNames;
    private Map<ASTNode, Boolean> methodDeclarationsWithInvalidParam = new HashMap<ASTNode, Boolean>();

    public DOMMethodLocator(MethodLocator locator) {
        super((SearchPattern)locator.pattern);
        this.locator = locator;
        this.pattern = locator.pattern;
    }

    private IMethodBinding getDOMASTMethodBinding(ITypeBinding type, String methodName, ITypeBinding[] argumentTypes) {
        if (type == null) {
            return null;
        }
        return Stream.of(type.getDeclaredMethods()).filter(method -> Objects.equals(method.getName(), methodName)).filter(method -> DOMMethodLocator.compatibleByErasure(method.getParameterTypes(), argumentTypes)).findAny().orElse(null);
    }

    private static boolean compatibleByErasure(ITypeBinding[] one, ITypeBinding[] other) {
        if (Objects.equals(one, other)) {
            return true;
        }
        if (one == null || other == null || one.length != other.length) {
            return false;
        }
        for (int i = 0; i < one.length; ++i) {
            if (Objects.equals(one[i].getErasure(), other[i].getErasure())) continue;
            return false;
        }
        return true;
    }

    @Override
    public LocatorResponse match(MethodDeclaration node, NodeSetWrapper nodeSet, MatchLocator locator) {
        if (!this.locator.pattern.findDeclarations) {
            return this.toResponse(0);
        }
        if (!this.locator.matchesName(this.locator.pattern.selector, node.getName().getIdentifier().toCharArray())) {
            return this.toResponse(0);
        }
        boolean resolve = this.locator.pattern.mustResolve;
        if (this.locator.pattern.parameterSimpleNames != null) {
            int argsLength;
            int length = this.locator.pattern.parameterSimpleNames.length;
            List args = node.parameters();
            int n = argsLength = args == null ? 0 : args.size();
            if (length != argsLength) {
                return this.toResponse(0);
            }
            for (int i = 0; i < argsLength; ++i) {
                SingleVariableDeclaration arg = (SingleVariableDeclaration)args.get(i);
                if (this.matchesTypeReference(this.locator.pattern.parameterSimpleNames[i], arg.getType(), arg.isVarargs())) continue;
                if (!this.locator.pattern.mustResolve) {
                    nodeSet.setMustResolve(true);
                    resolve = true;
                }
                this.methodDeclarationsWithInvalidParam.put((ASTNode)node, null);
            }
        }
        if (this.locator.pattern.hasMethodArguments() && (node.typeParameters() == null || node.typeParameters().size() != this.locator.pattern.methodArguments.length)) {
            return this.toResponse(0);
        }
        int level = nodeSet.addMatch((ASTNode)node, resolve ? 2 : 3);
        return this.toResponse(level, true);
    }

    @Override
    public LocatorResponse match(AnnotationTypeMemberDeclaration node, NodeSetWrapper nodeSet, MatchLocator locator) {
        return this.toResponse(this.locator.pattern.findDeclarations && this.locator.matchesName(this.locator.pattern.selector, node.getName().getIdentifier().toCharArray()) ? 2 : 0);
    }

    @Override
    public LocatorResponse match(Annotation node, NodeSetWrapper nodeSet, MatchLocator locator) {
        int n;
        if (this.locator.pattern.findReferences && node instanceof SingleMemberAnnotation) {
            SingleMemberAnnotation singleMemberAnnot = (SingleMemberAnnotation)node;
            n = 2;
        } else {
            n = 0;
        }
        return this.toResponse(n);
    }

    private int matchReference(SimpleName name, List<?> args) {
        if (!this.locator.pattern.findReferences) {
            return 0;
        }
        if (!this.locator.matchesName(this.locator.pattern.selector, name.getIdentifier().toCharArray())) {
            return 0;
        }
        if (this.locator.pattern.parameterSimpleNames != null && (!this.locator.pattern.varargs || DOMASTNodeUtils.insideDocComment((ASTNode)name))) {
            int argsLength;
            int length = this.locator.pattern.parameterSimpleNames.length;
            int n = argsLength = args == null ? 0 : args.size();
            if (length != argsLength) {
                return 0;
            }
        }
        return this.locator.pattern.mustResolve ? 2 : 3;
    }

    @Override
    public LocatorResponse match(MethodInvocation node, NodeSetWrapper nodeSet, MatchLocator locator) {
        int level = this.matchReference(node.getName(), node.arguments());
        if (level == 0) {
            return this.toResponse(0);
        }
        int fineGrain = this.locator.pattern.fineGrain;
        if (fineGrain != 0) {
            Expression expr = node.getExpression();
            if ((fineGrain & 0x8000000) == 0 && expr == null) {
                return this.toResponse(0);
            }
            if ((fineGrain & 0x2000000) == 0 && expr != null && !(expr instanceof ThisExpression)) {
                return this.toResponse(0);
            }
            if ((fineGrain & 0x4000000) == 0 && expr instanceof ThisExpression) {
                return this.toResponse(0);
            }
        }
        return this.toResponse(nodeSet.addMatch((ASTNode)node, level), true);
    }

    @Override
    public LocatorResponse match(MethodRef node, NodeSetWrapper nodeSet, MatchLocator locator) {
        int level = this.matchReference(node.getName(), node.parameters());
        if (level == 0) {
            return this.toResponse(0);
        }
        return this.toResponse(nodeSet.addMatch((ASTNode)node, level), true);
    }

    @Override
    public LocatorResponse match(MethodReference node, NodeSetWrapper nodeSet, MatchLocator locator) {
        TypeMethodReference expr;
        ExpressionMethodReference expr2;
        ExpressionMethodReference expr3;
        if (this.locator.pattern.fineGrain == 0 || (this.locator.pattern.fineGrain & 0x10000000) != 0 || node instanceof SuperMethodReference && (this.locator.pattern.fineGrain & 0x1000000) != 0 || node instanceof ExpressionMethodReference && (expr3 = (ExpressionMethodReference)node).getExpression() instanceof ThisExpression && (this.locator.pattern.fineGrain & 0x4000000) != 0 || node instanceof ExpressionMethodReference && (expr2 = (ExpressionMethodReference)node).getExpression() instanceof QualifiedName && (this.locator.pattern.fineGrain & 0x2000000) != 0 || node instanceof TypeMethodReference && (expr = (TypeMethodReference)node).getType() instanceof QualifiedType && (this.locator.pattern.fineGrain & 0x2000000) != 0) {
            SimpleName name;
            if (node instanceof TypeMethodReference) {
                TypeMethodReference typeMethodRef = (TypeMethodReference)node;
                v0 = typeMethodRef.getName();
            } else if (node instanceof SuperMethodReference) {
                SuperMethodReference superMethodRef = (SuperMethodReference)node;
                v0 = superMethodRef.getName();
            } else if (node instanceof ExpressionMethodReference) {
                ExpressionMethodReference exprMethodRef = (ExpressionMethodReference)node;
                v0 = exprMethodRef.getName();
            } else {
                v0 = name = null;
            }
            if (name == null) {
                return this.toResponse(0);
            }
            if (this.locator.matchesName(this.locator.pattern.selector, name.getIdentifier().toCharArray())) {
                nodeSet.setMustResolve(true);
                return this.toResponse(nodeSet.addMatch((ASTNode)node, 2), true);
            }
        }
        return this.toResponse(0);
    }

    @Override
    public LocatorResponse match(Expression expression, NodeSetWrapper nodeSet, MatchLocator locator) {
        int level = 0;
        if (expression instanceof SuperMethodInvocation) {
            SuperMethodInvocation node = (SuperMethodInvocation)expression;
            if (this.pattern.fineGrain != 0 && (this.pattern.fineGrain & 0x1000000) == 0) {
                return this.toResponse(0);
            }
            level = this.matchReference(node.getName(), node.arguments());
        }
        if (expression.getLocationInParent() == SingleMemberAnnotation.VALUE_PROPERTY && this.locator.pattern.matchesName(this.locator.pattern.selector, "value".toCharArray()) && this.locator.pattern.parameterCount == 0) {
            level = 2;
        }
        if (level == 0) {
            return this.toResponse(0);
        }
        return this.toResponse(nodeSet.addMatch((ASTNode)expression, level), true);
    }

    @Override
    public LocatorResponse match(Name node, NodeSetWrapper nodeSet, MatchLocator locator) {
        String lastSegment;
        if (MethodInvocation.NAME_PROPERTY == node.getLocationInParent() || TypeMethodReference.NAME_PROPERTY == node.getLocationInParent() || ExpressionMethodReference.NAME_PROPERTY == node.getLocationInParent() || SuperMethodReference.NAME_PROPERTY == node.getLocationInParent()) {
            return this.toResponse(0);
        }
        if (node.getLocationInParent() == MemberValuePair.NAME_PROPERTY && this.locator.pattern.parameterCount == 0 && node instanceof SimpleName) {
            SimpleName simpleName = (SimpleName)node;
            return this.toResponse(this.matchReference(simpleName, null));
        }
        String name = node.toString();
        String[] segments = name.split("\\.");
        String string = lastSegment = segments == null || segments.length == 0 ? null : segments[segments.length - 1];
        boolean matchesLastSegment = this.locator.pattern.selector == null ? true : this.locator.matchesName(this.locator.pattern.selector, (lastSegment == null ? "" : lastSegment).toCharArray());
        boolean matchesPrefix = this.locator.pattern.declaringPackageName == null ? true : name.startsWith(new String(this.locator.pattern.declaringPackageName));
        int level = matchesLastSegment && matchesPrefix ? 2 : 0;
        return this.toResponse(level);
    }

    protected int matchMethod(ASTNode node, IMethodBinding method, boolean skipImpossibleArg, boolean bindingIsDeclaration) {
        if (!this.locator.matchesName(this.locator.pattern.selector, method.getName().toCharArray())) {
            return 0;
        }
        int level = this.matchMethodBindingReturn(method);
        if (level == 0) {
            return level;
        }
        if (this.pattern.declaringSimpleName == null && this.locator.pattern.returnSimpleName != null && (level = this.resolveLevelForType(this.locator.pattern.returnSimpleName, this.locator.pattern.returnQualification, method.getReturnType())) == 0) {
            return level;
        }
        if ((level = this.matchMethodParametersTypes(node, method, skipImpossibleArg, level)) == 0) {
            return level;
        }
        if ((level = this.matchMethodTypeArguments(node, method, skipImpossibleArg, level, bindingIsDeclaration)) == 0) {
            return level;
        }
        int typeParamMatches = this.validateReceiverTypeArguments(node, method, level, bindingIsDeclaration);
        if (typeParamMatches == 3) {
            level = 0;
        }
        if (typeParamMatches == 2) {
            level = 4;
        }
        if (this.isPatternExactMatch() && typeParamMatches == 3) {
            return 0;
        }
        boolean isErasurePattern = this.isPatternErasureMatch();
        boolean isEquivPattern = this.isPatternEquivalentMatch();
        if (level == 4 && !isErasurePattern && !isEquivPattern) {
            level = 0;
        }
        return level;
    }

    private int validateReceiverTypeArguments(ASTNode node, IMethodBinding method, int level, boolean bindingIsDeclaration) {
        MethodInvocation mi;
        boolean erasureMatch = this.isPatternErasureMatch();
        boolean equivMatch = this.isPatternEquivalentMatch();
        boolean exactMatch = this.isPatternExactMatch();
        boolean patternHasTypeArgs = this.locator.pattern.hasTypeArguments();
        if (patternHasTypeArgs && !erasureMatch && !equivMatch && !exactMatch) {
            return 3;
        }
        if (patternHasTypeArgs && !erasureMatch && !equivMatch && !exactMatch) {
            return 3;
        }
        char[][][] fromPattern = this.locator.pattern.getTypeArguments();
        if (fromPattern == null) {
            return 1;
        }
        if (node instanceof MethodInvocation && (mi = (MethodInvocation)node).getExpression() != null) {
            Expression expr = mi.getExpression();
            IBinding b = DOMASTNodeUtils.getBinding((ASTNode)expr);
            if (b instanceof IVariableBinding) {
                IVariableBinding vb = (IVariableBinding)b;
                b = vb.getType();
            }
            if (b instanceof ITypeBinding) {
                boolean emptyPatternParams;
                ITypeBinding tb = (ITypeBinding)b;
                boolean bindingIsRaw = tb.isRawType();
                ITypeBinding[] typeArgs = tb.getTypeArguments();
                if (fromPattern.length == 0) {
                    if (typeArgs == null || typeArgs.length == 0) {
                        return 1;
                    }
                    return 3;
                }
                char[][] thisLevelTypeParams = fromPattern[0];
                boolean bl = emptyPatternParams = thisLevelTypeParams == null || thisLevelTypeParams.length == 0;
                if (emptyPatternParams) {
                    if (exactMatch && emptyPatternParams && typeArgs != null && typeArgs.length > 0) {
                        return 3;
                    }
                } else {
                    if (typeArgs == null || typeArgs.length != thisLevelTypeParams.length) {
                        if (thisLevelTypeParams.length == 0) {
                            return 2;
                        }
                        if (typeArgs.length == 0) {
                            if (equivMatch && bindingIsRaw) {
                                return 1;
                            }
                            if (!(bindingIsRaw || equivMatch || erasureMatch)) {
                                return 3;
                            }
                            if (!equivMatch || bindingIsRaw) {
                                return 1;
                            }
                        }
                        return 3;
                    }
                    for (int j = 0; j < thisLevelTypeParams.length; ++j) {
                        boolean singleTypeArgMatches;
                        ITypeBinding domBinding = typeArgs[j];
                        String patternSig = new String(thisLevelTypeParams[j]);
                        IBinding patternBinding = JdtCoreDomPackagePrivateUtility.findBindingForType(node, patternSig);
                        if (patternBinding == null) {
                            boolean plusOrMinus = patternSig.startsWith("+") || patternSig.startsWith("-");
                            String safePatternString = plusOrMinus ? patternSig.substring(1) : patternSig;
                            patternBinding = safePatternString.startsWith("Q") ? JdtCoreDomPackagePrivateUtility.findUnresolvedBindingForType(node, patternSig) : JdtCoreDomPackagePrivateUtility.findBindingForType(node, safePatternString);
                        }
                        if (singleTypeArgMatches = TypeArgumentMatchingUtility.validateSingleTypeArgMatches(exactMatch, patternSig, patternBinding, (IBinding)domBinding, (PatternLocator)this.locator)) continue;
                        return 2;
                    }
                }
            }
        }
        return 1;
    }

    private ITypeBinding findPossiblyUnresolvedBindingForType(ASTNode node, String patternSig) {
        ITypeBinding ptb;
        ITypeBinding patternBinding;
        IBinding iBinding = JdtCoreDomPackagePrivateUtility.findBindingForType(node, patternSig);
        ITypeBinding iTypeBinding = patternBinding = iBinding instanceof ITypeBinding ? (ptb = (ITypeBinding)iBinding) : null;
        if (patternBinding == null) {
            String safePatternString;
            boolean plusOrMinus = patternSig.startsWith("+") || patternSig.startsWith("-");
            String string = safePatternString = plusOrMinus ? patternSig.substring(1) : patternSig;
            if (safePatternString.startsWith("Q")) {
                ITypeBinding ptb2;
                IBinding iBinding2 = JdtCoreDomPackagePrivateUtility.findBindingForType(node, patternSig);
                patternBinding = iBinding2 instanceof ITypeBinding ? (ptb2 = (ITypeBinding)iBinding2) : null;
            }
        }
        return patternBinding;
    }

    private boolean isPatternErasureMatch() {
        int r = this.locator.pattern.getMatchRule();
        return (r & 0x10) == 16;
    }

    private boolean isPatternEquivalentMatch() {
        int r = this.locator.pattern.getMatchRule();
        return (r & 0x20) == 32;
    }

    private boolean isPatternExactMatch() {
        int r = this.locator.pattern.getMatchRule();
        return (r & 0x40) == 64;
    }

    private int matchMethodTypeArguments(ASTNode node, IMethodBinding method, boolean skipImpossibleArg, int level, boolean bindingIsDeclaration) {
        boolean potentialMatchOnly = false;
        if (this.locator.pattern.hasMethodArguments()) {
            boolean isExactPattern = this.isPatternExactMatch();
            boolean isErasurePattern = this.isPatternErasureMatch();
            boolean isEquivPattern = this.isPatternEquivalentMatch();
            boolean methodIsRaw = method.isRawMethod();
            ITypeBinding[] argBindings = node instanceof MethodDeclaration ? method.getTypeParameters() : method.getTypeArguments();
            char[][] goal = this.locator.pattern.methodArguments;
            if (goal.length > 0 && methodIsRaw && isExactPattern) {
                return 0;
            }
            if (goal == null || goal.length == 0) {
                return level;
            }
            if (argBindings == null || argBindings.length == 0) {
                List typeArgsFromNode = null;
                if (node instanceof MethodInvocation) {
                    MethodInvocation mi = (MethodInvocation)node;
                    typeArgsFromNode = mi.typeArguments();
                    potentialMatchOnly = !bindingIsDeclaration;
                } else if (node instanceof MethodDeclaration) {
                    MethodDeclaration md = (MethodDeclaration)node;
                    typeArgsFromNode = md.typeParameters();
                }
                if (typeArgsFromNode != null && typeArgsFromNode.size() > 0) {
                    List<ITypeBinding> tmp = typeArgsFromNode.stream().map(DOMASTNodeUtils::getBinding).filter(x -> x instanceof ITypeBinding).map(x -> (ITypeBinding)x).collect(Collectors.toList());
                    argBindings = tmp.toArray(new ITypeBinding[tmp.size()]);
                }
            }
            if (argBindings == null || argBindings.length == 0) {
                if (goal == null || goal.length == 0) {
                    return level;
                }
                if (isExactPattern || !isErasurePattern && !isEquivPattern) {
                    return 0;
                }
                if (!bindingIsDeclaration) {
                    return 0;
                }
                ITypeBinding[] tmp = method.getTypeParameters();
                if (tmp != null && tmp.length > 0) {
                    return goal != null && goal.length == tmp.length ? 4 : 0;
                }
                return 4;
            }
            if (argBindings.length != goal.length) {
                return 0;
            }
            boolean inaccurateFound = false;
            boolean erasureFound = false;
            for (int i = 0; i < argBindings.length; ++i) {
                String goaliString = new String(goal[i]);
                ITypeBinding patternBinding = this.findPossiblyUnresolvedBindingForType(node, goaliString);
                ITypeBinding argBinding = argBindings[i];
                if (argBinding.isTypeVariable() && patternBinding == null) continue;
                boolean match = TypeArgumentMatchingUtility.validateSingleTypeArgMatches(isExactPattern, goaliString, (IBinding)patternBinding, (IBinding)argBindings[i]) | (bindingIsDeclaration && patternBinding != null && patternBinding.isCastCompatible(argBinding));
                if (match) continue;
                if (isExactPattern || !isErasurePattern && !isEquivPattern) {
                    return 0;
                }
                if (potentialMatchOnly) {
                    inaccurateFound = true;
                    continue;
                }
                erasureFound = true;
            }
            if (inaccurateFound) {
                return 1;
            }
            if (erasureFound) {
                return 4;
            }
        }
        return level;
    }

    protected int matchMethodBindingReturn(IMethodBinding binding) {
        if (this.locator.pattern.declaringSimpleName == null && this.resolveLevelForType(this.locator.pattern.returnSimpleName, this.locator.pattern.returnQualification, binding.getReturnType()) == 0) {
            return 0;
        }
        return 3;
    }

    private int matchMethodParametersTypes(ASTNode node, IMethodBinding method, boolean skipImpossibleArg, int level) {
        int parameterCount;
        boolean isExactPattern = this.isPatternExactMatch();
        int n = parameterCount = this.locator.pattern.parameterSimpleNames == null ? -1 : this.locator.pattern.parameterSimpleNames.length;
        if (parameterCount > -1) {
            if (method.getParameterTypes() == null) {
                return 1;
            }
            if (parameterCount != method.getParameterTypes().length) {
                return 0;
            }
            if (method.isRecovered()) {
                return 1;
            }
            boolean foundTypeVariable = false;
            IMethodBinding focusMethodBinding = null;
            boolean checkedFocus = false;
            boolean isBinary = this.locator.pattern != null && this.locator.pattern.focus instanceof BinaryMethod;
            ITypeBinding[] paramTypes = method.getParameterTypes();
            for (int i = 0; i < parameterCount; ++i) {
                ITypeBinding argType = paramTypes[i];
                int newLevel = 0;
                boolean foundLevel = false;
                if (argType.isMember() || this.locator.pattern.parameterQualifications[i] != null) {
                    ITypeBinding[] parameters;
                    if (!checkedFocus) {
                        focusMethodBinding = this.getDOMASTMethodBinding(this.locator.pattern, node.getAST());
                        checkedFocus = true;
                    }
                    if (focusMethodBinding != null && (parameters = focusMethodBinding.getParameterTypes()).length >= parameterCount) {
                        newLevel = (isBinary ? argType.getErasure().isEqualTo((IBinding)parameters[i].getErasure()) : argType.isEqualTo((IBinding)parameters[i])) ? 3 : 0;
                        foundLevel = true;
                    }
                } else {
                    newLevel = this.resolveLevelForType(this.locator.pattern.parameterSimpleNames[i], this.locator.pattern.parameterQualifications[i], argType);
                    if (argType.isGenericType() && newLevel == 3) {
                        boolean patternHasTypeArgs;
                        ITypeBinding[] nestedParams = argType.getTypeParameters();
                        char[][][][] ptaAll = this.locator.pattern.parametersTypeArguments;
                        char[][][] ptaThisLevel = ptaAll == null || ptaAll.length == 0 ? null : ptaAll[0];
                        boolean bl = patternHasTypeArgs = ptaThisLevel != null && ptaThisLevel.length > i;
                        if (patternHasTypeArgs) {
                            char[][] thisParamTypeArgs = ptaThisLevel[i];
                            for (int q = 0; q < thisParamTypeArgs.length; ++q) {
                                ITypeBinding fromBinding;
                                char[] fromPattern = thisParamTypeArgs[q];
                                ITypeBinding iTypeBinding = fromBinding = nestedParams == null || nestedParams.length == 0 ? null : nestedParams[q];
                                if (fromBinding == null) {
                                    newLevel = 1;
                                    continue;
                                }
                                String fromPatternString = new String(fromPattern);
                                ITypeBinding patternBinding = this.findPossiblyUnresolvedBindingForType(node, fromPatternString);
                                boolean match = TypeArgumentMatchingUtility.validateSingleTypeArgMatches(isExactPattern, fromPatternString, (IBinding)patternBinding, (IBinding)fromBinding);
                                if (match) continue;
                                newLevel = 1;
                            }
                        }
                    }
                }
                if (level <= newLevel) continue;
                if (newLevel == 0) {
                    if (skipImpossibleArg) {
                        if (!foundLevel) {
                            newLevel = level;
                        }
                    } else if (argType.isTypeVariable()) {
                        newLevel = level;
                        foundTypeVariable = true;
                    } else {
                        return 0;
                    }
                }
                level = newLevel;
            }
            if (foundTypeVariable) {
                if (!Modifier.isStatic((int)method.getModifiers()) && !Modifier.isPrivate((int)method.getModifiers())) {
                    if (!checkedFocus) {
                        focusMethodBinding = this.getDOMASTMethodBinding(this.locator.pattern, node.getAST());
                    }
                    if (focusMethodBinding != null && (focusMethodBinding.overrides(method) || method.overrides(focusMethodBinding))) {
                        return 3;
                    }
                }
                return 0;
            }
        }
        return level;
    }

    public IMethodBinding getDOMASTMethodBinding(MethodPattern methodPattern, AST ast) {
        ITypeBinding type;
        Object typeName;
        String declaringPackage = methodPattern.declaringPackageName != null ? new String(methodPattern.declaringPackageName) : "";
        String declaringQualification = methodPattern.declaringQualification != null ? new String(methodPattern.declaringQualification) : "";
        String simpleName = methodPattern.declaringSimpleName != null ? new String(methodPattern.declaringSimpleName) : "";
        Object object = typeName = declaringQualification.length() > declaringPackage.length() && declaringQualification.startsWith(declaringPackage) ? declaringPackage + "." + declaringQualification.substring(declaringPackage.length() + 1).replace('.', '$') + "$" + simpleName : declaringQualification + "." + simpleName;
        if (((String)typeName).startsWith(".")) {
            typeName = ((String)typeName).substring(1);
        }
        if ((type = ast.resolveWellKnownType((String)typeName)) != null) {
            for (IMethodBinding method : type.getDeclaredMethods()) {
                if (!Objects.equals(method.getJavaElement(), methodPattern.focus)) continue;
                return method;
            }
        }
        return null;
    }

    private int computeResolveLevel(ASTNode node, IBinding binding, MatchLocator locator) {
        SingleMemberAnnotation singleMemberAnnotation;
        IMemberValuePairBinding[] valuePairs;
        ASTNode aSTNode;
        if (node.getLocationInParent() == SingleMemberAnnotation.VALUE_PROPERTY && (aSTNode = node.getParent()) instanceof SingleMemberAnnotation && (valuePairs = (singleMemberAnnotation = (SingleMemberAnnotation)aSTNode).resolveAnnotationBinding().getDeclaredMemberValuePairs()) != null && valuePairs.length > 0) {
            binding = valuePairs[0].getMethodBinding();
        }
        if (binding instanceof IMethodBinding) {
            IMethodBinding method = (IMethodBinding)binding;
            boolean skipVerif = this.locator.pattern.findDeclarations;
            return this.resolveLevelForNodeWithMethodBinding(node, method, null, skipVerif, true);
        }
        return 0;
    }

    protected int resolveLevel(MethodInvocation messageSend) {
        IMethodBinding invocationBinding = messageSend.resolveMethodBinding();
        ITypeBinding initialReceiverType = messageSend.getExpression() != null ? messageSend.getExpression().resolveTypeBinding() : null;
        return this.resolveLevelForNodeWithMethodBinding((ASTNode)messageSend, invocationBinding, initialReceiverType, false, false);
    }

    protected int resolveLevelForNodeWithMethodBinding(ASTNode messageSend, IMethodBinding invocationBinding, ITypeBinding initialReceiverType, boolean skipVerif, boolean nullParamsForSubTypeCheck) {
        int invocOrDeclLevel;
        boolean isExactPattern = this.isPatternExactMatch();
        boolean isErasurePattern = this.isPatternErasureMatch();
        boolean isEquivPattern = this.isPatternEquivalentMatch();
        IMethodBinding invocationOrDeclarationBinding = invocationBinding;
        IMethodBinding declarationBinding = null;
        if (invocationOrDeclarationBinding == null) {
            return 1;
        }
        int invocationLevel = this.matchMethod(messageSend, invocationBinding, skipVerif, false);
        int declarationLevel = 0;
        if (invocationLevel == 0) {
            declarationBinding = invocationBinding.getMethodDeclaration();
            declarationLevel = this.matchMethod(messageSend, declarationBinding, skipVerif, true);
            if (declarationLevel == 0) {
                return 0;
            }
            invocationOrDeclarationBinding = declarationBinding;
        }
        int n = invocOrDeclLevel = invocationLevel == 0 ? declarationLevel : invocationLevel;
        if (invocationBinding.isRawMethod() && (this.locator.pattern.hasTypeArguments() || this.locator.pattern.hasTypeParameters())) {
            invocOrDeclLevel = this.findWeakerLevel(invocOrDeclLevel, 4);
        }
        if (this.pattern.declaringSimpleName == null && this.pattern.declaringQualification == null) {
            return invocOrDeclLevel;
        }
        int declaringLevel = this.resolveLevelForType(this.pattern.declaringSimpleName, this.pattern.declaringQualification, invocationOrDeclarationBinding.getDeclaringClass());
        if (declaringLevel == 0) {
            ITypeBinding receiverType;
            ITypeBinding iTypeBinding = receiverType = initialReceiverType != null ? initialReceiverType : invocationOrDeclarationBinding.getDeclaringClass();
            if (this.shouldResolveSubSuperLevel(messageSend, receiverType, invocationOrDeclarationBinding, invocOrDeclLevel)) {
                declaringLevel = this.resolveSubSuperLevel(messageSend, receiverType, invocationOrDeclarationBinding, invocOrDeclLevel, nullParamsForSubTypeCheck);
            }
        }
        int declaringFlavors = declaringLevel & 0xFFFFFFF0;
        int noFlavorInvocOrDecl = invocOrDeclLevel & 0xF;
        int noFlavorDeclaringLevel = declaringLevel & 0xF;
        int weakerMethod = this.findWeakerLevel(noFlavorInvocOrDecl, noFlavorDeclaringLevel);
        int matchLevel = weakerMethod & 0xF;
        int retval = weakerMethod;
        if (messageSend instanceof MethodDeclaration && retval == 4 && isEquivPattern) {
            return 3;
        }
        if (matchLevel != 3) {
            char[][][] superTypeNames;
            boolean isDefault = Modifier.isDefault((int)invocationOrDeclarationBinding.getModifiers());
            boolean nullFocus = this.pattern.focus == null;
            char[][][] cArray = superTypeNames = isDefault && nullFocus ? this.samePkgSuperDeclaringTypeNames : this.allSuperDeclaringTypeNames;
            if (superTypeNames != null && this.resolveLevelAsSuperInvocation(invocationOrDeclarationBinding.getDeclaringClass(), invocationOrDeclarationBinding.getParameterTypes(), superTypeNames, true)) {
                declaringLevel = invocOrDeclLevel | 0x200;
            }
            if ((declaringLevel & 0xFFFFFFF0) != 0) {
                retval = declaringLevel;
            } else if (isExactPattern || !isErasurePattern && !isEquivPattern) {
                retval = 0;
            } else if (isEquivPattern && matchLevel == 4) {
                retval = 0;
            }
        } else if (declaringFlavors != 0) {
            retval = declaringLevel;
        }
        return retval;
    }

    private boolean shouldResolveSubSuperLevel(ASTNode messageSend, ITypeBinding receiverType, IMethodBinding invocationOrDeclarationBinding, int invocOrDeclLevel) {
        boolean excluded;
        if (receiverType != null && receiverType.isArray()) {
            receiverType = messageSend.getAST().resolveWellKnownType(Object.class.getName());
        }
        boolean isVirtuallyInvoked = this.isVirtualInvoke(invocationOrDeclarationBinding);
        boolean bl = excluded = receiverType == null || receiverType.isArray() || receiverType.isIntersectionType();
        return isVirtuallyInvoked && !excluded;
    }

    private int resolveSubSuperLevel(ASTNode messageSend, ITypeBinding receiverType, IMethodBinding invocationOrDeclarationBinding, int invocOrDeclLevel, boolean useNullParameterTypes) {
        if (receiverType == null || receiverType.isArray()) {
            receiverType = messageSend.getAST().resolveWellKnownType(Object.class.getName());
        }
        IPackageBinding packageBinding = receiverType.getPackage();
        boolean isDefault = Modifier.isDefault((int)invocationOrDeclarationBinding.getModifiers());
        String packageBindingName = packageBinding != null ? packageBinding.getName() : null;
        ITypeBinding[] parameterTypes = useNullParameterTypes ? null : invocationOrDeclarationBinding.getParameterTypes();
        String bindingName = invocationOrDeclarationBinding.getName();
        int retLevel = this.resolveLevelAsSubtype(this.pattern.declaringSimpleName, this.pattern.declaringQualification, receiverType, bindingName, parameterTypes, packageBindingName, isDefault, invocationOrDeclarationBinding);
        if (retLevel == 0) {
            if (invocationOrDeclarationBinding.getDeclaringClass() == null || this.allSuperDeclaringTypeNames == null) {
                retLevel = 1;
            } else {
                char[][][] superTypeNames;
                boolean nullFocusDefault = Modifier.isDefault((int)invocationOrDeclarationBinding.getModifiers()) && this.pattern.focus == null;
                char[][][] cArray = superTypeNames = nullFocusDefault ? this.samePkgSuperDeclaringTypeNames : this.allSuperDeclaringTypeNames;
                if (superTypeNames != null && this.resolveLevelAsSuperInvocation(receiverType, invocationOrDeclarationBinding.getParameterTypes(), superTypeNames, true)) {
                    retLevel = invocOrDeclLevel | 0x200;
                }
            }
        }
        return retLevel;
    }

    protected boolean isVirtualInvoke(IMethodBinding method) {
        String t = method == null ? null : (method.getDeclaringClass() == null ? null : (method.getDeclaringClass().getPackage() == null ? null : method.getDeclaringClass().getPackage().getName()));
        boolean notStatic = !Modifier.isStatic((int)method.getModifiers());
        boolean notPrivate = !Modifier.isPrivate((int)method.getModifiers());
        boolean isDefault = Modifier.isDefault((int)method.getModifiers());
        boolean nonNullFocus = this.pattern.focus != null;
        boolean packageMatch = CharOperation.equals((char[])this.pattern.declaringPackageName, (char[])t.toCharArray());
        boolean r = notStatic && notPrivate && (!isDefault || !nonNullFocus || packageMatch);
        return r;
    }

    @Override
    public LocatorResponse resolveLevel(ASTNode node, IBinding binding, MatchLocator locator) {
        if (node instanceof MethodInvocation) {
            MethodInvocation invocation = (MethodInvocation)node;
            return this.toResponse(this.resolveLevel(invocation));
        }
        int level = this.computeResolveLevel(node, binding, locator);
        if (node instanceof MethodDeclaration) {
            MethodDeclaration declaration = (MethodDeclaration)node;
            if (binding != null) {
                if (level == 0) {
                    return this.toResponse(0);
                }
                boolean matchesDecl = this.matchesDeclaration(node, binding.getJavaElement(), declaration.resolveBinding(), locator);
                return this.toResponse(matchesDecl ? level : 0);
            }
        }
        return this.toResponse(level);
    }

    private int findWeakerLevel(int i, int j) {
        int jIndex;
        int levelI = i & 0xF;
        int levelJ = j & 0xF;
        int[] ints = new int[]{0, 2, 1, 4, 3};
        List list = Arrays.stream(ints).boxed().collect(Collectors.toList());
        int iIndex = list.indexOf(levelI);
        return iIndex > (jIndex = list.indexOf(levelJ)) ? j : i;
    }

    protected int resolveLevelAsSubtype_basic(char[] simplePattern, char[] qualifiedPattern, ITypeBinding type, IMethodBinding method, String packageName, boolean isDefault, boolean methodIdenticalToOriginal) {
        if (type == null) {
            return 1;
        }
        int level = this.resolveLevelForType(simplePattern, qualifiedPattern, type);
        if (level != 0) {
            if (isDefault && !Objects.equals(packageName, type.getPackage().getName())) {
                return 0;
            }
            if (!methodIdenticalToOriginal && this.isConcrete(method, type)) {
                level |= 0x800;
            }
            return level;
        }
        return -1;
    }

    private boolean isConcrete(IMethodBinding method, ITypeBinding type) {
        boolean nullMethod = method == null;
        boolean abstractMethod = method == null ? false : Modifier.isAbstract((int)method.getModifiers());
        boolean abstractType = Modifier.isAbstract((int)type.getModifiers());
        return (!nullMethod && !abstractMethod || !abstractType) && !type.isInterface();
    }

    protected int resolveLevelAsSubtype_super(char[] simplePattern, char[] qualifiedPattern, ITypeBinding type, String methodName, ITypeBinding[] argumentTypes, IMethodBinding method, String packageName, boolean isDefault, IMethodBinding originalQuery) {
        int level;
        if (!type.isInterface() && !type.getQualifiedName().equals(Object.class.getName()) && (level = this.resolveLevelAsSubtype(simplePattern, qualifiedPattern, type.getSuperclass(), methodName, argumentTypes, packageName, isDefault, originalQuery)) != 0) {
            if (method != null) {
                if ((level & 0x800) != 0) {
                    return 0;
                }
                if (this.isConcrete(method, type)) {
                    level |= 0x800;
                }
            }
            return level | 0x400;
        }
        return -1;
    }

    protected int resolveLevelAsSubtype_interfaces(char[] simplePattern, char[] qualifiedPattern, ITypeBinding type, String methodName, ITypeBinding[] argumentTypes, IMethodBinding method, String packageName, boolean isDefault, IMethodBinding originalQuery) {
        boolean concrete = this.isConcrete(method, type);
        ITypeBinding[] interfaces = type.getInterfaces();
        if (interfaces == null) {
            return -1;
        }
        for (ITypeBinding ref : interfaces) {
            int level = this.resolveLevelAsSubtype(simplePattern, qualifiedPattern, ref, methodName, null, packageName, isDefault, originalQuery);
            if (level == 0) continue;
            if (concrete) {
                level |= 0x800;
            }
            return level | 0x400;
        }
        return -1;
    }

    private boolean compareDeclaringClass(IMethodBinding b1, IMethodBinding b2) {
        if (b1 == null || b2 == null) {
            return b1 == b2;
        }
        String b1ClassFqqn = b1 == null || b1.getDeclaringClass() == null ? null : b1.getDeclaringClass().getQualifiedName();
        String b2ClassFqqn = b2 == null || b2.getDeclaringClass() == null ? null : b2.getDeclaringClass().getQualifiedName();
        String b1TrimTypeParms = b1ClassFqqn.contains("<") ? b1ClassFqqn.substring(0, b1ClassFqqn.indexOf("<")) : b1ClassFqqn;
        String b2TrimTypeParms = b2ClassFqqn.contains("<") ? b2ClassFqqn.substring(0, b2ClassFqqn.indexOf("<")) : b2ClassFqqn;
        return b1TrimTypeParms.equals(b2TrimTypeParms);
    }

    protected int resolveLevelAsSubtype(char[] simplePattern, char[] qualifiedPattern, ITypeBinding type, String methodName, ITypeBinding[] argumentTypes, String packageName, boolean isDefault, IMethodBinding originalQuery) {
        boolean methodIdenticalToOriginal;
        IMethodBinding method = this.getDOMASTMethodBinding(type, methodName, argumentTypes);
        int r1 = this.resolveLevelAsSubtype_basic(simplePattern, qualifiedPattern, type, method, packageName, isDefault, methodIdenticalToOriginal = this.compareDeclaringClass(originalQuery, method));
        if (r1 != -1) {
            return r1;
        }
        r1 = this.resolveLevelAsSubtype_super(simplePattern, qualifiedPattern, type, methodName, argumentTypes, method, packageName, isDefault, originalQuery);
        if (r1 != -1) {
            return r1;
        }
        r1 = this.resolveLevelAsSubtype_interfaces(simplePattern, qualifiedPattern, type, methodName, argumentTypes, method, packageName, isDefault, originalQuery);
        if (r1 != -1) {
            return r1;
        }
        return 0;
    }

    private boolean resolveLevelAsSuperInvocation(ITypeBinding type, ITypeBinding[] argumentTypes, char[][][] superTypeNames, boolean methodAlreadyVerified) {
        char[][] compoundName = (char[][])Arrays.stream(type.getQualifiedName().split("\\.")).map(String::toCharArray).toArray(x$0 -> new char[x$0][]);
        for (char[][] superTypeName : superTypeNames) {
            if (!CharOperation.equals((char[][])superTypeName, (char[][])compoundName)) continue;
            if (methodAlreadyVerified) {
                return true;
            }
            if (!Arrays.stream(type.getDeclaredMethods()).filter(method -> this.locator.matchesName(this.locator.pattern.selector, method.getName().toCharArray())).anyMatch(method -> Arrays.equals(method.getParameterTypes(), argumentTypes, Comparator.comparing(t -> t.getErasure().getKey())))) continue;
            return true;
        }
        if (type.isInterface()) {
            ITypeBinding[] interfaces = type.getInterfaces();
            if (interfaces == null) {
                return false;
            }
            for (ITypeBinding ref : interfaces) {
                if (!this.resolveLevelAsSuperInvocation(ref, argumentTypes, superTypeNames, false)) continue;
                return true;
            }
        }
        return false;
    }

    public void initializePolymorphicSearch(MatchLocator locator) {
        long start = 0L;
        if (BasicSearchEngine.VERBOSE) {
            start = System.currentTimeMillis();
        }
        try {
            SuperTypeNamesCollector namesCollector = new SuperTypeNamesCollector((SearchPattern)this.pattern, this.pattern.declaringSimpleName, this.pattern.declaringQualification, locator, this.pattern.declaringType, locator.progressMonitor);
            this.allSuperDeclaringTypeNames = namesCollector.collect();
            this.samePkgSuperDeclaringTypeNames = namesCollector.getSamePackageSuperTypeNames();
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        if (BasicSearchEngine.VERBOSE) {
            JavaModelManager.trace((String)("Time to initialize polymorphic search: " + (System.currentTimeMillis() - start)));
        }
    }

    public boolean matchesDeclaration(ASTNode reference, IJavaElement element, IMethodBinding methodBinding, MatchLocator locator) {
        if (this.methodDeclarationsWithInvalidParam.containsKey(reference)) {
            Boolean report = this.methodDeclarationsWithInvalidParam.get(reference);
            if (report != null) {
                return report;
            }
            if (this.matchOverriddenMethod(methodBinding.getDeclaringClass(), methodBinding, null)) {
                this.methodDeclarationsWithInvalidParam.put(reference, Boolean.TRUE);
                return true;
            }
            if (this.isTypeInSuperDeclaringTypeNames(methodBinding.getDeclaringClass().getQualifiedName())) {
                IMethodBinding patternBinding = this.getMethodBindingFromPattern(reference.getAST());
                if (patternBinding != null && !this.matchOverriddenMethod(patternBinding.getDeclaringClass(), patternBinding, methodBinding)) {
                    this.methodDeclarationsWithInvalidParam.put(reference, Boolean.FALSE);
                    return false;
                }
                this.methodDeclarationsWithInvalidParam.put(reference, Boolean.TRUE);
                return true;
            }
            this.methodDeclarationsWithInvalidParam.put(reference, Boolean.FALSE);
            return false;
        }
        return true;
    }

    private boolean isTypeInSuperDeclaringTypeNames(String qualifiedName) {
        if (this.allSuperDeclaringTypeNames == null) {
            return false;
        }
        char[][] compound = (char[][])Arrays.stream(qualifiedName.split("\\.")).map(String::toCharArray).toArray(x$0 -> new char[x$0][]);
        return Arrays.stream(this.allSuperDeclaringTypeNames).anyMatch(name -> CharOperation.equals((char[][])name, (char[][])compound));
    }

    private boolean matchOverriddenMethod(ITypeBinding type, IMethodBinding method, IMethodBinding matchMethod) {
        if (type == null || this.pattern.selector == null) {
            return false;
        }
        ArrayList<ITypeBinding> parents = new ArrayList<ITypeBinding>();
        if (!type.isInterface() && !Objects.equals(type.getQualifiedName(), Object.class.getName())) {
            parents.add(type.getSuperclass());
        }
        parents.addAll(Arrays.asList(type.getInterfaces()));
        for (ITypeBinding superType : parents) {
            if (superType.isParameterizedType()) {
                for (IMethodBinding candidate : superType.getDeclaredMethods()) {
                    if (!Arrays.equals(candidate.getName().toCharArray(), this.pattern.selector) || !this.areParametersEqual(candidate, method) || !(matchMethod == null ? this.methodParametersEqualsPattern(candidate.getMethodDeclaration()) : this.areParametersEqual(candidate.getMethodDeclaration(), matchMethod))) continue;
                    return true;
                }
            }
            if (!this.matchOverriddenMethod(superType, method, matchMethod)) continue;
            return true;
        }
        return false;
    }

    private boolean areParametersEqual(IMethodBinding one, IMethodBinding another) {
        ITypeBinding[] second;
        ITypeBinding[] first = one.getParameterTypes();
        if (Objects.equals(first, second = another.getParameterTypes())) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        if (first.length != second.length) {
            return false;
        }
        for (int i = 0; i < first.length; ++i) {
            if (first[i].isEqualTo((IBinding)second[i])) continue;
            return false;
        }
        return true;
    }

    private boolean methodParametersEqualsPattern(IMethodBinding method) {
        ITypeBinding[] methodParameters = method.getParameterTypes();
        int length = methodParameters.length;
        if (length != this.pattern.parameterSimpleNames.length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            char[] paramQualifiedName = DOMMethodLocator.qualifiedPattern((char[])this.pattern.parameterSimpleNames[i], (char[])this.pattern.parameterQualifications[i]);
            if (CharOperation.match((char[])paramQualifiedName, (char[])methodParameters[i].getName().toCharArray(), (boolean)this.isCaseSensitive)) continue;
            return false;
        }
        return true;
    }

    private IMethodBinding getMethodBindingFromPattern(AST context) {
        Optional<IMethodBinding> res;
        IMethod method;
        String type;
        ITypeBinding typeBinding;
        IJavaElement iJavaElement = this.pattern.focus;
        if (iJavaElement instanceof IMethod && (typeBinding = context.resolveWellKnownType(type = (method = (IMethod)iJavaElement).getDeclaringType().getFullyQualifiedName('$'))) != null && (res = Arrays.stream(typeBinding.getDeclaredMethods()).filter(child -> Objects.equals(method.getElementName(), child.getName())).filter(child -> method.getParameterTypes().length == child.getParameterTypes().length).filter(child -> Objects.equals(method, child.getJavaElement())).findFirst()).isPresent()) {
            return res.get();
        }
        return null;
    }

    @Override
    public void reportSearchMatch(MatchLocator locator, ASTNode node, SearchMatch match) throws CoreException {
        int currOffset;
        int newStart;
        int start;
        MethodInvocation iv;
        List l;
        IBinding method;
        IMethodBinding methodBinding;
        IBinding iBinding;
        if (!(node instanceof MethodDeclaration) && !(node instanceof AnnotationTypeMemberDeclaration) && (iBinding = DOMASTNodeUtils.getBinding(node)) instanceof IMethodBinding && ((methodBinding = (IMethodBinding)iBinding).isGenericMethod() || methodBinding.isParameterizedMethod()) && (iBinding = this.pattern.focus) instanceof IMethod) {
            method = (IMethod)iBinding;
            if (!this.pattern.hasMethodArguments()) {
                int rule = match.getRule();
                rule &= 0xFFFFFFBF;
                match.setRule(rule |= 0x30);
            }
        }
        if ((method = DOMASTNodeUtils.getBinding(node)) instanceof IMethodBinding && ((methodBinding = (IMethodBinding)method).isRawMethod() || methodBinding.getDeclaringClass().isRawType()) && (this.pattern.hasMethodArguments() || this.pattern.hasTypeArguments())) {
            int rule = match.getRule();
            rule &= 0xFFFFFFBF;
            match.setRule(rule |= 0x30);
        }
        if (this.preferParamaterizedNode() && node instanceof MethodInvocation && (l = (iv = (MethodInvocation)node).typeArguments()) != null && l.size() > 0 && (start = ((ASTNode)l.get(0)).getStartPosition()) > 0 && (newStart = start - 1) < (currOffset = match.getOffset())) {
            int diff = currOffset - newStart;
            match.setOffset(newStart);
            match.setLength(match.getLength() + diff);
        }
        SearchMatchingUtility.reportSearchMatch(locator, match);
    }

    private boolean preferParamaterizedNode() {
        boolean emptyTypeArgsPattern;
        int patternRule = this.locator.pattern.getMatchRule();
        boolean patternIsErasureMatch = this.isPatternErasureMatch();
        boolean patternIsEquivMatch = this.isPatternEquivalentMatch();
        boolean patternIsExactMatch = this.isPatternExactMatch();
        boolean hasMethodArgs = this.locator.pattern.hasMethodArguments();
        boolean hasMethodParams = this.locator.pattern.hasMethodParameters();
        boolean bl = emptyTypeArgsPattern = this.locator.pattern.methodArguments == null || this.locator.pattern.methodArguments.length == 0;
        if (patternIsEquivMatch || patternIsExactMatch) {
            return hasMethodArgs;
        }
        return !patternIsErasureMatch;
    }

    @Override
    public LocatorResponse match(LambdaExpression node, NodeSetWrapper nodeSet, MatchLocator locator) {
        if (this.locator.pattern.parameterCount == -1 || this.locator.pattern.parameterCount == node.parameters().size()) {
            nodeSet.setMustResolve(true);
            return this.toResponse(2);
        }
        return this.toResponse(0);
    }
}

