/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.groovy.search;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.ImportNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.expr.BinaryExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.ListExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.eclipse.jdt.groovy.core.util.GroovyUtils;
import org.eclipse.jdt.groovy.search.VariableScope;

public class AssignmentStorer {
    public void storeAssignment(BinaryExpression exp, VariableScope scope, ClassNode rhsType) {
        assert (exp.getOperation().isA(1100));
        if (exp instanceof DeclarationExpression) {
            DeclarationExpression decl = (DeclarationExpression)exp;
            if (decl.isMultipleAssignmentDeclaration()) {
                TupleExpression vars = decl.getTupleExpression();
                AssignmentStorer.handleMultiAssignment(vars, decl.getRightExpression(), scope, rhsType);
            } else {
                VariableExpression var = decl.getVariableExpression();
                AssignmentStorer.handleSingleAssignment(var, scope, rhsType);
            }
        } else {
            Expression lhs = exp.getLeftExpression();
            if (lhs instanceof TupleExpression) {
                TupleExpression tuple = (TupleExpression)lhs;
                AssignmentStorer.handleMultiAssignment(tuple, exp.getRightExpression(), scope, rhsType);
            } else {
                AssignmentStorer.handleSingleAssignment(lhs, scope, rhsType);
            }
        }
    }

    public void storeImport(ImportNode node, VariableScope scope) {
        block6: {
            FieldNode field;
            String name;
            ClassNode type;
            block5: {
                type = node.getType();
                if (!node.isStar() || type == null) break block5;
                List<FieldNode> fields = type.getFields();
                for (FieldNode field2 : fields) {
                    if (!AssignmentStorer.isStaticNotSynthetic(field2)) continue;
                    scope.addVariable(field2.getName(), field2.getType(), type);
                }
                List<MethodNode> methods = type.getMethods();
                for (MethodNode method : methods) {
                    if (!AssignmentStorer.isStaticNotSynthetic(method)) continue;
                    scope.addVariable(method.getName(), method.getReturnType(), type);
                }
                break block6;
            }
            if (!node.isStatic() || type == null || (name = node.getFieldName()) == null) break block6;
            String alias = node.getAlias();
            if (alias == null) {
                alias = name;
            }
            if (AssignmentStorer.isStaticNotSynthetic(field = type.getField(name))) {
                scope.addVariable(alias, field.getType(), type);
            }
            List<MethodNode> methods = type.getDeclaredMethods(name);
            for (MethodNode method : methods) {
                if (!AssignmentStorer.isStaticNotSynthetic(method)) continue;
                scope.addVariable(alias, method.getReturnType(), type);
            }
        }
    }

    private static void handleMultiAssignment(TupleExpression lhs, Expression rhs, VariableScope scope, ClassNode rhsListType) {
        List<Expression> lhsExprs = lhs.getExpressions();
        List rhsTypes = (List)rhs.getNodeMetaData("tuple.types");
        if (rhs instanceof ListExpression) {
            if (rhsTypes == null) {
                rhsTypes = ((ListExpression)rhs).getExpressions().stream().map(e -> e.getType()).collect(Collectors.toList());
            }
        } else {
            rhsTypes = rhsListType.isDerivedFrom(VariableScope.TUPLE_CLASS_NODE) && !rhsListType.equals(VariableScope.TUPLE_CLASS_NODE) ? Arrays.stream(GroovyUtils.getGenericsTypes(rhsListType)).map(gt -> gt.getType()).collect(Collectors.toList()) : Collections.emptyList();
        }
        int i = 0;
        int lhsSize = lhsExprs.size();
        int rhsSize = rhsTypes.size();
        while (i < lhsSize) {
            ClassNode rhsType;
            Expression lhsExpr = lhsExprs.get(i);
            ClassNode classNode = rhsType = i < rhsSize ? (ClassNode)rhsTypes.get(i) : AssignmentStorer.findComponentType(rhsListType);
            if (lhsExpr instanceof VariableExpression) {
                VariableExpression var = (VariableExpression)lhsExpr;
                scope.addVariable(var.getName(), AssignmentStorer.findVariableType(var, rhsType), null);
            }
            ++i;
        }
    }

    private static void handleSingleAssignment(Expression lhs, VariableScope scope, ClassNode rhsType) {
        if (lhs instanceof VariableExpression) {
            VariableExpression var = (VariableExpression)lhs;
            if (var.getAccessedVariable() == var) {
                scope.addVariable(var.getName(), AssignmentStorer.findVariableType(var, rhsType), null);
            } else if (scope.inScriptRunMethod() || scope.getEnclosingClosure() != null || scope.getEnclosingTypeDeclaration().equals(AssignmentStorer.findDeclaringType(var))) {
                scope.updateOrAddVariable(var.getName(), AssignmentStorer.findVariableType(var, rhsType), AssignmentStorer.findDeclaringType(var));
            } else {
                scope.updateVariable(var.getName(), AssignmentStorer.findVariableType(var, rhsType), AssignmentStorer.findDeclaringType(var));
            }
            scope.getWormhole().put("lhs", lhs);
        } else if (lhs instanceof ConstantExpression || lhs instanceof BinaryExpression) {
            scope.getWormhole().put("lhs", lhs);
            lhs.putNodeMetaData("rhsType", rhsType);
        } else if (lhs instanceof PropertyExpression) {
            PropertyExpression exp = (PropertyExpression)lhs;
            AssignmentStorer.handleSingleAssignment(exp.getProperty(), scope, rhsType);
        }
    }

    private static ClassNode findComponentType(ClassNode type) {
        return type == null ? VariableScope.OBJECT_CLASS_NODE : VariableScope.extractElementType(type);
    }

    private static ClassNode findDeclaringType(VariableExpression var) {
        if (var.getAccessedVariable() instanceof AnnotatedNode) {
            return ((AnnotatedNode)((Object)var.getAccessedVariable())).getDeclaringClass();
        }
        return null;
    }

    private static ClassNode findVariableType(VariableExpression var, ClassNode rhsType) {
        ClassNode varType = var.getOriginType();
        if (varType == null) {
            varType = var.getType();
        }
        if (varType != null && !VariableScope.isVoidOrObject(varType)) {
            return varType;
        }
        if (!VariableScope.isVoidOrObject(rhsType)) {
            return rhsType;
        }
        return VariableScope.OBJECT_CLASS_NODE;
    }

    private static boolean isStaticNotSynthetic(FieldNode node) {
        return node != null && (node.getModifiers() & 0x1008) == 8;
    }

    private static boolean isStaticNotSynthetic(MethodNode node) {
        return node != null && (node.getModifiers() & 0x1048) == 8;
    }
}

