/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.JobHelpers;
import org.eclipse.jdt.ls.core.internal.handlers.InlayHintVisitor;
import org.eclipse.jdt.ls.core.internal.handlers.InlayHintsParameterMode;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.InlayHint;
import org.eclipse.lsp4j.InlayHintParams;

public class InlayHintsHandler {
    private final PreferenceManager preferenceManager;

    public InlayHintsHandler(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
    }

    public List<InlayHint> inlayHint(InlayHintParams params, IProgressMonitor monitor) {
        IBuffer buffer;
        if (InlayHintsParameterMode.NONE.equals((Object)this.preferenceManager.getPreferences().getInlayHintsParameterMode())) {
            return Collections.emptyList();
        }
        JobHelpers.waitForJobs("DocumentLifeCycleJobs", monitor);
        String uri = params.getTextDocument().getUri();
        ITypeRoot typeRoot = JDTUtils.resolveTypeRoot(uri);
        if (typeRoot == null) {
            return Collections.emptyList();
        }
        CompilationUnit root = CoreASTProvider.getInstance().getAST(typeRoot, CoreASTProvider.WAIT_YES, monitor);
        if (root == null || monitor.isCanceled()) {
            return Collections.emptyList();
        }
        try {
            buffer = typeRoot.getBuffer();
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
            return Collections.emptyList();
        }
        int startLine = params.getRange().getStart().getLine();
        int startCharacter = params.getRange().getStart().getCharacter();
        int startOffset = JsonRpcHelpers.toOffset(buffer, startLine, startCharacter);
        int endLine = params.getRange().getEnd().getLine();
        int endCharacter = params.getRange().getEnd().getCharacter();
        int endOffset = JsonRpcHelpers.toOffset(buffer, endLine, endCharacter);
        InlayHintVisitor inlayHintVisitor = new InlayHintVisitor(startOffset, endOffset, typeRoot, this.preferenceManager);
        root.accept((ASTVisitor)inlayHintVisitor);
        return inlayHintVisitor.getInlayHints();
    }
}

