/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IParent;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeMemberDeclaration;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.EnumConstantDeclaration;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.PackageDeclaration;
import org.eclipse.jdt.core.dom.RecordDeclaration;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.internal.core.SourceMethod;
import org.eclipse.jdt.internal.core.manipulation.JavaElementLabelsCore;
import org.eclipse.jdt.ls.core.internal.DecompilerResult;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.ResourceUtils;
import org.eclipse.jdt.ls.core.internal.handlers.SymbolUtils;
import org.eclipse.jdt.ls.core.internal.managers.ContentProviderManager;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.SymbolTag;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pure;

public class DocumentSymbolHandler {
    PreferenceManager preferenceManager;
    private static IScanner fScanner;

    public DocumentSymbolHandler(PreferenceManager preferenceManager) {
        this.preferenceManager = preferenceManager;
    }

    public List<ExtendedDocumentSymbol> extendedDocumentSymbol(DocumentSymbolParams params, IProgressMonitor monitor) {
        ITypeRoot unit = JDTUtils.resolveTypeRoot(params.getTextDocument().getUri());
        if (unit == null || !unit.exists()) {
            return Collections.emptyList();
        }
        List<DocumentSymbol> symbols = this.getHierarchicalOutline(unit, monitor, true);
        return symbols.stream().map(s -> (ExtendedDocumentSymbol)((Object)s)).toList();
    }

    public List<Either<SymbolInformation, DocumentSymbol>> documentSymbol(DocumentSymbolParams params, IProgressMonitor monitor) {
        ITypeRoot unit = JDTUtils.resolveTypeRoot(params.getTextDocument().getUri());
        if (unit == null || !unit.exists()) {
            return Collections.emptyList();
        }
        if (this.preferenceManager.getClientPreferences().isHierarchicalDocumentSymbolSupported()) {
            List<DocumentSymbol> symbols = this.getHierarchicalOutline(unit, monitor, false);
            return symbols.stream().map(Either::forRight).collect(Collectors.toList());
        }
        SymbolInformation[] elements = this.getOutline(unit, monitor);
        return Arrays.asList(elements).stream().map(Either::forLeft).collect(Collectors.toList());
    }

    private SymbolInformation[] getOutline(ITypeRoot unit, IProgressMonitor monitor) {
        try {
            IJavaElement[] elements = unit.getChildren();
            ArrayList<SymbolInformation> symbols = new ArrayList<SymbolInformation>(elements.length);
            this.collectChildren(unit, elements, symbols, monitor);
            return symbols.toArray(new SymbolInformation[symbols.size()]);
        }
        catch (JavaModelException e) {
            if (!unit.exists()) {
                JavaLanguageServerPlugin.logError("Problem getting outline for " + unit.getElementName() + ": File not found.");
            } else {
                JavaLanguageServerPlugin.logException("Problem getting outline for " + unit.getElementName(), e);
            }
            return new SymbolInformation[0];
        }
    }

    private void collectChildren(ITypeRoot unit, IJavaElement[] elements, ArrayList<SymbolInformation> symbols, IProgressMonitor monitor) throws JavaModelException {
        IJavaElement[] iJavaElementArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Location location;
            SourceMethod method;
            int type;
            IJavaElement element = iJavaElementArray[n2];
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (element instanceof IParent) {
                IParent parent = (IParent)element;
                this.collectChildren(unit, SymbolUtils.filter(parent.getChildren()), symbols, monitor);
            }
            if (!((type = element.getElementType()) != 7 && type != 8 && type != 9 || element instanceof SourceMethod && JDTUtils.isGenerated((IMember)(method = (SourceMethod)element)) || (location = JDTUtils.toLocation(element)) == null)) {
                SymbolInformation si = new SymbolInformation();
                String name = JavaElementLabelsCore.getElementLabel((IJavaElement)element, (long)0x200009L);
                si.setName(name == null ? element.getElementName() : name);
                si.setKind(SymbolUtils.mapKind(element));
                if (JDTUtils.isDeprecated(element)) {
                    if (this.preferenceManager.getClientPreferences().isSymbolTagSupported()) {
                        si.setTags(List.of(SymbolTag.Deprecated));
                    } else {
                        si.setDeprecated(Boolean.valueOf(true));
                    }
                }
                if (element.getParent() != null) {
                    si.setContainerName(element.getParent().getElementName());
                }
                location.setUri(ResourceUtils.toClientUri(location.getUri()));
                si.setLocation(location);
                if (!symbols.contains(si)) {
                    symbols.add(si);
                }
            }
            ++n2;
        }
    }

    List<DocumentSymbol> getHierarchicalOutline(ITypeRoot unit, IProgressMonitor monitor, boolean includeInherited) {
        try {
            if (unit instanceof IClassFile && unit.getSourceRange() == null) {
                return this.getHierarchicalOutlineFromDecompiledSource(unit, monitor);
            }
            IJavaElement[] children = unit.getChildren();
            Stream<IJavaElement> childrenStream = Stream.of(SymbolUtils.filter(children));
            if (unit instanceof IClassFile) {
                childrenStream = Stream.concat(Stream.of(unit.getParent()), childrenStream);
                ISourceRange sourceRange = unit.getSourceRange();
                if (sourceRange != null) {
                    int shift = sourceRange.getOffset();
                    IScanner scanner = DocumentSymbolHandler.getScanner();
                    scanner.setSource(unit.getSource().toCharArray());
                    scanner.resetTo(shift, shift + sourceRange.getLength());
                }
            }
            return childrenStream.map(child -> this.toDocumentSymbol((IJavaElement)child, unit, monitor, includeInherited)).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (OperationCanceledException e) {
            JavaLanguageServerPlugin.logInfo("User abort while collecting the document symbols.");
        }
        catch (JavaModelException e) {
            if (!unit.exists()) {
                JavaLanguageServerPlugin.logError("Problem getting outline for " + unit.getElementName() + ": File not found.");
            }
            JavaLanguageServerPlugin.logException("Problem getting outline for " + unit.getElementName(), e);
        }
        return Collections.emptyList();
    }

    private DocumentSymbol toDocumentSymbol(IJavaElement unit, ITypeRoot root, IProgressMonitor monitor, boolean includeInherited) {
        SourceMethod method;
        int type = unit.getElementType();
        if (type != 7 && type != 8 && type != 9 && type != 11 && type != 5 && type != 4) {
            return null;
        }
        if (unit instanceof SourceMethod && JDTUtils.isGenerated((IMember)(method = (SourceMethod)unit))) {
            return null;
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException("User abort");
        }
        ExtendedDocumentSymbol symbol = includeInherited ? new ExtendedDocumentSymbol() : new DocumentSymbol();
        try {
            String name = SymbolUtils.getName(unit);
            symbol.setName(name);
            if (type == 4) {
                IScanner scanner = DocumentSymbolHandler.getScanner();
                int token = 0;
                int packageStart = -1;
                int packageEnd = -1;
                while (token != 158) {
                    switch (token) {
                        case 214: {
                            packageStart = scanner.getCurrentTokenStartPosition();
                            packageEnd = scanner.getCurrentTokenEndPosition();
                        }
                    }
                    token = this.getNextToken(scanner);
                }
                Range packageRange = JDTUtils.toRange((IOpenable)root, packageStart, packageEnd);
                symbol.setRange(packageRange);
                symbol.setSelectionRange(packageRange);
            } else {
                symbol.setRange(SymbolUtils.getRange(unit));
                symbol.setSelectionRange(SymbolUtils.getSelectionRange(unit));
            }
            symbol.setKind(SymbolUtils.mapKind(unit));
            if (JDTUtils.isDeprecated(unit)) {
                if (this.preferenceManager.getClientPreferences().isSymbolTagSupported()) {
                    symbol.setTags(List.of(SymbolTag.Deprecated));
                } else {
                    symbol.setDeprecated(true);
                }
            }
            if (symbol instanceof ExtendedDocumentSymbol) {
                symbol.setDetail(SymbolUtils.getDetail(unit, name, 131328L));
            } else {
                symbol.setDetail(SymbolUtils.getDetail(unit, name));
            }
            if (unit instanceof IParent) {
                IParent parent = (IParent)unit;
                ArrayList<IJavaElement> children = new ArrayList<IJavaElement>();
                children.addAll(Arrays.asList(SymbolUtils.filter(parent.getChildren())));
                if (symbol instanceof ExtendedDocumentSymbol) {
                    Location loc = JDTUtils.toLocation(unit);
                    if (loc != null) {
                        symbol.setUri(loc.getUri());
                    }
                    if (unit instanceof IType) {
                        IType[] superClasses;
                        IType tp = (IType)unit;
                        ITypeHierarchy supertypeHierarchy = tp.newSupertypeHierarchy(monitor);
                        if (monitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        IType[] iTypeArray = superClasses = supertypeHierarchy.getAllSuperclasses(tp);
                        int n = superClasses.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IType superType = iTypeArray[n2];
                            if (!"java.lang.Object".equals(superType.getFullyQualifiedName())) {
                                children.addAll(Arrays.asList(SymbolUtils.filter(superType.getChildren())));
                            }
                            ++n2;
                        }
                    }
                }
                symbol.setChildren(children.stream().map(child -> this.toDocumentSymbol((IJavaElement)child, null, monitor, includeInherited)).filter(Objects::nonNull).collect(Collectors.toList()));
            }
        }
        catch (JavaModelException e) {
            Exceptions.sneakyThrow((Throwable)e);
        }
        return symbol;
    }

    private static IScanner getScanner() {
        if (fScanner == null) {
            fScanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)true);
        }
        return fScanner;
    }

    private int getNextToken(IScanner scanner) {
        int token = 0;
        while (token == 0) {
            try {
                token = scanner.getNextToken();
            }
            catch (InvalidInputException invalidInputException) {
                // empty catch block
            }
        }
        return token;
    }

    private List<DocumentSymbol> getHierarchicalOutlineFromDecompiledSource(ITypeRoot unit, IProgressMonitor monitor) {
        DecompilerResult decompileResult;
        ContentProviderManager contentProvider = JavaLanguageServerPlugin.getContentProviderManager();
        try {
            decompileResult = contentProvider.getSourceResult((IClassFile)unit, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            JavaLanguageServerPlugin.logException(e.getMessage(), e);
            return Collections.emptyList();
        }
        if (monitor != null && monitor.isCanceled()) {
            return Collections.emptyList();
        }
        String contents = decompileResult.getContent();
        if (contents == null || contents.isBlank()) {
            return Collections.emptyList();
        }
        ASTParser parser = ASTParser.newParser((int)AST.getJLSLatest());
        parser.setResolveBindings(false);
        parser.setKind(8);
        parser.setStatementsRecovery(true);
        parser.setBindingsRecovery(false);
        parser.setIgnoreMethodBodies(true);
        parser.setEnvironment(new String[0], new String[0], null, true);
        Hashtable javaOptions = JavaCore.getOptions();
        javaOptions.put("org.eclipse.jdt.core.compiler.source", JavaCore.latestSupportedJavaVersion());
        javaOptions.put("org.eclipse.jdt.core.compiler.codegen.targetPlatform", JavaCore.latestSupportedJavaVersion());
        javaOptions.put("org.eclipse.jdt.core.compiler.compliance", JavaCore.latestSupportedJavaVersion());
        javaOptions.put("org.eclipse.jdt.core.compiler.problem.enablePreviewFeatures", "enabled");
        parser.setCompilerOptions((Map)javaOptions);
        parser.setUnitName(unit.getElementName());
        parser.setSource(contents.toCharArray());
        CompilationUnit astUnit = (CompilationUnit)parser.createAST(monitor);
        DocumentSymbolVisitor visitor = new DocumentSymbolVisitor(astUnit);
        astUnit.accept((ASTVisitor)visitor);
        return visitor.getSymbols();
    }

    private static class DocumentSymbolVisitor
    extends ASTVisitor {
        private CompilationUnit astUnit = null;
        private List<DocumentSymbol> symbols = new ArrayList<DocumentSymbol>();
        private Map<ASTNode, DocumentSymbol> typeMappings = new HashMap<ASTNode, DocumentSymbol>();

        public DocumentSymbolVisitor(CompilationUnit astUnit) {
            this.astUnit = astUnit;
        }

        public List<DocumentSymbol> getSymbols() {
            return this.symbols;
        }

        public boolean visit(PackageDeclaration node) {
            DocumentSymbol symbol = this.getDocumentSymbol(node.getName().getFullyQualifiedName(), (ASTNode)node, (ASTNode)node.getName());
            this.symbols.add(symbol);
            return super.visit(node);
        }

        public boolean visit(TypeDeclaration node) {
            this.addAsTypeDocumentSymbol((AbstractTypeDeclaration)node);
            return super.visit(node);
        }

        public boolean visit(EnumDeclaration node) {
            this.addAsTypeDocumentSymbol((AbstractTypeDeclaration)node);
            return super.visit(node);
        }

        public boolean visit(RecordDeclaration node) {
            DocumentSymbol typeSymbol = this.addAsTypeDocumentSymbol((AbstractTypeDeclaration)node);
            typeSymbol.setChildren(new ArrayList());
            List recordComponents = node.recordComponents();
            for (Object recordComponent : recordComponents) {
                if (!(recordComponent instanceof SingleVariableDeclaration)) continue;
                SingleVariableDeclaration svd = (SingleVariableDeclaration)recordComponent;
                DocumentSymbol component = this.getDocumentSymbol(svd.getName().toString(), (ASTNode)svd, (ASTNode)svd.getName());
                component.setKind(SymbolKind.Field);
                typeSymbol.getChildren().add(component);
            }
            return super.visit(node);
        }

        public boolean visit(AnnotationTypeDeclaration node) {
            this.addAsTypeDocumentSymbol((AbstractTypeDeclaration)node);
            return super.visit(node);
        }

        public boolean visit(AnnotationTypeMemberDeclaration node) {
            String memberName = node.getName().getIdentifier() + "()";
            String typeName = node.getType().toString();
            DocumentSymbol symbol = this.getDocumentSymbol(memberName, (ASTNode)node, (ASTNode)node.getName());
            symbol.setDetail(" : " + typeName);
            this.addAsChildDocumentSymbol((ASTNode)node, symbol);
            return super.visit(node);
        }

        public boolean visit(EnumConstantDeclaration node) {
            DocumentSymbol symbol = this.getDocumentSymbol(node.getName().toString(), (ASTNode)node, (ASTNode)node.getName());
            this.addAsChildDocumentSymbol((ASTNode)node, symbol);
            return super.visit(node);
        }

        public boolean visit(FieldDeclaration node) {
            List fragments = node.fragments();
            for (Object fragment : fragments) {
                if (!(fragment instanceof VariableDeclarationFragment)) continue;
                VariableDeclarationFragment df = (VariableDeclarationFragment)fragment;
                DocumentSymbol symbol = this.getDocumentSymbol(df.getName().toString(), (ASTNode)node, (ASTNode)df.getName());
                this.addAsChildDocumentSymbol((ASTNode)node, symbol);
            }
            return super.visit(node);
        }

        public boolean visit(MethodDeclaration node) {
            StringBuilder name = new StringBuilder(node.getName().getIdentifier());
            name.append("(");
            List parameters = node.parameters();
            if (parameters != null) {
                ArrayList<Object> params = new ArrayList<Object>();
                for (Object parameter : parameters) {
                    if (parameter instanceof SingleVariableDeclaration) {
                        SingleVariableDeclaration vd = (SingleVariableDeclaration)parameter;
                        String typeName = vd.getType().toString() + (vd.isVarargs() ? "..." : "");
                        params.add(typeName);
                        continue;
                    }
                    params.add("Object");
                }
                name.append(String.join((CharSequence)", ", params));
            }
            name.append(")");
            String returnType = null;
            returnType = node.getReturnType2() != null ? node.getReturnType2().toString() : (node.isConstructor() ? null : "void");
            DocumentSymbol symbol = this.getDocumentSymbol(name.toString(), (ASTNode)node, (ASTNode)node.getName());
            symbol.setDetail((String)(returnType == null ? "" : " : " + returnType));
            this.addAsChildDocumentSymbol((ASTNode)node, symbol);
            return super.visit(node);
        }

        private DocumentSymbol addAsTypeDocumentSymbol(AbstractTypeDeclaration node) {
            DocumentSymbol symbol = this.getDocumentSymbol(node.getName().getIdentifier(), (ASTNode)node, (ASTNode)node.getName());
            this.symbols.add(symbol);
            this.typeMappings.put((ASTNode)node, symbol);
            return symbol;
        }

        private void addAsChildDocumentSymbol(ASTNode currentNode, DocumentSymbol symbol) {
            ASTNode parent = currentNode.getParent();
            if (parent == null) {
                return;
            }
            DocumentSymbol parentSymbol = this.typeMappings.get(parent);
            if (parentSymbol == null) {
                return;
            }
            if (parentSymbol.getChildren() == null) {
                parentSymbol.setChildren(new ArrayList());
            }
            parentSymbol.getChildren().add(symbol);
        }

        private DocumentSymbol getDocumentSymbol(String name, ASTNode node, ASTNode nameNode) {
            BodyDeclaration bd;
            DocumentSymbol symbol = new DocumentSymbol();
            symbol.setName(name);
            symbol.setKind(this.getKind(node));
            symbol.setRange(this.getRange(node));
            symbol.setSelectionRange(this.getRange(nameNode));
            symbol.setDetail("");
            if (node instanceof BodyDeclaration && this.containsModifier((bd = (BodyDeclaration)node).modifiers(), "@Deprecated")) {
                symbol.setTags(List.of(SymbolTag.Deprecated));
            }
            return symbol;
        }

        private Range getRange(ASTNode node) {
            int start = node.getStartPosition();
            int end = start + node.getLength();
            Position startPosition = new Position(this.astUnit.getLineNumber(start) - 1, this.astUnit.getColumnNumber(start));
            Position endPosition = new Position(this.astUnit.getLineNumber(end) - 1, this.astUnit.getColumnNumber(end));
            return new Range(startPosition, endPosition);
        }

        private SymbolKind getKind(ASTNode node) {
            switch (node.getNodeType()) {
                case 35: {
                    return SymbolKind.Package;
                }
                case 55: {
                    return ((TypeDeclaration)node).isInterface() ? SymbolKind.Interface : SymbolKind.Class;
                }
                case 71: {
                    return SymbolKind.Enum;
                }
                case 103: {
                    return SymbolKind.Class;
                }
                case 81: {
                    return SymbolKind.Property;
                }
                case 23: {
                    List modifiers = ((FieldDeclaration)node).modifiers();
                    if (this.containsModifier(modifiers, "static") && this.containsModifier(modifiers, "final")) {
                        return SymbolKind.Constant;
                    }
                    return SymbolKind.Field;
                }
                case 72: {
                    return SymbolKind.EnumMember;
                }
                case 31: {
                    return ((MethodDeclaration)node).isConstructor() ? SymbolKind.Constructor : SymbolKind.Method;
                }
                case 82: {
                    return SymbolKind.Method;
                }
            }
            return SymbolKind.String;
        }

        private boolean containsModifier(List<?> modifiers, String target) {
            if (modifiers == null || modifiers.isEmpty()) {
                return false;
            }
            for (Object modifier : modifiers) {
                if (!Objects.equals(modifier.toString(), target)) continue;
                return true;
            }
            return false;
        }
    }

    public static class ExtendedDocumentSymbol
    extends DocumentSymbol {
        @NonNull
        private String uri;

        public void setUri(@NonNull String uri) {
            this.uri = uri;
        }

        @NonNull
        @Pure
        public String getUri() {
            return this.uri;
        }

        public int hashCode() {
            int prime = 31;
            int result = super.hashCode();
            result = 31 * result + Objects.hash(this.uri);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!super.equals(obj)) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            ExtendedDocumentSymbol other = (ExtendedDocumentSymbol)((Object)obj);
            return Objects.equals(this.uri, other.uri);
        }
    }
}

