/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.core.internal.resources.File;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IProblemRequestor;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.WorkingCopyOwner;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.manipulation.CoreASTProvider;
import org.eclipse.jdt.internal.core.OpenableElementInfo;
import org.eclipse.jdt.internal.core.PackageFragment;
import org.eclipse.jdt.ls.core.internal.DocumentAdapter;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.JobHelpers;
import org.eclipse.jdt.ls.core.internal.MovingAverage;
import org.eclipse.jdt.ls.core.internal.ProjectUtils;
import org.eclipse.jdt.ls.core.internal.contentassist.CompletionProposalUtils;
import org.eclipse.jdt.ls.core.internal.corrections.DiagnosticsHelper;
import org.eclipse.jdt.ls.core.internal.handlers.BaseDiagnosticsHandler;
import org.eclipse.jdt.ls.core.internal.handlers.CodeActionHandler;
import org.eclipse.jdt.ls.core.internal.handlers.JsonRpcHelpers;
import org.eclipse.jdt.ls.core.internal.managers.InvisibleProjectImporter;
import org.eclipse.jdt.ls.core.internal.managers.ProjectsManager;
import org.eclipse.jdt.ls.core.internal.preferences.PreferenceManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.RenameFile;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.ResponseErrorException;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.jsonrpc.messages.ResponseError;
import org.eclipse.osgi.util.NLS;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.ReplaceEdit;

public abstract class BaseDocumentLifeCycleHandler {
    public static final String DOCUMENT_LIFE_CYCLE_JOBS = "DocumentLifeCycleJobs";
    public static final String PUBLISH_DIAGNOSTICS_JOBS = "DocumentLifeCyclePublishDiagnosticsJobs";
    public static final String RENAME_FILE_TO_TYPE = "renameFileToType";
    private static final long DOCUMENT_LIFECYCLE_MAX_DEBOUNCE = 400L;
    private static final long PUBLISH_DIAGNOSTICS_MIN_DEBOUNCE = 400L;
    private static final long PUBLISH_DIAGNOSTICS_MAX_DEBOUNCE = 2000L;
    private CoreASTProvider sharedASTProvider;
    private Job validationTimer;
    private Job publishDiagnosticsJob;
    private Set<ICompilationUnit> toReconcile = new HashSet<ICompilationUnit>();
    private Set<ICompilationUnit> toValidate = ConcurrentHashMap.newKeySet();
    private Map<String, Integer> documentVersions = new HashMap<String, Integer>();
    private Map<String, Integer> lastSyncedDocumentLengths = new ConcurrentHashMap<String, Integer>();
    private MovingAverage movingAverageForValidation = new MovingAverage(400L);
    private MovingAverage movingAverageForDiagnostics = new MovingAverage(400L);
    protected final PreferenceManager preferenceManager;
    private Object reconcileLock = new Object();

    public BaseDocumentLifeCycleHandler(PreferenceManager preferenceManager, boolean delayValidation) {
        this.preferenceManager = preferenceManager;
        this.sharedASTProvider = CoreASTProvider.getInstance();
        if (delayValidation) {
            this.validationTimer = new Job("Validate documents"){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        long startTime = System.nanoTime();
                        IStatus status = BaseDocumentLifeCycleHandler.this.performValidation(monitor);
                        if (status.getSeverity() != 8) {
                            long elapsedTime = System.nanoTime() - startTime;
                            BaseDocumentLifeCycleHandler.this.movingAverageForValidation.update(elapsedTime / 1000000L);
                        }
                        return status;
                    }
                    catch (JavaModelException e) {
                        return e.getStatus();
                    }
                }

                public boolean belongsTo(Object family) {
                    return BaseDocumentLifeCycleHandler.DOCUMENT_LIFE_CYCLE_JOBS.equals(family);
                }
            };
            this.publishDiagnosticsJob = new PublishDiagnosticJob();
        }
    }

    public abstract BaseDiagnosticsHandler createDiagnosticsHandler(ICompilationUnit var1);

    public abstract boolean isSyntaxMode(ICompilationUnit var1);

    public abstract ICompilationUnit resolveCompilationUnit(String var1);

    protected void triggerValidation(ICompilationUnit cu) throws JavaModelException {
        this.triggerValidation(cu, this.getDocumentLifecycleDelay());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void triggerValidation(ICompilationUnit cu, long delay) throws JavaModelException {
        Set<ICompilationUnit> set = this.toReconcile;
        synchronized (set) {
            this.toReconcile.add(cu);
            if (!cu.equals(this.sharedASTProvider.getActiveJavaElement())) {
                this.sharedASTProvider.disposeAST();
            }
            this.sharedASTProvider.setActiveJavaElement((ITypeRoot)cu);
        }
        if (this.validationTimer != null) {
            this.validationTimer.cancel();
            if (this.publishDiagnosticsJob != null) {
                this.publishDiagnosticsJob.cancel();
                this.publishDiagnosticsJob = new PublishDiagnosticJob();
            }
            this.validationTimer.schedule(delay);
        } else {
            this.performValidation((IProgressMonitor)new NullProgressMonitor());
        }
    }

    private long getDocumentLifecycleDelay() {
        return Math.min(400L, Math.round(1.5 * (double)this.movingAverageForValidation.value));
    }

    private long getPublishDiagnosticsDelay() {
        return Math.min(Math.max(400L, Math.round(1.5 * (double)this.movingAverageForDiagnostics.value)), 2000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStatus performValidation(IProgressMonitor monitor) throws JavaModelException {
        ArrayList<ICompilationUnit> cusToReconcile;
        long start = System.currentTimeMillis();
        Set<ICompilationUnit> set = this.toReconcile;
        synchronized (set) {
            if (this.toReconcile.isEmpty()) {
                return Status.OK_STATUS;
            }
            cusToReconcile = new ArrayList<ICompilationUnit>(this.toReconcile.size());
            cusToReconcile.addAll(this.toReconcile);
            this.toReconcile.clear();
        }
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(cusToReconcile.size() + 1));
        Object object = this.reconcileLock;
        synchronized (object) {
            for (ICompilationUnit cu : cusToReconcile) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                cu.makeConsistent((IProgressMonitor)progress);
                this.toValidate.add(cu);
            }
        }
        JavaLanguageServerPlugin.logInfo("Reconciled " + cusToReconcile.size() + ". Took " + (System.currentTimeMillis() - start) + " ms");
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (this.publishDiagnosticsJob != null) {
            this.publishDiagnosticsJob.cancel();
            try {
                this.publishDiagnosticsJob.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
        } else {
            return this.publishDiagnostics((IProgressMonitor)new NullProgressMonitor());
        }
        this.publishDiagnosticsJob.schedule(this.getPublishDiagnosticsDelay());
        return Status.OK_STATUS;
    }

    public IStatus validateDocument(String uri, boolean debounce, IProgressMonitor monitor) throws JavaModelException {
        ICompilationUnit unit = this.resolveCompilationUnit(uri);
        if (unit == null || unit.getResource() == null || unit.getResource().isDerived()) {
            return Status.OK_STATUS;
        }
        this.toValidate.add(unit);
        if (!unit.equals(this.sharedASTProvider.getActiveJavaElement())) {
            this.sharedASTProvider.disposeAST();
        }
        this.sharedASTProvider.setActiveJavaElement((ITypeRoot)unit);
        if (debounce && this.publishDiagnosticsJob != null) {
            this.publishDiagnosticsJob.cancel();
            this.publishDiagnosticsJob.setRule(null);
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            this.publishDiagnosticsJob.schedule(this.getPublishDiagnosticsDelay());
            return Status.OK_STATUS;
        }
        return this.publishDiagnostics(monitor);
    }

    public IStatus publishDiagnostics(IProgressMonitor monitor) throws JavaModelException {
        long start = System.currentTimeMillis();
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        LinkedHashSet<ICompilationUnit> validateCopy = new LinkedHashSet<ICompilationUnit>(this.toValidate);
        if (this.preferenceManager.getPreferences().isValidateAllOpenBuffersOnChanges()) {
            this.toValidate.addAll(Arrays.asList(JavaCore.getWorkingCopies(null)));
        }
        if (validateCopy.isEmpty()) {
            return Status.OK_STATUS;
        }
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)(validateCopy.size() + 1));
        if (monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        for (ICompilationUnit rootToValidate : validateCopy) {
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            this.publishDiagnostics(rootToValidate, (IProgressMonitor)progress.newChild(1));
            this.toValidate.remove(rootToValidate);
        }
        JavaLanguageServerPlugin.logInfo("Validated " + validateCopy.size() + ". Took " + (System.currentTimeMillis() - start) + " ms");
        return Status.OK_STATUS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publishDiagnostics(ICompilationUnit unit, final IProgressMonitor monitor) throws JavaModelException {
        final BaseDiagnosticsHandler handler = this.createDiagnosticsHandler(unit);
        WorkingCopyOwner wcOwner = new WorkingCopyOwner(){

            public IBuffer createBuffer(ICompilationUnit workingCopy) {
                ICompilationUnit original;
                IResource resource;
                if (!monitor.isCanceled() && (resource = (original = workingCopy.getPrimary()).getResource()) instanceof IFile) {
                    IFile file = (IFile)resource;
                    return new DocumentAdapter((IOpenable)workingCopy, file);
                }
                return DocumentAdapter.Null;
            }

            public IProblemRequestor getProblemRequestor(ICompilationUnit workingCopy) {
                return handler;
            }
        };
        int flags = 7;
        Object object = this.reconcileLock;
        synchronized (object) {
            unit.reconcile(0, flags, wcOwner, monitor);
        }
    }

    public void didClose(DidCloseTextDocumentParams params) {
        this.documentVersions.remove(params.getTextDocument().getUri());
        this.lastSyncedDocumentLengths.remove(params.getTextDocument().getUri());
        this.handleClosed(params);
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        String uri = params.getTextDocument().getUri();
        this.documentVersions.put(uri, params.getTextDocument().getVersion());
        this.lastSyncedDocumentLengths.remove(params.getTextDocument().getUri());
        IFile resource = JDTUtils.findFile(uri);
        if (resource != null) {
            this.handleOpen(params);
        } else {
            try {
                ResourcesPlugin.getWorkspace().run(monitor -> {
                    ICompilationUnit iCompilationUnit = this.handleOpen(params);
                }, null, 1, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("Handle document open ", e);
            }
        }
    }

    public void didChange(DidChangeTextDocumentParams params) {
        this.documentVersions.put(params.getTextDocument().getUri(), params.getTextDocument().getVersion());
        this.handleChanged(params);
    }

    public void didSave(DidSaveTextDocumentParams params) {
        String documentUri = params.getTextDocument().getUri();
        this.lastSyncedDocumentLengths.remove(documentUri);
        IFile file = JDTUtils.findFile(params.getTextDocument().getUri());
        if (file != null && !Objects.equals(ProjectsManager.getDefaultProject(), file.getProject())) {
            this.handleSaved(params);
        } else {
            try {
                JobHelpers.waitForJobs(DOCUMENT_LIFE_CYCLE_JOBS, (IProgressMonitor)new NullProgressMonitor());
                ResourcesPlugin.getWorkspace().run(monitor -> {
                    ICompilationUnit iCompilationUnit = this.handleSaved(params);
                }, null, 1, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException("Handle document save ", e);
            }
        }
    }

    public static void handleFileRenameForTypeDeclaration(String documentUri) {
        ICompilationUnit cu = JDTUtils.resolveCompilationUnit(documentUri);
        CompilationUnit astRoot = CoreASTProvider.getInstance().getAST((ITypeRoot)cu, CoreASTProvider.WAIT_YES, null);
        IProblem[] problems = astRoot.getProblems();
        Optional<IProblem> desiredProblem = Arrays.stream(problems).filter(p -> p.getID() == 16777541).findFirst();
        if (desiredProblem.isPresent()) {
            IProblem renameProblem = desiredProblem.get();
            String newName = renameProblem.getArguments()[1];
            String oldName = cu.getElementName();
            int index = oldName.lastIndexOf(".");
            String extension = index > 0 ? oldName.substring(index) : ".java";
            String newUri = documentUri.replace(oldName, newName + extension);
            WorkspaceEdit edit = new WorkspaceEdit(List.of(Either.forRight((Object)new RenameFile(documentUri, newUri))));
            edit.setChanges(Collections.emptyMap());
            boolean applyNow = JavaLanguageServerPlugin.getPreferencesManager().getClientPreferences().isWorkspaceApplyEditSupported();
            if (applyNow) {
                JavaLanguageServerPlugin.getInstance().getClientConnection().applyWorkspaceEdit(edit);
            }
        }
    }

    public ICompilationUnit handleOpen(DidOpenTextDocumentParams params) {
        String uri = params.getTextDocument().getUri();
        ICompilationUnit unit = this.resolveCompilationUnit(uri);
        if (unit == null || unit.getResource() == null || unit.getResource().isDerived()) {
            return unit;
        }
        try {
            if (!unit.getResource().isAccessible()) {
                try {
                    IJavaElement parent;
                    this.refreshLocalResource(unit.getResource(), 0, (IProgressMonitor)new NullProgressMonitor());
                    if (unit.getResource().exists() && (parent = unit.getParent()) instanceof PackageFragment) {
                        PackageFragment pkg = (PackageFragment)parent;
                        OpenableElementInfo elementInfo = (OpenableElementInfo)pkg.getElementInfo();
                        elementInfo.addChild((IJavaElement)unit);
                    }
                }
                catch (CoreException parent) {
                    // empty catch block
                }
            }
            CompletionProposalUtils.addStaticImportsAsFavoriteImports(unit);
            unit.becomeWorkingCopy((IProgressMonitor)new NullProgressMonitor());
            IBuffer buffer = unit.getBuffer();
            String newContent = params.getTextDocument().getText();
            if (buffer != null && !buffer.getContents().equals(newContent)) {
                buffer.setContents(newContent);
            }
            this.triggerValidation(unit);
            this.checkPackageDeclaration(uri, unit);
            this.inferInvisibleProjectSourceRoot(unit);
        }
        catch (JavaModelException e) {
            JavaLanguageServerPlugin.logException("Error while opening document. URI: " + uri, e);
        }
        return unit;
    }

    public ICompilationUnit handleChanged(DidChangeTextDocumentParams params) {
        String uri = params.getTextDocument().getUri();
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit(uri);
        if (unit == null || !unit.isWorkingCopy() || params.getContentChanges().isEmpty() || unit.getResource().isDerived()) {
            return unit;
        }
        try {
            if (unit.equals(this.sharedASTProvider.getActiveJavaElement())) {
                this.sharedASTProvider.clearReconciliation();
                this.sharedASTProvider.disposeAST();
                this.sharedASTProvider.clearReconciliation();
                CodeActionHandler.codeActionStore.clear();
            }
            if (!this.preferenceManager.getClientPreferences().skipTextEventPropagation()) {
                int currentBufferLength = unit.getBuffer().getLength();
                if (this.lastSyncedDocumentLengths.containsKey(uri) && this.lastSyncedDocumentLengths.get(uri) != currentBufferLength) {
                    JavaLanguageServerPlugin.logError("Document on language server is out-of-sync: " + unit.getElementName());
                }
                List contentChanges = params.getContentChanges();
                for (TextDocumentContentChangeEvent changeEvent : contentChanges) {
                    int length;
                    int startOffset;
                    Range range = changeEvent.getRange();
                    IDocument document = JsonRpcHelpers.toDocument(unit.getBuffer());
                    if (range != null) {
                        Position start = range.getStart();
                        startOffset = JsonRpcHelpers.toOffset(document, start.getLine(), start.getCharacter());
                        length = DiagnosticsHelper.getLength(unit, range);
                    } else {
                        length = unit.getSource().length();
                        startOffset = 0;
                    }
                    Object edit = null;
                    String text = changeEvent.getText();
                    edit = length == 0 ? new InsertEdit(startOffset, text) : (text.isEmpty() ? new DeleteEdit(startOffset, length) : new ReplaceEdit(startOffset, length, text));
                    edit.apply(document, 0);
                }
                this.lastSyncedDocumentLengths.put(uri, unit.getBuffer().getLength());
            }
            this.triggerValidation(unit);
        }
        catch (JavaModelException | BadLocationException | MalformedTreeException e) {
            JavaLanguageServerPlugin.logException("Error while handling document change. URI: " + uri, e);
        }
        return unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICompilationUnit handleClosed(DidCloseTextDocumentParams params) {
        String uri = params.getTextDocument().getUri();
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit(uri);
        if (unit == null) {
            return unit;
        }
        try {
            java.io.File f;
            Set<ICompilationUnit> set = this.toReconcile;
            synchronized (set) {
                this.toReconcile.remove(unit);
            }
            this.toValidate.remove(unit);
            if (this.isSyntaxMode(unit) || !unit.exists() || unit.getResource().isDerived()) {
                this.createDiagnosticsHandler(unit).clearDiagnostics();
            } else if (this.hasUnsavedChanges(unit)) {
                unit.discardWorkingCopy();
                unit.becomeWorkingCopy((IProgressMonitor)new NullProgressMonitor());
                this.publishDiagnostics(unit, (IProgressMonitor)new NullProgressMonitor());
            }
            this.sharedASTProvider.disposeAST();
            unit.discardWorkingCopy();
            if (JDTUtils.isDefaultProject(unit) && !(f = new java.io.File(unit.getUnderlyingResource().getLocationURI())).exists()) {
                unit.delete(true, null);
            }
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.logException("Error while handling document close. URI: " + uri, e);
        }
        return unit;
    }

    private boolean hasUnsavedChanges(ICompilationUnit unit) throws CoreException {
        if (!unit.hasUnsavedChanges()) {
            return false;
        }
        this.refreshLocalResource(unit.getResource(), 0, (IProgressMonitor)new NullProgressMonitor());
        return unit.getResource().exists();
    }

    public ICompilationUnit handleSaved(DidSaveTextDocumentParams params) {
        String uri = params.getTextDocument().getUri();
        ICompilationUnit unit = JDTUtils.resolveCompilationUnit(uri);
        if (unit == null) {
            JavaLanguageServerPlugin.logError(uri + " does not resolve to a ICompilationUnit");
            return unit;
        }
        if ((unit = this.checkPackageDeclaration(uri, unit)).isWorkingCopy()) {
            try {
                if (unit.getUnderlyingResource() != null && unit.getUnderlyingResource().exists()) {
                    try {
                        this.refreshLocalResource(unit.getUnderlyingResource(), 0, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException e) {
                        JavaLanguageServerPlugin.logException("Error while refreshing resource. URI: " + uri, e);
                    }
                }
                unit.discardWorkingCopy();
                unit.becomeWorkingCopy((IProgressMonitor)new NullProgressMonitor());
            }
            catch (JavaModelException e) {
                JavaLanguageServerPlugin.logException("Error while handling document save. URI: " + uri, e);
            }
        }
        return unit;
    }

    private ICompilationUnit checkPackageDeclaration(String uri, ICompilationUnit unit) {
        if (unit.getResource() != null && unit.getJavaProject() != null && unit.getJavaProject().getProject().getName().equals("jdt.ls-java-project")) {
            try {
                IProblem[] problems;
                CompilationUnit astRoot = CoreASTProvider.getInstance().getAST((ITypeRoot)unit, CoreASTProvider.WAIT_YES, (IProgressMonitor)new NullProgressMonitor());
                if (astRoot == null) {
                    return unit;
                }
                IProblem[] iProblemArray = problems = astRoot.getProblems();
                int n = problems.length;
                int n2 = 0;
                while (n2 < n) {
                    IProblem problem = iProblemArray[n2];
                    if (problem.getID() == 536871240) {
                        IPath path;
                        IResource file = unit.getResource();
                        boolean toRemove = file.isLinked();
                        if (toRemove && (path = file.getParent().getProjectRelativePath()).segmentCount() > 0 && "src".equals(path.segments()[0])) {
                            String pathStr;
                            String packageNameResource = path.removeFirstSegments(1).toString().replace("/", ".");
                            path = file.getLocation();
                            if (path != null && path.segmentCount() > 0 && (pathStr = (path = path.removeLastSegments(1)).toString().replace("/", ".")).endsWith(packageNameResource)) {
                                toRemove = false;
                            }
                        }
                        if (toRemove) {
                            file.delete(true, (IProgressMonitor)new NullProgressMonitor());
                            if (unit.equals(this.sharedASTProvider.getActiveJavaElement())) {
                                this.sharedASTProvider.disposeAST();
                            }
                            unit.discardWorkingCopy();
                            unit = JDTUtils.resolveCompilationUnit(uri);
                            unit.becomeWorkingCopy((IProgressMonitor)new NullProgressMonitor());
                            this.triggerValidation(unit);
                        }
                        break;
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                JavaLanguageServerPlugin.logException(e.getMessage(), e);
            }
        }
        return unit;
    }

    private void inferInvisibleProjectSourceRoot(ICompilationUnit unit) {
        IJavaProject javaProject = unit.getJavaProject();
        if (javaProject == null) {
            return;
        }
        IProject project = javaProject.getProject();
        if (ProjectUtils.isUnmanagedFolder(project)) {
            PreferenceManager preferencesManager = JavaLanguageServerPlugin.getPreferencesManager();
            List<String> sourcePaths = preferencesManager.getPreferences().getInvisibleProjectSourcePaths();
            if (sourcePaths != null) {
                return;
            }
            boolean needToInfer = this.needInferSourceRoot(javaProject, unit);
            if (!needToInfer) {
                return;
            }
            IPath unitPath = unit.getResource().getLocation();
            InvisibleProjectImporter.inferSourceRoot(javaProject, unitPath);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean needInferSourceRoot(IJavaProject javaProject, ICompilationUnit unit) {
        if (!javaProject.isOnClasspath((IJavaElement)unit)) {
            IProject project = javaProject.getProject();
            IPath projectRealFolder = ProjectUtils.getProjectRealFolder(project);
            IPath unitPath = unit.getResource().getLocation();
            return projectRealFolder.isPrefixOf(unitPath);
        }
        CompilationUnit astRoot = CoreASTProvider.getInstance().getAST((ITypeRoot)unit, CoreASTProvider.WAIT_YES, (IProgressMonitor)new NullProgressMonitor());
        if (astRoot == null) {
            return false;
        }
        IProblem[] problems = astRoot.getProblems();
        boolean isPackageNotMatch = Arrays.stream(problems).anyMatch(p -> p.getID() == 536871240);
        if (!isPackageNotMatch) {
            return false;
        }
        IJavaElement parent = unit.getParent();
        if (parent == null) return false;
        if (!(parent instanceof IPackageFragment)) {
            return false;
        }
        try {
            ICompilationUnit[] children;
            ICompilationUnit[] iCompilationUnitArray = children = ((IPackageFragment)parent).getCompilationUnits();
            int n = children.length;
            int n2 = 0;
            while (true) {
                IMarker[] markers;
                boolean hasPackageNotMatchError;
                if (n2 >= n) {
                    return true;
                }
                ICompilationUnit child = iCompilationUnitArray[n2];
                IResource resource = child.getResource();
                if (resource != null && !(hasPackageNotMatchError = Arrays.stream(markers = resource.findMarkers("org.eclipse.jdt.core.problem", false, 0)).anyMatch(m -> m.getAttribute("id", 0) == 536871240))) {
                    return false;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            JavaLanguageServerPlugin.log(e);
            return false;
        }
    }

    private void refreshLocalResource(IResource resource, int depth, IProgressMonitor monitor) throws CoreException {
        if (resource instanceof File) {
            File file = (File)resource;
            if (!file.getLocalManager().fastIsSynchronized(file)) {
                String message = NLS.bind((String)Messages.resources_refreshing, (Object)file.getFullPath());
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100).checkCanceled();
                progress.subTask(message);
                boolean build = false;
                SubMonitor split = progress.split(1);
                ISchedulingRule rule = null;
                Workspace workspace = (Workspace)file.getWorkspace();
                try {
                    workspace.prepareOperation(rule, (IProgressMonitor)split);
                    if (!file.getProject().isAccessible()) {
                        return;
                    }
                    if (!file.exists() && file.isFiltered()) {
                        return;
                    }
                    workspace.beginOperation(true);
                    build = file.getLocalManager().refresh((IResource)file, 0, true, monitor);
                }
                finally {
                    monitor.done();
                    workspace.endOperation(rule, build);
                }
            }
        } else {
            resource.refreshLocal(depth, monitor);
        }
    }

    public class DocumentMonitor {
        private final String uri;
        private final Integer initialVersion;

        public DocumentMonitor(String uri) {
            this.uri = uri;
            this.initialVersion = BaseDocumentLifeCycleHandler.this.documentVersions.get(uri);
        }

        public boolean hasChanged() {
            Integer currentVersion = BaseDocumentLifeCycleHandler.this.documentVersions.get(this.uri);
            return !Objects.equals(this.initialVersion, currentVersion);
        }

        public void checkChanged() {
            if (this.hasChanged()) {
                throw new ResponseErrorException(new ResponseError(-32801, "Document changed, request invalid", null));
            }
        }
    }

    private final class PublishDiagnosticJob
    extends Job {
        private PublishDiagnosticJob() {
            super("Publish Diagnostics");
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                long startTime = System.nanoTime();
                IStatus status = BaseDocumentLifeCycleHandler.this.publishDiagnostics(monitor);
                if (status.getSeverity() != 8) {
                    long elapsedTime = System.nanoTime() - startTime;
                    BaseDocumentLifeCycleHandler.this.movingAverageForDiagnostics.update(elapsedTime / 1000000L);
                }
                return status;
            }
            catch (JavaModelException e) {
                return e.getStatus();
            }
        }

        public boolean belongsTo(Object family) {
            return BaseDocumentLifeCycleHandler.PUBLISH_DIAGNOSTICS_JOBS.equals(family);
        }
    }
}

