/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.wizard.checkoutas;

import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.composite.DepthSelectionComposite;
import org.eclipse.team.svn.ui.composite.RevisionComposite;
import org.eclipse.team.svn.ui.extension.ExtensionsManager;
import org.eclipse.team.svn.ui.verifier.AbstractVerifierProxy;
import org.eclipse.team.svn.ui.verifier.CompositeVerifier;
import org.eclipse.team.svn.ui.verifier.NonEmptyFieldVerifier;
import org.eclipse.team.svn.ui.verifier.ResourceNameVerifier;
import org.eclipse.team.svn.ui.wizard.AbstractVerifiedWizardPage;
import org.eclipse.ui.PlatformUI;

public class CheckoutMethodSelectionPage
extends AbstractVerifiedWizardPage {
    protected static final int USE_NEW_PROJECT_WIZARD = 0;
    protected static final int FIND_PROJECTS = 1;
    protected static final int CHECKOUT_AS_PROJECT = 2;
    protected static final int CHECKOUT_AS_FOLDER = 3;
    protected String defaultName;
    protected Button selectLocationButton;
    protected Text nameField;
    protected RevisionComposite revisionComposite;
    protected DepthSelectionComposite depthSelector;
    protected String projectName;
    protected int checkoutType;
    protected IRepositoryResource resource;

    public CheckoutMethodSelectionPage(String defaultName, boolean newProjectSelectionEnabled, IRepositoryResource resource) {
        super(CheckoutMethodSelectionPage.class.getName(), SVNUIMessages.CheckoutMethodSelectionPage_Title, SVNTeamUIPlugin.instance().getImageDescriptor("icons/wizards/newconnect.gif"));
        this.setDescription(SVNUIMessages.CheckoutMethodSelectionPage_Description);
        this.projectName = this.defaultName = defaultName;
        this.checkoutType = newProjectSelectionEnabled ? 0 : 2;
        this.resource = resource;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public boolean isUseNewProjectWizard() {
        return this.checkoutType == 0;
    }

    public boolean isFindProjectsSelected() {
        return this.checkoutType == 1;
    }

    public boolean isCheckoutAsFolderSelected() {
        return this.checkoutType == 3;
    }

    public SVNDepth getdepth() {
        return this.depthSelector.getDepth();
    }

    public SVNRevision getSelectedRevision() {
        return this.revisionComposite.getSelectedRevision();
    }

    @Override
    protected Composite createControlImpl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.initializeDialogUnits((Control)composite);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        composite.setLayoutData((Object)data);
        this.setControl((Control)composite);
        Label description = new Label(composite, 64);
        data = new GridData(768);
        data.widthHint = 200;
        data.heightHint = this.convertHeightInCharsToPixels(this.checkoutType == 0 ? 1 : 2);
        description.setLayoutData((Object)data);
        String message = BaseMessages.format((String)SVNUIMessages.CheckoutMethodSelectionPage_HintHead, (Object[])new String[]{this.defaultName});
        description.setText(message + (String)(this.checkoutType != 0 ? " " + SVNUIMessages.CheckoutMethodSelectionPage_HintTail : ""));
        this.projectName = this.defaultName = FileUtility.formatResourceName((String)this.defaultName);
        Button useNewProjectWizardButton = new Button(composite, 16);
        data = new GridData(768);
        useNewProjectWizardButton.setLayoutData((Object)data);
        useNewProjectWizardButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckoutMethodSelectionPage.this.selectionChanged(0);
            }
        });
        useNewProjectWizardButton.setText(SVNUIMessages.CheckoutMethodSelectionPage_NewWizard);
        useNewProjectWizardButton.setSelection(this.checkoutType == 0);
        useNewProjectWizardButton.setEnabled(this.checkoutType == 0);
        Button findProjectsButton = new Button(composite, 16);
        data = new GridData(768);
        findProjectsButton.setLayoutData((Object)data);
        findProjectsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckoutMethodSelectionPage.this.selectionChanged(1);
            }
        });
        findProjectsButton.setText(SVNUIMessages.CheckoutMethodSelectionPage_Find);
        findProjectsButton.setEnabled(this.checkoutType == 0 || ExtensionsManager.getInstance().getCurrentCheckoutFactory().findProjectsOptionEnabled());
        Button checkoutAsFolder = new Button(composite, 16);
        data = new GridData(768);
        checkoutAsFolder.setLayoutData((Object)data);
        checkoutAsFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckoutMethodSelectionPage.this.selectionChanged(3);
            }
        });
        checkoutAsFolder.setText(SVNUIMessages.CheckoutMethodSelectionPage_Folder);
        this.selectLocationButton = new Button(composite, 16);
        data = new GridData(768);
        this.selectLocationButton.setLayoutData((Object)data);
        this.selectLocationButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CheckoutMethodSelectionPage.this.selectionChanged(2);
            }
        });
        this.selectLocationButton.setText(SVNUIMessages.CheckoutMethodSelectionPage_Project);
        this.selectLocationButton.setSelection(this.checkoutType != 0);
        this.nameField = new Text(composite, 2052);
        data = new GridData(768);
        this.nameField.setLayoutData((Object)data);
        this.nameField.setText(this.defaultName);
        this.nameField.setEnabled(this.checkoutType != 0);
        this.nameField.addModifyListener(e -> {
            String name;
            this.projectName = name = this.nameField.getText().trim();
        });
        String name = SVNUIMessages.CheckoutMethodSelectionPage_ProjectName_Verifier;
        CompositeVerifier verifier = new CompositeVerifier();
        verifier.add(new ResourceNameVerifier(name, false));
        verifier.add(new NonEmptyFieldVerifier(name));
        this.attachTo((Control)this.nameField, new AbstractVerifierProxy(verifier){

            @Override
            protected boolean isVerificationEnabled(Control input) {
                return CheckoutMethodSelectionPage.this.selectLocationButton.getSelection();
            }
        });
        Label separator = new Label(composite, 258);
        data = new GridData(768);
        data.horizontalSpan = 2;
        data.verticalIndent = 5;
        separator.setLayoutData((Object)data);
        data = new GridData(768);
        this.depthSelector = new DepthSelectionComposite(composite, 0, false);
        this.depthSelector.setLayoutData(data);
        this.revisionComposite = new RevisionComposite(composite, this, false, new String[]{SVNUIMessages.RevisionComposite_Revision, SVNUIMessages.RevisionComposite_HeadRevision}, SVNRevision.HEAD, false);
        data = new GridData(768);
        this.revisionComposite.setLayoutData(data);
        this.revisionComposite.setSelectedResource(this.resource);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.team.svn.help.checkoutMethodSelectionContext");
        return composite;
    }

    protected void selectionChanged(int newSelection) {
        this.checkoutType = newSelection;
        switch (this.checkoutType) {
            case 0: 
            case 1: 
            case 3: {
                this.projectName = this.defaultName;
                this.nameField.setEnabled(false);
                break;
            }
            case 2: {
                this.projectName = this.nameField.getText().trim();
                this.nameField.setEnabled(true);
            }
        }
        this.validateContent();
    }
}

