/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.synchronize;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.synchronize.action.AbstractSynchronizeModelAction;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.SynchronizeModelAction;
import org.eclipse.team.ui.synchronize.SynchronizePageActionGroup;

public abstract class AbstractSynchronizeActionGroup
extends SynchronizePageActionGroup {
    public static final String GROUP_MANAGE_LOCALS = "manageLocalChanges";
    public static final String GROUP_PROCESS_ALL = "processAllItems";
    public static final String GROUP_TEAM = "team";
    protected ISynchronizePageConfiguration configuration;
    protected MenuManager outgoing;
    protected MenuManager incoming;

    public final void initialize(ISynchronizePageConfiguration configuration) {
        this.configuration = configuration;
        super.initialize(this.configuration);
        this.configureActions(configuration);
    }

    public ISynchronizePageConfiguration getConfiguration() {
        return this.configuration;
    }

    public void dispose() {
        if (this.outgoing != null) {
            this.outgoing.removeAll();
            this.outgoing.dispose();
        }
        if (this.incoming != null) {
            this.incoming.removeAll();
            this.incoming.dispose();
        }
        super.dispose();
    }

    public abstract void configureMenuGroups(ISynchronizePageConfiguration var1);

    protected abstract void configureActions(ISynchronizePageConfiguration var1);

    protected void addSpecificActions(AbstractSynchronizeModelAction selectionProvider, ISynchronizePageConfiguration configuration) {
        this.outgoing = new MenuManager(SVNUIMessages.SynchronizeActionGroup_Outgoing);
        this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", GROUP_TEAM, (IContributionItem)this.outgoing);
        this.incoming = new MenuManager(SVNUIMessages.SynchronizeActionGroup_Incoming);
        this.appendToGroup("org.eclipse.team.ui.P_CONTEXT_MENU", GROUP_TEAM, (IContributionItem)this.incoming);
        boolean isEuropa = false;
        String version = (String)Platform.getBundle((String)"org.eclipse.core.runtime").getHeaders().get("Bundle-Version");
        if (version != null) {
            boolean bl = isEuropa = "3.4.0".compareTo(version) > 0;
        }
        if (isEuropa) {
            this.addLocalActions((IMenuManager)this.outgoing, configuration);
            this.addRemoteActions((IMenuManager)this.incoming, configuration);
        } else {
            this.outgoing.setRemoveAllWhenShown(true);
            this.outgoing.addMenuListener(manager -> {
                this.addLocalActions(manager, configuration);
                this.updateSelection(manager, (ISelection)selectionProvider.getStructuredSelection());
            });
            this.incoming.setRemoveAllWhenShown(true);
            this.incoming.addMenuListener(manager -> {
                this.addRemoteActions(manager, configuration);
                this.updateSelection(manager, (ISelection)selectionProvider.getStructuredSelection());
            });
        }
    }

    protected void addLocalActions(IMenuManager manager, ISynchronizePageConfiguration configuration) {
    }

    protected void addRemoteActions(IMenuManager manager, ISynchronizePageConfiguration configuration) {
    }

    protected void updateSelection(IMenuManager manager, ISelection selection) {
        IContributionItem[] items;
        IContributionItem[] iContributionItemArray = items = manager.getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            IAction actionItem;
            IContributionItem item = iContributionItemArray[n2];
            if (item instanceof ActionContributionItem && (actionItem = ((ActionContributionItem)item).getAction()) instanceof SynchronizeModelAction) {
                ((SynchronizeModelAction)actionItem).selectionChanged(selection);
            }
            ++n2;
        }
    }
}

