/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.panel.remote;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.composite.CommentComposite;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.panel.AbstractDialogPanel;
import org.eclipse.team.svn.ui.verifier.ExistingResourceVerifier;

public class CreateFilePanel
extends AbstractDialogPanel {
    protected Text locationField;
    protected String location;
    protected CommentComposite comment;
    protected String[] fileNames;

    public CreateFilePanel(String importToUrl) {
        this.dialogTitle = SVNUIMessages.CreateFilePanel_Title;
        this.dialogDescription = SVNUIMessages.CreateFilePanel_Description;
        this.defaultMessage = BaseMessages.format((String)SVNUIMessages.CreateFilePanel_Message, (Object[])new String[]{importToUrl});
    }

    @Override
    public void createControlsImpl(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        Composite fileGroup = new Composite(parent, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        fileGroup.setLayout((Layout)layout);
        data = new GridData(768);
        fileGroup.setLayoutData((Object)data);
        Label fileLabel = new Label(fileGroup, 0);
        data = new GridData();
        fileLabel.setLayoutData((Object)data);
        fileLabel.setText(SVNUIMessages.CreateFilePanel_FilePath);
        this.locationField = new Text(fileGroup, 2052);
        data = new GridData(768);
        this.locationField.setLayoutData((Object)data);
        this.locationField.addModifyListener(e -> {
            String text = this.locationField.getText();
            if (text.indexOf("\"") == -1) {
                this.location = new Path(text).removeLastSegments(1).toString();
            }
        });
        this.attachTo((Control)this.locationField, new ExistingResourceMultiVerifier(SVNUIMessages.CreateFilePanel_FilePath_Verifier));
        Button browseButton = new Button(fileGroup, 8);
        browseButton.setText(SVNUIMessages.Button_Browse);
        data = new GridData();
        data.widthHint = DefaultDialog.computeButtonWidth(browseButton);
        browseButton.setLayoutData((Object)data);
        browseButton.addListener(13, event -> {
            FileDialog fileDialog = new FileDialog(this.manager.getShell(), 2);
            fileDialog.setText(SVNUIMessages.CreateFilePanel_ImportFile);
            String path = fileDialog.open();
            if (path != null) {
                String[] fileNames = fileDialog.getFileNames();
                this.location = new Path(path).removeLastSegments(1).toString();
                this.fileNames = fileNames;
                if (fileNames.length > 1) {
                    Object text = "";
                    String[] stringArray = fileNames;
                    int n = fileNames.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String fileName = stringArray[n2];
                        text = (String)text + (((String)text).length() > 0 ? " \"" + fileName + "\"" : "\"" + fileName + "\"");
                        ++n2;
                    }
                    this.locationField.setText((String)text);
                } else {
                    this.locationField.setText(path);
                }
            }
        });
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout());
        data = new GridData(1808);
        group.setLayoutData((Object)data);
        group.setText(SVNUIMessages.CreateFilePanel_Comment);
        this.comment = new CommentComposite((Composite)group, this);
        data = new GridData(1808);
        this.comment.setLayoutData(data);
    }

    @Override
    public Point getPrefferedSizeImpl() {
        return new Point(525, -1);
    }

    @Override
    public void postInit() {
        super.postInit();
        this.comment.postInit(this.manager);
    }

    @Override
    protected void saveChangesImpl() {
        this.comment.saveChanges();
        String text = this.locationField.getText();
        if (text.indexOf("\"") > -1) {
            this.fileNames = this.parseFileNames(text);
        } else {
            Path path = new Path(text);
            this.location = path.removeLastSegments(1).toString();
            this.fileNames = new String[]{path.lastSegment()};
        }
    }

    protected String[] parseFileNames(String text) {
        BufferedReader r = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(text.getBytes())));
        final StreamTokenizer tokenizer = new StreamTokenizer(r);
        tokenizer.resetSyntax();
        tokenizer.quoteChar(34);
        tokenizer.whitespaceChars(32, 32);
        final HashSet fileNames = new HashSet();
        new AbstractActionOperation("Operation_ParseFile", SVNUIMessages.class){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                while (tokenizer.nextToken() != -1) {
                    fileNames.add(tokenizer.sval);
                }
            }

            public ISchedulingRule getSchedulingRule() {
                return null;
            }
        }.run((IProgressMonitor)new NullProgressMonitor());
        return fileNames.toArray(new String[fileNames.size()]);
    }

    @Override
    public String getHelpId() {
        return "org.eclipse.team.svn.help.remote_createFileDialogContext";
    }

    @Override
    protected void cancelChangesImpl() {
        this.comment.cancelChanges();
    }

    public String getLocation() {
        return this.location;
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public String getMessage() {
        return this.comment.getMessage();
    }

    protected class ExistingResourceMultiVerifier
    extends ExistingResourceVerifier {
        protected String ERROR_MESSAGE_DOES_NOT_EXIST_MULTIPLE;
        protected String ERROR_MESSAGE_IS_NOT_A_FILE_MULTIPLE;

        public ExistingResourceMultiVerifier(String fieldName) {
            super(fieldName, true);
            this.ERROR_MESSAGE_DOES_NOT_EXIST_MULTIPLE = BaseMessages.format((String)SVNUIMessages.CreateFilePanel_FilePath_Verifier_Error_Exists, (Object[])new String[]{"$FIELD_NAME$"});
            this.ERROR_MESSAGE_IS_NOT_A_FILE_MULTIPLE = BaseMessages.format((String)SVNUIMessages.CreateFilePanel_FilePath_Verifier_Error_NotAFile, (Object[])new String[]{"$FIELD_NAME$"});
        }

        @Override
        protected String getErrorMessageImpl(Control input) {
            if (CreateFilePanel.this.location == null) {
                return ExistingResourceVerifier.ERROR_MESSAGE_DOES_NOT_EXIST;
            }
            boolean existAll = true;
            boolean allFiles = true;
            String text = this.getText(input);
            if (text.indexOf("\"") > -1) {
                String[] fileNames;
                String[] stringArray = fileNames = CreateFilePanel.this.parseFileNames(text);
                int n = fileNames.length;
                int n2 = 0;
                while (n2 < n) {
                    String fileName = stringArray[n2];
                    if (fileName == null || fileName.trim().length() == 0) {
                        existAll = false;
                        break;
                    }
                    String pathToFile = new Path(CreateFilePanel.this.location).append(fileName).toString();
                    File file = new File(pathToFile);
                    existAll = existAll && file.exists();
                    boolean bl = allFiles = allFiles && file.isFile();
                    if (!existAll || !allFiles) break;
                    ++n2;
                }
                if (!existAll) {
                    return this.ERROR_MESSAGE_DOES_NOT_EXIST_MULTIPLE;
                }
                if (!allFiles) {
                    return this.ERROR_MESSAGE_IS_NOT_A_FILE_MULTIPLE;
                }
            } else {
                return super.getErrorMessageImpl(input);
            }
            return null;
        }
    }
}

