/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.panel.common;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.panel.AbstractDialogPanel;
import org.eclipse.team.svn.ui.preferences.SVNTeamPropsPreferencePage;
import org.eclipse.team.svn.ui.verifier.AbstractVerifierProxy;
import org.eclipse.team.svn.ui.verifier.CompositeVerifier;
import org.eclipse.team.svn.ui.verifier.FileNameTemplateVerifier;
import org.eclipse.team.svn.ui.verifier.MultiLinePropertyVerifier;
import org.eclipse.team.svn.ui.verifier.NonEmptyFieldVerifier;

public class EditAutoPropertiesPanel
extends AbstractDialogPanel {
    protected SVNTeamPropsPreferencePage.AutoProperty property;
    protected Text txtFileName;
    protected Text txtProperties;
    protected String fileName;
    protected String properties;

    public EditAutoPropertiesPanel(SVNTeamPropsPreferencePage.AutoProperty property) {
        this.property = property;
        this.dialogTitle = property == null ? SVNUIMessages.EditAutoPropertiesPanel_Title_Add : SVNUIMessages.EditAutoPropertiesPanel_Title_Edit;
        this.dialogDescription = SVNUIMessages.EditAutoPropertiesPanel_Description;
        this.defaultMessage = SVNUIMessages.EditAutoPropertiesPanel_Message;
    }

    @Override
    public void createControlsImpl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginBottom = 5;
        composite.setLayout((Layout)layout);
        GridData layoutData = new GridData(768);
        composite.setLayoutData((Object)layoutData);
        Label label = new Label(composite, 0);
        label.setText(SVNUIMessages.EditAutoPropertiesPanel_FileName);
        this.txtFileName = new Text(composite, 2048);
        this.txtFileName.setText(this.property == null ? "" : this.property.fileName);
        layoutData = new GridData(768);
        this.txtFileName.setLayoutData((Object)layoutData);
        String fieldName = SVNUIMessages.EditAutoPropertiesPanel_FileName_Verifier;
        CompositeVerifier verifier = new CompositeVerifier();
        verifier.add(new NonEmptyFieldVerifier(fieldName));
        verifier.add(new AbstractVerifierProxy(new FileNameTemplateVerifier(fieldName)){

            @Override
            protected boolean isVerificationEnabled(Control input) {
                return EditAutoPropertiesPanel.this.txtFileName.getText().trim().length() > 0;
            }
        });
        this.attachTo((Control)this.txtFileName, verifier);
        Group group = new Group(parent, 0);
        group.setText(SVNUIMessages.EditAutoPropertiesPanel_Properties);
        layoutData = new GridData(1808);
        group.setLayoutData((Object)layoutData);
        layout = new GridLayout();
        group.setLayout((Layout)layout);
        label = new Label((Composite)group, 0);
        label.setText(SVNUIMessages.EditAutoPropertiesPanel_Properties_Hint);
        this.txtProperties = new Text((Composite)group, 2818);
        this.txtProperties.setText(this.property == null ? "" : this.property.properties.trim());
        layoutData = new GridData(1808);
        layoutData.heightHint = DefaultDialog.convertHeightInCharsToPixels((Control)this.txtProperties, 7);
        this.txtProperties.setLayoutData((Object)layoutData);
        this.attachTo((Control)this.txtProperties, new AbstractVerifierProxy(new MultiLinePropertyVerifier(SVNUIMessages.EditAutoPropertiesPanel_Properties_Verifier)){

            @Override
            protected boolean isVerificationEnabled(Control input) {
                return EditAutoPropertiesPanel.this.txtProperties.getText().trim().length() > 0;
            }
        });
    }

    @Override
    protected void cancelChangesImpl() {
    }

    @Override
    protected void saveChangesImpl() {
        this.fileName = this.txtFileName.getText().trim();
        this.properties = this.txtProperties.getText().trim();
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getProperties() {
        return this.properties;
    }
}

