/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.lock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.lock.LockResource;
import org.eclipse.team.svn.ui.lock.LockResourceSelectionComposite;
import org.eclipse.team.svn.ui.lock.LockResourcesTableLabelProvider;
import org.eclipse.team.svn.ui.lock.LockResourcesTreeContentProvider;
import org.eclipse.team.svn.ui.lock.LockResourcesTreeLabelProvider;
import org.eclipse.team.svn.ui.lock.LocksView;
import org.eclipse.team.svn.ui.utility.LockProposeUtility;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.ui.IWorkbenchPart;

public class LocksComposite
extends Composite {
    protected boolean isProcessing = false;
    protected IResource resource;
    protected LockResource rootLockResource;
    protected LockResourceSelectionComposite tableViewer;
    protected TreeViewer treeViewer;
    protected Text commentText;
    protected LockResourcesTreeLabelProvider labelProvider;

    public LocksComposite(Composite parent) {
        super(parent, 0);
        this.createControls(parent);
    }

    private void createControls(Composite parent) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        SashForm outerSashForm = new SashForm((Composite)this, 512);
        outerSashForm.setLayoutData((Object)new GridData(1808));
        SashForm innerSashForm = new SashForm((Composite)outerSashForm, 256);
        innerSashForm.setLayoutData((Object)new GridData(1808));
        this.createResourcesTree((Composite)innerSashForm);
        this.createResourcesTable((Composite)innerSashForm);
        innerSashForm.setWeights(new int[]{25, 75});
        this.createCommentComposite((Composite)outerSashForm);
        outerSashForm.setWeights(new int[]{70, 30});
    }

    protected void createCommentComposite(Composite parent) {
        this.commentText = new Text(parent, 770);
        this.commentText.setBackground(this.commentText.getBackground());
        this.commentText.setEditable(false);
        GridData data = new GridData(1808);
        this.commentText.setLayoutData((Object)data);
    }

    protected void createResourcesTable(Composite parent) {
        this.tableViewer = new LockResourceSelectionComposite(parent, 0, false, false);
        this.tableViewer.addResourcesSelectionChangedListener(event -> {
            if (event.selection != null && !event.selection.isEmpty()) {
                LockResource lockResource = (LockResource)event.selection.getFirstElement();
                if (!LockResourcesTableLabelProvider.isFakeLockResource(lockResource)) {
                    this.commentText.setText(lockResource.getComment() == null || lockResource.getComment().length() == 0 ? SVNMessages.SVNInfo_NoComment : lockResource.getComment());
                } else {
                    this.commentText.setText("");
                }
            }
        });
        this.tableViewer.setMenuManager(this.createResourcesTableMenu());
    }

    protected MenuManager createResourcesTreeMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.addMenuListener(manager -> {
            LockResource[] children;
            LockResource lockResource;
            IStructuredSelection tSelection = (IStructuredSelection)this.treeViewer.getSelection();
            if (tSelection.size() == 1 && LockResourcesTableLabelProvider.isFakeLockResource(lockResource = (LockResource)tSelection.getFirstElement())) {
                return;
            }
            manager.add((IContributionItem)new Separator("additions"));
            HashMap<LockResource.LockStatusEnum, List<LockResource>> resourcesMap = new HashMap<LockResource.LockStatusEnum, List<LockResource>>();
            LockResource lockResource2 = (LockResource)tSelection.getFirstElement();
            LockResource[] lockResourceArray = children = lockResource2.getAllChildFiles();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                LockResource child = lockResourceArray[n2];
                ArrayList<LockResource> resourcesList = (ArrayList<LockResource>)resourcesMap.get((Object)child.getLockStatus());
                if (resourcesList == null) {
                    resourcesList = new ArrayList<LockResource>();
                    resourcesMap.put(child.getLockStatus(), resourcesList);
                }
                resourcesList.add(child);
                ++n2;
            }
            manager.add((IAction)this.createLockAction(resourcesMap));
            manager.add((IAction)this.createUnlockAction(resourcesMap));
            manager.add((IAction)this.createBreakLockAction(resourcesMap));
        });
        menuMgr.setRemoveAllWhenShown(true);
        return menuMgr;
    }

    protected MenuManager createResourcesTableMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.addMenuListener(manager -> {
            LockResource lockResource;
            IStructuredSelection tSelection = (IStructuredSelection)this.tableViewer.getTableViewer().getSelection();
            if (tSelection.size() == 1 && LockResourcesTableLabelProvider.isFakeLockResource(lockResource = (LockResource)tSelection.getFirstElement())) {
                return;
            }
            manager.add((IContributionItem)new Separator("additions"));
            HashMap<LockResource.LockStatusEnum, List<LockResource>> resourcesMap = new HashMap<LockResource.LockStatusEnum, List<LockResource>>();
            for (LockResource lockResource2 : tSelection) {
                ArrayList<LockResource> resourcesList = (ArrayList<LockResource>)resourcesMap.get((Object)lockResource2.getLockStatus());
                if (resourcesList == null) {
                    resourcesList = new ArrayList<LockResource>();
                    resourcesMap.put(lockResource2.getLockStatus(), resourcesList);
                }
                resourcesList.add(lockResource2);
            }
            manager.add((IAction)this.createLockAction(resourcesMap));
            manager.add((IAction)this.createUnlockAction(resourcesMap));
            manager.add((IAction)this.createBreakLockAction(resourcesMap));
        });
        menuMgr.setRemoveAllWhenShown(true);
        return menuMgr;
    }

    protected Action createLockAction(Map<LockResource.LockStatusEnum, List<LockResource>> resourcesMap) {
        final ArrayList lockResources = new ArrayList();
        if (resourcesMap.containsKey((Object)LockResource.LockStatusEnum.BROKEN)) {
            lockResources.addAll(resourcesMap.get((Object)LockResource.LockStatusEnum.BROKEN));
        }
        if (resourcesMap.containsKey((Object)LockResource.LockStatusEnum.STOLEN)) {
            lockResources.addAll(resourcesMap.get((Object)LockResource.LockStatusEnum.STOLEN));
        }
        if (resourcesMap.containsKey((Object)LockResource.LockStatusEnum.OTHER_LOCKED)) {
            lockResources.addAll(resourcesMap.get((Object)LockResource.LockStatusEnum.OTHER_LOCKED));
        }
        if (lockResources != null && !lockResources.isEmpty()) {
            Iterator iter = lockResources.iterator();
            while (iter.hasNext()) {
                LockResource lockResource = (LockResource)iter.next();
                IResource resource = (IResource)lockResource.getAdapter(IResource.class);
                if (IStateFilter.SF_VERSIONED.accept(SVNRemoteStorage.instance().asLocalResource(resource))) continue;
                iter.remove();
            }
        }
        Action action = new Action(SVNUIMessages.LockAction_label){

            public void run() {
                CompositeOperation op = LockProposeUtility.performLockAction(lockResources.toArray(new LockResource[0]), true, LocksComposite.this.getShell());
                if (op != null) {
                    UIMonitorUtility.doTaskScheduledDefault((IWorkbenchPart)LocksView.instance(), (IActionOperation)op);
                }
            }
        };
        action.setEnabled(!lockResources.isEmpty());
        action.setImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/common/actions/lock.gif"));
        return action;
    }

    protected Action createBreakLockAction(final Map<LockResource.LockStatusEnum, List<LockResource>> resourcesMap) {
        Action action = new Action(SVNUIMessages.BreakLockAction_label2){

            public void run() {
                CompositeOperation op;
                ArrayList lockResources = new ArrayList();
                if (resourcesMap.containsKey((Object)LockResource.LockStatusEnum.OTHER_LOCKED)) {
                    lockResources.addAll((Collection)resourcesMap.get((Object)LockResource.LockStatusEnum.OTHER_LOCKED));
                }
                if (resourcesMap.containsKey((Object)LockResource.LockStatusEnum.STOLEN)) {
                    lockResources.addAll((Collection)resourcesMap.get((Object)LockResource.LockStatusEnum.STOLEN));
                }
                if (lockResources != null && !lockResources.isEmpty() && (op = LockProposeUtility.performBreakLockAction(lockResources.toArray(new LockResource[0]), LocksComposite.this.getShell())) != null) {
                    op.add((IActionOperation)new AbstractActionOperation("", SVNUIMessages.class){

                        protected void runImpl(IProgressMonitor monitor) throws Exception {
                            LocksView.instance().refresh();
                        }
                    });
                    UIMonitorUtility.doTaskScheduledDefault((IWorkbenchPart)LocksView.instance(), (IActionOperation)op);
                }
            }
        };
        action.setEnabled(resourcesMap.containsKey((Object)LockResource.LockStatusEnum.OTHER_LOCKED) || resourcesMap.containsKey((Object)LockResource.LockStatusEnum.STOLEN));
        return action;
    }

    protected Action createUnlockAction(final Map<LockResource.LockStatusEnum, List<LockResource>> resourcesMap) {
        Action action = new Action(SVNUIMessages.UnlockAction_label){

            public void run() {
                CompositeOperation op;
                List lockResources = (List)resourcesMap.get((Object)LockResource.LockStatusEnum.LOCALLY_LOCKED);
                if (lockResources != null && !lockResources.isEmpty() && (op = LockProposeUtility.performUnlockAction(lockResources.toArray(new LockResource[0]), LocksComposite.this.getShell())) != null) {
                    UIMonitorUtility.doTaskScheduledDefault((IWorkbenchPart)LocksView.instance(), (IActionOperation)op);
                }
            }
        };
        action.setImageDescriptor(SVNTeamUIPlugin.instance().getImageDescriptor("icons/common/actions/unlock.gif"));
        action.setEnabled(resourcesMap.containsKey((Object)LockResource.LockStatusEnum.LOCALLY_LOCKED));
        return action;
    }

    protected void createResourcesTree(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 768);
        this.treeViewer.setContentProvider((IContentProvider)new LockResourcesTreeContentProvider());
        this.labelProvider = new LockResourcesTreeLabelProvider();
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){
            protected LockResource oldSelection;

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection tSelection = (IStructuredSelection)event.getSelection();
                if (tSelection.size() > 0) {
                    LockResource selection = (LockResource)tSelection.getFirstElement();
                    if (this.oldSelection != selection) {
                        LocksComposite.this.tableViewer.setInput(selection.getAllChildFiles());
                        this.oldSelection = selection;
                    }
                } else {
                    LocksComposite.this.tableViewer.setInput(null);
                }
            }
        });
        MenuManager menuManager = this.createResourcesTreeMenu();
        Menu menu = menuManager.createContextMenu((Control)this.treeViewer.getTree());
        this.treeViewer.getTree().setMenu(menu);
    }

    public void initializeComposite() {
        if (this.isProcessing) {
            this.treeViewer.setInput(null);
            this.tableViewer.setInput(new LockResource[]{LockResourcesTableLabelProvider.FAKE_PENDING});
            this.tableViewer.getTableViewer().getTable().setLinesVisible(false);
            this.commentText.setText("");
        } else {
            ((LockResourcesTreeContentProvider)this.treeViewer.getContentProvider()).initialize(this.rootLockResource);
            if (this.rootLockResource != null) {
                this.treeViewer.setInput((Object)SVNUIMessages.LocksComposite_Root);
                this.treeViewer.expandAll();
                this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)this.rootLockResource));
                ((Tree)this.treeViewer.getControl()).showSelection();
                this.tableViewer.getTableViewer().getTable().setLinesVisible(true);
            } else {
                this.treeViewer.setInput(null);
                this.tableViewer.setInput(new LockResource[]{LockResourcesTableLabelProvider.FAKE_NO_LOCKS});
                this.tableViewer.getTableViewer().getTable().setLinesVisible(false);
                this.commentText.setText("");
            }
        }
    }

    public void setPending(boolean isProcessing) {
        this.isProcessing = isProcessing;
    }

    public boolean isPending() {
        return this.isProcessing;
    }

    public synchronized void setResource(IResource resource) {
        this.resource = resource;
    }

    public void setRootLockResource(LockResource rootLockResource) {
        this.rootLockResource = rootLockResource;
    }

    public synchronized void disconnectComposite() {
        this.resource = null;
        this.rootLockResource = null;
    }
}

