/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.pde.build;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.pde.build.IAntScript;
import org.eclipse.pde.build.IFetchFactory;
import org.eclipse.pde.internal.build.Utils;
import org.eclipse.team.svn.pde.build.IMapFileParser;
import org.osgi.framework.Version;

public class SVNFetchFactory
implements IFetchFactory {
    public static final String TARGET_FETCH_FROM_SVN = "FetchFromSVN";
    public static final String MAP_ENTRY_SEPARATOR = ",";
    public static final String VALUE_PAIR_SEPARATOR = "=";
    public static final String OVERRIDE_TAG = "SVN";
    public static final String KEY_URL = "url";
    public static final String KEY_PEG = "peg";
    public static final String KEY_TAG_PATH = "tagPath";
    public static final String KEY_REVISION = "revision";
    public static final String KEY_PATH = "path";
    public static final String KEY_USERNAME = "username";
    public static final String KEY_PASSWORD = "password";
    public static final String KEY_FORCE = "force";
    public static final String PROP_FILETOCHECK = "fileToCheck";
    public static final String PROP_ELEMENTNAME = "elementName";
    public static final String PROP_DESTINATIONFOLDER = "destinationFolder";
    public static final String PROP_URL = "url";
    public static final String PROP_PEG = "peg";
    public static final String PROP_REVISION = "revision";
    public static final String PROP_TAG = "tag";
    public static final String PROP_TAG_PATH = "tagPath";
    public static final String PROP_PATH = "path";
    public static final String PROP_USERNAME = "username";
    public static final String PROP_PASSWORD = "password";
    public static final String PROP_FORCE = "force";
    protected static Pattern tagPattern = Pattern.compile("[\\.a-zA-Z_0-9-]+");

    public void addTargets(IAntScript script) {
        script.printTargetDeclaration(TARGET_FETCH_FROM_SVN, null, null, "${fileToCheck}", null);
        this.printSVNTask("export", "${url}/${tagPath}/${path}", "${peg}", "${revision}", "${destinationFolder}/${elementName}", "${username}", "${password}", script, "${force}");
        script.printTargetEnd();
    }

    public void generateRetrieveElementCall(Map entryInfos, IPath destination, IAntScript script) {
        String type = (String)entryInfos.get("type");
        String element = (String)entryInfos.get("element");
        HashMap<String, Object> params = new HashMap<String, Object>();
        IPath locationToCheck = (IPath)destination.clone();
        if (type.equals("feature")) {
            locationToCheck = locationToCheck.append("feature.xml");
        } else if (type.equals("plugin")) {
            locationToCheck = locationToCheck.append("plugin.xml");
        } else if (type.equals("fragment")) {
            locationToCheck = locationToCheck.append("fragment.xml");
        } else if (type.equals("bundle")) {
            locationToCheck = locationToCheck.append("META-INF/MANIFEST.MF");
        }
        if (Version.emptyVersion.equals(entryInfos.get("internal.matchedVersion"))) {
            params.put(PROP_ELEMENTNAME, element);
        } else {
            params.put(PROP_ELEMENTNAME, element + "_" + String.valueOf(entryInfos.get("internal.matchedVersion")));
        }
        params.put(PROP_FILETOCHECK, locationToCheck.toString());
        params.put(PROP_DESTINATIONFOLDER, destination.removeLastSegments(1).toString());
        params.put("url", (String)entryInfos.get("url"));
        if (entryInfos.containsKey("peg")) {
            params.put("peg", (String)entryInfos.get("peg"));
        } else {
            params.put("peg", "HEAD");
        }
        if (entryInfos.containsKey("revision")) {
            params.put("revision", (String)entryInfos.get("revision"));
        } else {
            params.put("revision", "HEAD");
        }
        params.put(PROP_TAG, (String)entryInfos.get(PROP_TAG));
        params.put("tagPath", (String)entryInfos.get("tagPath"));
        params.put("path", (String)entryInfos.get("path"));
        String username = (String)entryInfos.get("username");
        params.put("username", username != null ? username : "");
        String password = (String)entryInfos.get("password");
        params.put("password", password != null ? password : "");
        params.put("force", this.getBooleanValue(entryInfos, "force"));
        this.printAvailableTask(locationToCheck.toString(), locationToCheck.toString(), script);
        if ("plugin".equals(type) || "fragment".equals(type)) {
            this.printAvailableTask(locationToCheck.toString(), locationToCheck.removeLastSegments(1).append("META-INF/MANIFEST.MF").toString(), script);
        }
        script.printAntCallTask(TARGET_FETCH_FROM_SVN, true, params);
    }

    protected String getBooleanValue(Map entryInfos, String key) {
        String res = "false";
        String str = (String)entryInfos.get(key);
        if (str != null) {
            res = Boolean.valueOf(str).toString();
        }
        return res;
    }

    public void generateRetrieveFilesCall(Map entryInfos, IPath destination, String[] files, IAntScript script) {
        String rootUrl = (String)entryInfos.get("url");
        String pegRev = (String)entryInfos.get("peg");
        String rev = (String)entryInfos.get("revision");
        String tag = (String)entryInfos.get("tagPath");
        String path = (String)entryInfos.get("path");
        Object baseUrl = rootUrl;
        if (tag != null && tag.length() > 0) {
            baseUrl = (String)baseUrl + "/" + tag;
        }
        if (path != null && path.length() > 0) {
            baseUrl = (String)baseUrl + "/" + path;
        }
        baseUrl = (String)baseUrl + "/";
        String dest = destination.toString();
        String username = (String)entryInfos.get("username");
        String password = (String)entryInfos.get("password");
        String force = this.getBooleanValue(entryInfos, "force");
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String fileName = stringArray[n2];
            this.printSVNTask("cat", (String)baseUrl + fileName, pegRev, rev, dest + "/" + fileName, username, password, script, force);
            ++n2;
        }
    }

    public void parseMapFileEntry(String rawEntry, Properties overrideTags, Map entryInfos) throws CoreException {
        String[] arguments = Utils.getArrayFromStringWithBlank((String)rawEntry, (String)MAP_ENTRY_SEPARATOR);
        IMapFileParser parser = SVNFetchFactory.getMapFileParser(arguments);
        IMapFileParser.FetchData data = parser.parse(rawEntry, arguments, overrideTags);
        entryInfos.put("url", data.url);
        entryInfos.put("path", data.path);
        if (data.tag == null || data.tag.length() == 0 || "trunk".equals(data.tag)) {
            entryInfos.put("tagPath", "trunk");
        } else {
            int ind = data.tag.lastIndexOf("/");
            String tagValue = ind > 0 ? data.tag.substring(ind + 1) : data.tag;
            String tagPath = data.tag;
            if (!tagPath.contains("branches/")) {
                if (tagValue != null && !tagPattern.matcher(tagValue).matches()) {
                    throw new RuntimeException("Tag doesn't match to pattern. Tag: " + tagValue + ", pattern: " + tagPattern.toString());
                }
                if (tagValue != null) {
                    entryInfos.put(PROP_TAG, tagValue);
                }
            }
            entryInfos.put("tagPath", tagPath);
        }
        if (data.revision != null) {
            entryInfos.put("revision", data.revision);
        }
        if (data.peg != null) {
            entryInfos.put("peg", data.peg);
        }
        if (data.username != null) {
            entryInfos.put("username", data.username);
        }
        if (data.password != null) {
            entryInfos.put("password", data.password);
        }
        if (data.force != null) {
            entryInfos.put("force", data.force);
        }
    }

    public static IMapFileParser getMapFileParser(String[] arguments) {
        String key;
        boolean isDefault = false;
        String arg = arguments[0];
        int index = arg.indexOf(VALUE_PAIR_SEPARATOR);
        if (index != -1 && "url".equals(key = arg.substring(0, index))) {
            isDefault = true;
        }
        return isDefault ? IMapFileParser.DEFAULT : IMapFileParser.SOURCE_FORGE_PARSER;
    }

    protected void printSVNTask(String command, String url, String pegRev, String rev, String dest, String username, String password, IAntScript script) {
        this.printSVNTask(command, url, pegRev, rev, dest, username, password, script, "false");
    }

    protected void printSVNTask(String command, String url, String pegRev, String rev, String dest, String username, String password, IAntScript script, String force) {
        script.printTabs();
        script.print("<svn");
        script.printAttribute("command", command, false);
        script.printAttribute("url", url, false);
        script.printAttribute("pegRev", pegRev, false);
        script.printAttribute("rev", rev, false);
        script.printAttribute("dest", dest, false);
        script.printAttribute("username", username, false);
        script.printAttribute("password", password, false);
        script.printAttribute("force", force, false);
        script.println("/>");
    }

    protected void printAvailableTask(String property, String file, IAntScript script) {
        script.printTabs();
        script.print("<available");
        script.printAttribute("property", property, true);
        script.printAttribute("file", file, false);
        script.println("/>");
    }
}

