/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.synchronize.merge.action;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IResource;
import org.eclipse.team.core.synchronize.FastSyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.connector.SVNConflictResolution;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.local.GetRemoteContentsOperation;
import org.eclipse.team.svn.core.operation.local.MarkResolvedOperation;
import org.eclipse.team.svn.core.operation.local.RefreshResourcesOperation;
import org.eclipse.team.svn.core.operation.local.RestoreProjectMetaOperation;
import org.eclipse.team.svn.core.operation.local.SaveProjectMetaOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IResourceChange;
import org.eclipse.team.svn.core.synchronize.AbstractSVNSyncInfo;
import org.eclipse.team.svn.core.synchronize.IMergeSyncInfo;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.operation.ClearMergeStatusesOperation;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.synchronize.action.AbstractSynchronizeModelAction;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public class OverrideAndUpdateAction
extends AbstractSynchronizeModelAction {
    public OverrideAndUpdateAction(String text, ISynchronizePageConfiguration configuration) {
        super(text, configuration);
    }

    protected FastSyncInfoFilter getSyncInfoFilter() {
        return new FastSyncInfoFilter.SyncInfoDirectionFilter(new int[]{12, 8}){

            public boolean select(SyncInfo info) {
                if (super.select(info) && info instanceof IMergeSyncInfo) {
                    ILocalResource local = ((AbstractSVNSyncInfo)info).getLocalResource();
                    if (IStateFilter.SF_TREE_CONFLICTING.accept(local)) {
                        IResourceChange resourceChange = ((IMergeSyncInfo)info).getRemoteResource();
                        return resourceChange != null && "Deleted" != resourceChange.getStatus();
                    }
                    return true;
                }
                return false;
            }
        };
    }

    @Override
    protected IActionOperation getOperation(ISynchronizePageConfiguration configuration, IDiffElement[] elements) {
        AbstractSVNSyncInfo[] infos = this.getSVNSyncInfos();
        HashMap<String, String> remote2local = new HashMap<String, String>();
        ArrayList<IRepositoryResource> remoteSet = new ArrayList<IRepositoryResource>();
        ArrayList<IResource> localSet = new ArrayList<IResource>();
        AbstractSVNSyncInfo[] abstractSVNSyncInfoArray = infos;
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            IResourceChange resourceChange;
            AbstractSVNSyncInfo element = abstractSVNSyncInfoArray[n2];
            IResource resource = element.getLocal();
            localSet.add(resource);
            if (element instanceof IMergeSyncInfo && (resourceChange = ((IMergeSyncInfo)element).getRemoteResource()) != null) {
                IRepositoryResource remote = resourceChange.getOriginator();
                remoteSet.add(remote);
                remote2local.put(SVNUtility.encodeURL((String)remote.getUrl()), FileUtility.getWorkingCopyPath((IResource)resource));
            }
            ++n2;
        }
        if (!remote2local.isEmpty()) {
            IResource[] resources = localSet.toArray(new IResource[localSet.size()]);
            boolean ignoreExternals = SVNTeamPreferences.getBehaviourBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "externals.ignore");
            GetRemoteContentsOperation mainOp = new GetRemoteContentsOperation(resources, remoteSet.toArray(new IRepositoryResource[remoteSet.size()]), remote2local, ignoreExternals);
            CompositeOperation op = new CompositeOperation(mainOp.getId(), mainOp.getMessagesClass());
            SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(resources);
            op.add((IActionOperation)saveOp);
            IResource[] conflicting = FileUtility.getResourcesRecursive((IResource[])resources, (IStateFilter)IStateFilter.SF_CONFLICTING, (int)0);
            if (conflicting.length > 0) {
                op.add((IActionOperation)new MarkResolvedOperation(conflicting, SVNConflictResolution.Choice.CHOOSE_LOCAL_FULL, SVNDepth.INFINITY));
            }
            op.add((IActionOperation)mainOp);
            op.add((IActionOperation)new RestoreProjectMetaOperation(saveOp));
            op.add((IActionOperation)new RefreshResourcesOperation(conflicting.length > 0 ? FileUtility.getParents((IResource[])resources, (boolean)false) : resources));
            op.add((IActionOperation)new ClearMergeStatusesOperation(resources));
            return op;
        }
        return null;
    }
}

