/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.panel.participant;

import org.eclipse.core.resources.IResource;
import org.eclipse.swt.widgets.Control;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.panel.local.CommitPanel;
import org.eclipse.team.svn.ui.panel.participant.PaneParticipantHelper;

public class CommitPaneParticipantHelper
extends PaneParticipantHelper {
    @Override
    protected SyncInfoSet getPaneSyncInfoSetToProcess() {
        SyncInfo[] syncInfos;
        SyncInfoSet resultSet = new SyncInfoSet();
        SyncInfoSet syncSet = super.getPaneSyncInfoSetToProcess();
        SyncInfo[] syncInfoArray = syncInfos = syncSet.getSyncInfos();
        int n = syncInfos.length;
        int n2 = 0;
        while (n2 < n) {
            SyncInfo syncInfo = syncInfoArray[n2];
            int direction = syncInfo.getKind() & 0xC;
            if (direction == 4 || direction == 12) {
                resultSet.add(syncInfo);
            }
            ++n2;
        }
        return resultSet;
    }

    public static class CommitPaneVerifier
    extends PaneParticipantHelper.PaneVerifier {
        public CommitPaneVerifier(PaneParticipantHelper paneParticipantHelper) {
            super(paneParticipantHelper);
        }

        @Override
        protected String getErrorMessage(Control input) {
            String errorMessage = super.getErrorMessage(input);
            if (errorMessage == null) {
                IResource[] resourcesToProcess = this.paneParticipantHelper.getSelectedResources();
                if (FileUtility.checkForResourcesPresenceRecursive((IResource[])resourcesToProcess, (IStateFilter)new IStateFilter.OrStateFilter(new IStateFilter[]{IStateFilter.SF_CONFLICTING, IStateFilter.SF_TREE_CONFLICTING}))) {
                    return SVNUIMessages.CommitPanel_Pane_Conflicting_Error;
                }
                return null;
            }
            return errorMessage;
        }

        @Override
        protected String getWarningMessage(Control input) {
            IResource[] resourcesToProcess;
            String message = super.getWarningMessage(input);
            if (message == null && (resourcesToProcess = this.paneParticipantHelper.getSelectedResources()) != null && resourcesToProcess.length > 0) {
                message = CommitPanel.validateResources(resourcesToProcess);
            }
            return message;
        }
    }
}

