/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.panel.local;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.panel.AbstractDialogPanel;
import org.eclipse.team.svn.ui.panel.IDialogManager;
import org.eclipse.team.svn.ui.verifier.AbstractFormattedVerifier;
import org.eclipse.team.svn.ui.verifier.CompositeVerifier;
import org.eclipse.team.svn.ui.verifier.NonEmptyFieldVerifier;
import org.eclipse.team.svn.ui.verifier.ResourceNameVerifier;
import org.eclipse.ui.internal.ide.misc.ContainerContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class SavePatchInWorkspacePanel
extends AbstractDialogPanel {
    protected TreeViewer treeViewer;
    protected Text workspaceFilenameField;
    protected String proposedName;
    protected IFile file;
    protected IProject proposedDestination;

    public SavePatchInWorkspacePanel(String proposedName, IProject proposedDestination) {
        this.dialogTitle = SVNUIMessages.SavePatchInWorkspace_Title;
        this.dialogDescription = SVNUIMessages.SavePatchInWorkspace_Description;
        this.defaultMessage = SVNUIMessages.SavePatchInWorkspace_Message;
        this.proposedName = proposedName;
        this.proposedDestination = proposedDestination;
    }

    public IFile getFile() {
        return this.file;
    }

    @Override
    public String getHelpId() {
        return "org.eclipse.team.svn.help.savePatchInWorkspaceContext";
    }

    @Override
    public void initPanel(IDialogManager manager) {
        super.initPanel(manager);
        this.treeViewer.setSelection((ISelection)new StructuredSelection((Object)this.proposedDestination));
        this.workspaceFilenameField.setText(this.proposedName);
    }

    @Override
    protected Point getPrefferedSizeImpl() {
        return new Point(640, 300);
    }

    @Override
    protected void createControlsImpl(Composite parent) {
        GridData data = null;
        GridLayout layout = null;
        this.treeViewer = new TreeViewer(parent, 2048);
        data = new GridData(1808);
        this.treeViewer.getTree().setLayoutData((Object)data);
        ContainerContentProvider cp = new ContainerContentProvider();
        cp.showClosedProjects(false);
        this.treeViewer.setContentProvider((IContentProvider)cp);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.treeViewer.setInput((Object)ResourcesPlugin.getWorkspace());
        this.treeViewer.addSelectionChangedListener(event -> this.validateContent());
        AbstractFormattedVerifier verifier = new AbstractFormattedVerifier(SVNUIMessages.SavePatchInWorkspace_WorkspaceTree){

            @Override
            protected String getWarningMessageImpl(Control input) {
                return null;
            }

            @Override
            protected String getErrorMessageImpl(Control input) {
                IStructuredSelection selection = (IStructuredSelection)SavePatchInWorkspacePanel.this.treeViewer.getSelection();
                return selection != null && !selection.isEmpty() ? null : SVNUIMessages.SavePatchInWorkspace_WorkspaceTree_Verifier_Error;
            }
        };
        this.attachTo((Control)this.treeViewer.getTree(), verifier);
        Composite wsComposite = new Composite(parent, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        wsComposite.setLayout((Layout)layout);
        data = new GridData(768);
        wsComposite.setLayoutData((Object)data);
        Label description = new Label(wsComposite, 0);
        data = new GridData();
        description.setLayoutData((Object)data);
        description.setText(SVNUIMessages.SavePatchInWorkspace_FileName);
        this.workspaceFilenameField = new Text(wsComposite, 2052);
        data = new GridData(768);
        this.workspaceFilenameField.setLayoutData((Object)data);
        CompositeVerifier cVerifier = new CompositeVerifier();
        String name = SVNUIMessages.SavePatchInWorkspace_FileName_Verifier;
        cVerifier.add(new NonEmptyFieldVerifier(name));
        cVerifier.add(new ResourceNameVerifier(name, false));
        cVerifier.add(new AbstractFormattedVerifier(name){

            @Override
            protected String getErrorMessageImpl(Control input) {
                return null;
            }

            @Override
            protected String getWarningMessageImpl(Control input) {
                IFile file = SavePatchInWorkspacePanel.this.makeFile();
                if (file != null && file.isAccessible()) {
                    return BaseMessages.format((String)SVNUIMessages.SavePatchInWorkspace_FileName_Verifier_Warning, (Object[])new String[]{"$FIELD_NAME$"});
                }
                return null;
            }
        });
        this.attachTo((Control)this.workspaceFilenameField, cVerifier);
    }

    @Override
    protected void cancelChangesImpl() {
    }

    @Override
    protected void saveChangesImpl() {
        this.file = this.makeFile();
    }

    protected IFile makeFile() {
        String fileName = this.workspaceFilenameField.getText();
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        if (selection != null && !selection.isEmpty()) {
            IContainer treeNode = (IContainer)selection.getFirstElement();
            return treeNode.getProject().getFile(treeNode.getFullPath().append(fileName).removeFirstSegments(1));
        }
        return null;
    }
}

