/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.lock;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.composite.CommentComposite;
import org.eclipse.team.svn.ui.lock.LockResource;
import org.eclipse.team.svn.ui.lock.LockResourceSelectionComposite;
import org.eclipse.team.svn.ui.panel.AbstractDialogPanel;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.verifier.AbstractVerifier;

public class LockResourcesPanel
extends AbstractDialogPanel {
    protected LockResource[] resources;
    protected boolean hasComment;
    protected LockResourceSelectionComposite selectionComposite;
    protected CommentComposite comment;
    protected SashForm sForm;
    protected Button forceButton;
    protected boolean forceLock;

    public LockResourcesPanel(LockResource[] resources, String dialogTitle, String dialogDescription, String defaultMessage) {
        this(resources, false, false, dialogTitle, dialogDescription, defaultMessage);
    }

    public LockResourcesPanel(LockResource[] resources, boolean hasComment, boolean forceLock, String dialogTitle, String dialogDescription, String defaultMessage) {
        super(new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL});
        this.resources = resources;
        this.hasComment = hasComment;
        this.forceLock = forceLock;
        this.dialogTitle = dialogTitle;
        this.dialogDescription = dialogDescription;
        this.defaultMessage = defaultMessage;
    }

    @Override
    public void createControlsImpl(Composite parent) {
        GridLayout layout = null;
        GridData data = null;
        Composite composite = new Composite(parent, 0);
        layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        data = new GridData(1808);
        composite.setLayoutData((Object)data);
        if (this.hasComment) {
            this.sForm = new SashForm(composite, 512);
            layout = new GridLayout();
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.verticalSpacing = 3;
            this.sForm.setLayout((Layout)layout);
            data = new GridData(1808);
            data.heightHint = 400;
            this.sForm.setLayoutData((Object)data);
            Composite commentParent = new Composite((Composite)this.sForm, 0);
            commentParent.setLayoutData((Object)new GridData(1808));
            layout = new GridLayout();
            layout.verticalSpacing = 4;
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            commentParent.setLayout((Layout)layout);
            Group group = new Group(commentParent, 0);
            group.setLayout((Layout)new GridLayout());
            data = new GridData(1808);
            group.setLayoutData((Object)data);
            group.setText(SVNUIMessages.LockPanel_Comment);
            this.comment = new CommentComposite((Composite)group, this);
            data = new GridData(1808);
            this.comment.setLayoutData(data);
            this.forceButton = new Button(commentParent, 32);
            data = new GridData();
            this.forceButton.setLayoutData((Object)data);
            this.forceButton.setText(SVNUIMessages.LockResourcesPanel_StealLocks);
            this.forceButton.setSelection(this.forceLock);
            this.forceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LockResourcesPanel.this.forceLock = LockResourcesPanel.this.forceButton.getSelection();
                }
            });
            Label separator = new Label(commentParent, 258);
            separator.setLayoutData((Object)new GridData(768));
        }
        this.selectionComposite = new LockResourceSelectionComposite((Composite)(this.sForm != null ? this.sForm : composite), 0, true, true);
        data = new GridData(1808);
        this.selectionComposite.setLayoutData(data);
        this.selectionComposite.setInput(this.resources);
        this.selectionComposite.addResourcesSelectionChangedListener(event -> this.validateContent());
        this.attachTo((Control)this.selectionComposite, new AbstractVerifier(){

            @Override
            protected String getErrorMessage(Control input) {
                LockResource[] selection = LockResourcesPanel.this.getSelectedResources();
                if (selection == null || selection.length == 0) {
                    return SVNUIMessages.ResourceSelectionComposite_Verifier_Error;
                }
                return null;
            }

            @Override
            protected String getWarningMessage(Control input) {
                return null;
            }
        });
        if (this.hasComment) {
            IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
            int first = SVNTeamPreferences.getDialogInt(store, "LockResourcesPanel.weight");
            this.sForm.setWeights(new int[]{first, 100 - first});
        }
    }

    public String getMessage() {
        return this.hasComment ? this.comment.getMessage() : null;
    }

    public boolean getForce() {
        return this.hasComment ? this.forceLock : false;
    }

    public LockResource[] getSelectedResources() {
        return this.selectionComposite.getSelectedResources();
    }

    @Override
    protected void saveChangesImpl() {
        if (this.hasComment) {
            this.comment.saveChanges();
            this.savePreferences();
        }
    }

    protected void savePreferences() {
        int[] weights = this.sForm.getWeights();
        IPreferenceStore store = SVNTeamUIPlugin.instance().getPreferenceStore();
        SVNTeamPreferences.setDialogInt(store, "LockResourcesPanel.weight", weights[0] / 10);
    }

    @Override
    protected void cancelChangesImpl() {
        if (this.hasComment) {
            this.comment.cancelChanges();
            this.savePreferences();
        }
    }

    @Override
    public String getHelpId() {
        return "org.eclipse.team.svn.help.lockDialogContext";
    }
}

