/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.history;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.provider.FileRevision;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.actions.CompareRevisionAction;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.connector.SVNEntry;
import org.eclipse.team.svn.core.connector.SVNEntryInfo;
import org.eclipse.team.svn.core.connector.SVNEntryRevisionReference;
import org.eclipse.team.svn.core.connector.SVNLogEntry;
import org.eclipse.team.svn.core.connector.SVNLogPath;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.history.SVNRemoteResourceRevision;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.IResourcePropertyProvider;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.local.FiniExtractLogOperation;
import org.eclipse.team.svn.core.operation.local.GetRemoteContentsOperation;
import org.eclipse.team.svn.core.operation.local.InitExtractLogOperation;
import org.eclipse.team.svn.core.operation.local.RefreshResourcesOperation;
import org.eclipse.team.svn.core.operation.local.RestoreProjectMetaOperation;
import org.eclipse.team.svn.core.operation.local.SaveProjectMetaOperation;
import org.eclipse.team.svn.core.operation.local.UpdateOperation;
import org.eclipse.team.svn.core.operation.remote.ExportOperation;
import org.eclipse.team.svn.core.operation.remote.ExtractToOperationRemote;
import org.eclipse.team.svn.core.operation.remote.GetRemotePropertiesOperation;
import org.eclipse.team.svn.core.operation.remote.LocateResourceURLInHistoryOperation;
import org.eclipse.team.svn.core.operation.remote.PreparedBranchTagOperation;
import org.eclipse.team.svn.core.operation.remote.management.AddRevisionLinkOperation;
import org.eclipse.team.svn.core.operation.remote.management.SaveRepositoryLocationsOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryContainer;
import org.eclipse.team.svn.core.resource.IRepositoryFile;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryResourceProvider;
import org.eclipse.team.svn.core.resource.IRepositoryResourceWithStatusProvider;
import org.eclipse.team.svn.core.resource.IRepositoryRoot;
import org.eclipse.team.svn.core.resource.IRevisionLink;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;
import org.eclipse.team.svn.ui.SVNTeamUIPlugin;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.action.AbstractRepositoryTeamAction;
import org.eclipse.team.svn.ui.action.remote.BranchTagAction;
import org.eclipse.team.svn.ui.action.remote.CreatePatchAction;
import org.eclipse.team.svn.ui.action.remote.OpenFileAction;
import org.eclipse.team.svn.ui.action.remote.OpenFileWithAction;
import org.eclipse.team.svn.ui.action.remote.OpenFileWithExternalAction;
import org.eclipse.team.svn.ui.action.remote.OpenFileWithInplaceAction;
import org.eclipse.team.svn.ui.compare.TwoWayPropertyCompareInput;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.dialog.ReplaceWarningDialog;
import org.eclipse.team.svn.ui.history.FromDifferenceRepositoryResourceProviderOperation;
import org.eclipse.team.svn.ui.history.ISVNHistoryView;
import org.eclipse.team.svn.ui.history.data.AffectedPathsNode;
import org.eclipse.team.svn.ui.history.data.SVNChangedPathData;
import org.eclipse.team.svn.ui.history.data.SVNLocalFileRevision;
import org.eclipse.team.svn.ui.history.model.ILogNode;
import org.eclipse.team.svn.ui.history.model.SVNLogNode;
import org.eclipse.team.svn.ui.operation.CompareRepositoryResourcesOperation;
import org.eclipse.team.svn.ui.operation.CompareResourcesOperation;
import org.eclipse.team.svn.ui.operation.OpenRemoteFileOperation;
import org.eclipse.team.svn.ui.operation.RefreshRemoteResourcesOperation;
import org.eclipse.team.svn.ui.operation.RefreshRepositoryLocationsOperation;
import org.eclipse.team.svn.ui.operation.RemoteShowAnnotationOperation;
import org.eclipse.team.svn.ui.operation.ShowHistoryViewOperation;
import org.eclipse.team.svn.ui.operation.ShowPropertiesOperation;
import org.eclipse.team.svn.ui.operation.ShowRevisionPropertiesOperation;
import org.eclipse.team.svn.ui.operation.UILoggedOperation;
import org.eclipse.team.svn.ui.panel.common.InputRevisionPanel;
import org.eclipse.team.svn.ui.preferences.SVNTeamPreferences;
import org.eclipse.team.svn.ui.repository.model.RepositoryFile;
import org.eclipse.team.svn.ui.repository.model.RepositoryFolder;
import org.eclipse.team.svn.ui.utility.LockProposeUtility;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;
import org.eclipse.team.svn.ui.wizard.CreatePatchWizard;
import org.eclipse.team.ui.history.HistoryPage;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PlatformUI;

public class HistoryActionManager {
    protected ISVNHistoryView view;
    protected long selectedRevision;
    public final IControlActionManager affectedTableManager;
    public final IControlActionManager affectedTreeManager;
    public final IControlActionManager logMessagesManager;

    public HistoryActionManager(ISVNHistoryView info) {
        this.view = info;
        this.affectedTableManager = new AffectedTableActionManager();
        this.affectedTreeManager = new AffectedTreeActionManager();
        this.logMessagesManager = new LogMessagesActionManager();
    }

    public long getSelectedRevision() {
        return this.selectedRevision;
    }

    public void setSelectedRevision(long selectedRevision) {
        this.selectedRevision = selectedRevision;
    }

    protected Action addMenuItem(StructuredViewer viewer, MenuManager menuManager, String label, final AbstractRepositoryTeamAction action) {
        IStructuredSelection tSelection = (IStructuredSelection)viewer.getSelection();
        Action wrapper = new Action(label){

            public void run() {
                action.run((IAction)this);
            }
        };
        StructuredSelection resourceSelection = tSelection.size() == 1 && ((ILogNode)tSelection.getFirstElement()).getType() == 2 ? new StructuredSelection((Object)new RepositoryFile(null, this.getResourceForSelectedRevision((SVNLogEntry)((ILogNode)tSelection.getFirstElement()).getEntity()))) : new StructuredSelection((Object)StructuredSelection.EMPTY);
        action.selectionChanged((IAction)wrapper, (ISelection)resourceSelection);
        menuManager.add((IAction)wrapper);
        return wrapper;
    }

    protected void getRevisionContents(SVNLogEntry item, Shell shell) {
        ILocalResource local;
        IRepositoryResource remote = this.getResourceForSelectedRevision(item);
        boolean canWrite = true;
        if (this.view.getResource() instanceof IFile && !(local = SVNRemoteStorage.instance().asLocalResource(this.view.getResource())).isLocked() && IStateFilter.SF_NEEDS_LOCK.accept(local)) {
            boolean bl = canWrite = LockProposeUtility.proposeLock(new IResource[]{this.view.getResource()}, shell, false).getSeverity() == 0;
        }
        if (canWrite) {
            HashMap<String, String> remote2local = new HashMap<String, String>();
            remote2local.put(SVNUtility.encodeURL((String)remote.getUrl()), FileUtility.getWorkingCopyPath((IResource)this.view.getResource()));
            boolean ignoreExternals = SVNTeamPreferences.getBehaviourBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "externals.ignore");
            GetRemoteContentsOperation mainOp = new GetRemoteContentsOperation(new IResource[]{this.view.getResource()}, new IRepositoryResource[]{remote}, remote2local, ignoreExternals);
            CompositeOperation op = new CompositeOperation(mainOp.getId(), mainOp.getMessagesClass());
            op.add((IActionOperation)mainOp);
            op.add((IActionOperation)new RefreshResourcesOperation(new IResource[]{this.view.getResource()}));
            UIMonitorUtility.doTaskScheduledWorkspaceModify((IActionOperation)op);
        }
    }

    protected void doExport(ILogNode item) {
        if (item.getType() == 3) {
            final SVNLocalFileRevision revision = (SVNLocalFileRevision)((Object)item.getEntity());
            FileDialog dlg = new FileDialog(UIMonitorUtility.getShell(), 40960);
            dlg.setText(SVNUIMessages.ExportPanel_Title);
            dlg.setFileName(revision.getName());
            dlg.setFilterExtensions(new String[]{"*.*"});
            final String file = dlg.open();
            if (file != null) {
                AbstractActionOperation op = new AbstractActionOperation("Operation_ExportLocalHistory", SVNUIMessages.class){

                    protected void runImpl(IProgressMonitor monitor) throws Exception {
                        FileOutputStream output = new FileOutputStream(file);
                        InputStream input = null;
                        try {
                            IStorage storage = revision.getStorage(monitor);
                            input = storage.getContents();
                            byte[] data = new byte[2048];
                            int len = 0;
                            while ((len = input.read(data)) > 0) {
                                output.write(data, 0, len);
                            }
                        }
                        catch (Throwable throwable) {
                            try {
                                output.close();
                            }
                            catch (IOException iOException) {}
                            if (input != null) {
                                try {
                                    input.close();
                                }
                                catch (IOException iOException) {}
                            }
                            throw throwable;
                        }
                        try {
                            output.close();
                        }
                        catch (IOException iOException) {}
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                };
                UIMonitorUtility.doTaskScheduledDefault((IActionOperation)op);
            }
        } else {
            DirectoryDialog fileDialog = new DirectoryDialog(UIMonitorUtility.getShell());
            fileDialog.setText(SVNUIMessages.ExportPanel_ExportFolder);
            fileDialog.setMessage(SVNUIMessages.ExportPanel_ExportFolder_Msg);
            String path = fileDialog.open();
            if (path != null) {
                IRepositoryResource resource = this.traceResourceToRevision((SVNLogEntry)item.getEntity());
                boolean ignoreExternals = SVNTeamPreferences.getBehaviourBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "externals.ignore");
                UIMonitorUtility.doTaskScheduledDefault((IActionOperation)new ExportOperation(new IRepositoryResource[]{resource}, path, SVNDepth.INFINITY, ignoreExternals));
            }
        }
    }

    protected IRepositoryResource traceResourceToRevision(SVNLogEntry to) {
        IRepositoryResource resource = this.getResourceForSelectedRevision(to);
        String rootUrl = resource.getRepositoryLocation().getRepositoryRootUrl();
        String url = this.traceUrlToRevision(rootUrl, resource.getUrl().substring(rootUrl.length()), this.view.getCurrentRevision(), to.revision);
        IRepositoryFile retVal = resource instanceof IRepositoryFile ? resource.asRepositoryFile(url, false) : resource.asRepositoryContainer(url, false);
        return retVal;
    }

    protected void addRevisionLinks(ILogNode[] tSelection) {
        InputRevisionPanel panel = new InputRevisionPanel(null, false, null);
        DefaultDialog dlg = new DefaultDialog(UIMonitorUtility.getShell(), panel);
        if (dlg.open() == 0) {
            String comment = panel.getRevisionComment();
            IRepositoryLocation location = this.view.getRepositoryResource().getRepositoryLocation();
            CompositeOperation op = new CompositeOperation("Operation_HAddSelectedRevision", SVNUIMessages.class);
            ILogNode[] iLogNodeArray = tSelection;
            int n = tSelection.length;
            int n2 = 0;
            while (n2 < n) {
                ILogNode node = iLogNodeArray[n2];
                SVNLogEntry item = (SVNLogEntry)node.getEntity();
                IRepositoryResource resource = SVNUtility.copyOf((IRepositoryResource)this.view.getRepositoryResource());
                resource.setSelectedRevision((SVNRevision)SVNRevision.fromNumber((long)item.revision));
                LocateResourceURLInHistoryOperation locateOp = new LocateResourceURLInHistoryOperation(new IRepositoryResource[]{resource});
                op.add((IActionOperation)locateOp);
                op.add((IActionOperation)new AddRevisionLinkOperation(() -> {
                    IRepositoryResource[] resources = locateOp.getRepositoryResources();
                    IRevisionLink[] links = new IRevisionLink[resources.length];
                    int i = 0;
                    while (i < resources.length) {
                        links[i] = SVNUtility.createRevisionLink((IRepositoryResource)resources[i]);
                        links[i].setComment(comment);
                        ++i;
                    }
                    return links;
                }, item.revision), new IActionOperation[]{locateOp});
                ++n2;
            }
            op.add((IActionOperation)new SaveRepositoryLocationsOperation());
            op.add((IActionOperation)new RefreshRepositoryLocationsOperation(new IRepositoryLocation[]{location}, true));
            UIMonitorUtility.doTaskScheduledDefault((IActionOperation)op);
        }
    }

    protected void updateTo(SVNLogEntry item) {
        IResource[] resources = new IResource[]{this.view.getResource()};
        boolean ignoreExternals = SVNTeamPreferences.getBehaviourBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "externals.ignore");
        CompositeOperation op = new CompositeOperation("Operation_HUpdateTo", SVNUIMessages.class);
        SaveProjectMetaOperation saveOp = new SaveProjectMetaOperation(resources);
        op.add((IActionOperation)saveOp);
        op.add((IActionOperation)new UpdateOperation(resources, (SVNRevision)SVNRevision.fromNumber((long)item.revision), ignoreExternals));
        op.add((IActionOperation)new RestoreProjectMetaOperation(saveOp));
        op.add((IActionOperation)new RefreshResourcesOperation(resources));
        UIMonitorUtility.doTaskScheduledWorkspaceModify((IActionOperation)op);
    }

    protected void createPatch(ILogNode[] selected) {
        CreatePatchWizard wizard = new CreatePatchWizard(this.view.getRepositoryResource().getName());
        WizardDialog dialog = new WizardDialog(UIMonitorUtility.getShell(), (IWizard)wizard);
        if (dialog.open() == 0) {
            SVNLogEntry msg0 = (SVNLogEntry)selected[0].getEntity();
            IRepositoryResource next = this.getResourceForSelectedRevision(msg0);
            IRepositoryResource prev = null;
            if (selected.length == 1) {
                prev = this.getResourceForSelectedRevision(new SVNLogEntry(msg0.revision - 1L, 0L, null, null, null, false));
            } else {
                SVNLogEntry msg1 = (SVNLogEntry)selected[1].getEntity();
                prev = this.getResourceForSelectedRevision(msg1);
                if (msg0.revision < msg1.revision) {
                    IRepositoryResource tmp = next;
                    next = prev;
                    prev = tmp;
                }
            }
            UIMonitorUtility.doTaskScheduledDefault(UIMonitorUtility.getActivePart(), CreatePatchAction.getCreatePatchOperation(prev, next, wizard));
        }
    }

    protected void handleCopy(ILogNode[] selection) {
        String historyText = this.getSelectedMessagesAsString(selection);
        Clipboard clipboard = new Clipboard(UIMonitorUtility.getDisplay());
        try {
            clipboard.setContents(new Object[]{historyText}, new Transfer[]{TextTransfer.getInstance()});
        }
        finally {
            clipboard.dispose();
        }
    }

    public String getSelectedMessagesAsString(ILogNode[] selection) {
        String[] historyText = new String[]{""};
        HashSet<ILogNode> processed = new HashSet<ILogNode>();
        long revision = this.view.getCurrentRevision();
        ILogNode[] iLogNodeArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            ILogNode node = iLogNodeArray[n2];
            this.toString(processed, node, revision, historyText);
            ++n2;
        }
        return historyText[0];
    }

    protected void toString(HashSet<ILogNode> processed, ILogNode node, long revision, String[] retStr) {
        if (processed.contains(node)) {
            return;
        }
        processed.add(node);
        Object toAdd = "";
        toAdd = (String)toAdd + node.getLabel(0, 1, revision);
        int i = 1;
        while (i < 5) {
            toAdd = (String)toAdd + "\t" + node.getLabel(i, 1, revision);
            ++i;
        }
        if (!((String)(toAdd = ((String)toAdd).trim())).equals("")) {
            retStr[0] = String.valueOf(retStr[0]) + (String)toAdd + System.lineSeparator();
        }
        if (node.hasChildren()) {
            ILogNode[] children;
            ILogNode[] iLogNodeArray = children = node.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                ILogNode child = iLogNodeArray[n2];
                this.toString(processed, child, revision, retStr);
                ++n2;
            }
        }
    }

    protected String toString(HashSet<ILogNode> processed, ILogNode node, long revision) {
        if (processed.contains(node)) {
            return "";
        }
        processed.add(node);
        Object historyText = node.getLabel(0, 1, revision);
        int i = 1;
        while (i < 5) {
            historyText = (String)historyText + "\t" + node.getLabel(i, 1, revision);
            ++i;
        }
        return (String)historyText + System.lineSeparator();
    }

    protected void handleDoubleClick(TreeViewer viewer, ILogNode item, boolean doubleClick) {
        boolean isCompareAllowed;
        int type = item.getType();
        if (type == 1) {
            if (viewer.getExpandedState((Object)item)) {
                viewer.collapseToLevel((Object)item, -1);
            } else {
                viewer.expandToLevel((Object)item, -1);
            }
            return;
        }
        boolean bl = isCompareAllowed = CoreExtensionsManager.instance().getSVNConnectorFactory().getSVNAPIVersion() >= 5 || this.view.getRepositoryResource() instanceof IRepositoryFile;
        if ((this.view.getOptions() & 2) != 0 && doubleClick && isCompareAllowed) {
            if (type == 2 && !(item.getParent() instanceof SVNLogNode)) {
                this.compareWithCurrent((SVNLogEntry)item.getEntity());
            } else if (type == 3) {
                this.runCompareForLocal(new Object[]{item});
            }
        } else if (type == 3) {
            try {
                SVNLocalFileRevision selected = (SVNLocalFileRevision)((Object)item.getEntity());
                Utils.openEditor((IWorkbenchPage)UIMonitorUtility.getActivePage(), (IFileRevision)selected, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException ex) {
                UILoggedOperation.reportError("Open Editor", ex);
            }
        } else if (!(this.view.getRepositoryResource() instanceof IRepositoryContainer) && type == 2 && !(item.getParent() instanceof SVNLogNode)) {
            UIMonitorUtility.doTaskScheduledActive((IActionOperation)new OpenRemoteFileOperation(new IRepositoryFile[]{(IRepositoryFile)this.getResourceForSelectedRevision((SVNLogEntry)item.getEntity())}, 0));
        }
    }

    protected void compareWithCurrent(SVNLogEntry item) {
        IRepositoryResource resource = this.getResourceForSelectedRevision(item);
        if (this.view.getResource() != null || this.view.getCompareWith() != null) {
            ILocalResource local = SVNRemoteStorage.instance().asLocalResource(this.view.getCompareWith());
            CompareResourcesOperation op = new CompareResourcesOperation(local, resource);
            op.setForceId(this.getCompareForceId());
            UIMonitorUtility.doTaskScheduledActive((IActionOperation)op);
        } else {
            CompareRepositoryResourcesOperation op = new CompareRepositoryResourcesOperation(this.getResourceForHeadRevision(), resource);
            op.setForceId(this.getCompareForceId());
            UIMonitorUtility.doTaskScheduledActive((IActionOperation)op);
        }
    }

    protected void runExtractTo(ILogNode[] selection) {
        IRepositoryResource remote;
        String path = null;
        DirectoryDialog fileDialog = new DirectoryDialog(UIMonitorUtility.getShell());
        fileDialog.setText(SVNUIMessages.ExtractToAction_Select_Title);
        fileDialog.setMessage(SVNUIMessages.ExtractToAction_Select_Description);
        path = fileDialog.open();
        if (path == null) {
            return;
        }
        SVNLogEntry[] selectedLogs = new SVNLogEntry[2];
        selectedLogs[0] = (SVNLogEntry)selection[0].getEntity();
        if (selection.length == 2) {
            selectedLogs[1] = (SVNLogEntry)selection[1].getEntity();
            if (selectedLogs[0].revision < selectedLogs[1].revision) {
                SVNLogEntry tmp = selectedLogs[0];
                selectedLogs[0] = selectedLogs[1];
                selectedLogs[1] = tmp;
            }
        } else {
            selectedLogs[1] = new SVNLogEntry(selectedLogs[0].revision - 1L, 0L, null, null, null, false);
        }
        HashMap<String, String> resource2project = new HashMap<String, String>();
        IResource local = this.view.getResource();
        if (local != null) {
            remote = SVNRemoteStorage.instance().asRepositoryResource((IResource)local.getProject());
            resource2project.put(remote.getUrl(), local.getProject().getName());
        } else {
            remote = this.view.getRepositoryResource();
            resource2project.put(remote.getUrl(), remote.getName());
        }
        CompositeOperation op = new CompositeOperation(SVNMessages.Operation_ExtractTo, SVNMessages.class);
        InitExtractLogOperation logger = new InitExtractLogOperation(path);
        FromDifferenceRepositoryResourceProviderOperation provider = new FromDifferenceRepositoryResourceProviderOperation(this.getResourceForSelectedRevision(selectedLogs[0]), this.getResourceForSelectedRevision(selectedLogs[1]));
        op.add((IActionOperation)provider);
        op.add((IActionOperation)logger);
        op.add((IActionOperation)new ExtractToOperationRemote((IRepositoryResourceWithStatusProvider)provider, provider.getDeletionsProvider(), path, resource2project, logger, true), new IActionOperation[]{provider});
        op.add((IActionOperation)new FiniExtractLogOperation(logger));
        UIMonitorUtility.doTaskScheduledActive((IActionOperation)op);
    }

    protected void runCompareForLocal(Object[] selection) {
        ArrayList<SVNLocalFileRevision> newSelection = new ArrayList<SVNLocalFileRevision>();
        Object[] objectArray = selection;
        int n = selection.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            if (item instanceof ILogNode) {
                newSelection.add((SVNLocalFileRevision)((Object)((ILogNode)item).getEntity()));
            } else {
                newSelection.add((SVNLocalFileRevision)((FileRevision)item));
            }
            ++n2;
        }
        CompareRevisionAction compare = null;
        try {
            compare = (CompareRevisionAction)CompareRevisionAction.class.getConstructor(null).newInstance(null);
            compare.getClass().getMethod("setPage", HistoryPage.class).invoke((Object)compare, this.view.getHistoryPage());
        }
        catch (Exception exception) {
            try {
                compare = (CompareRevisionAction)CompareRevisionAction.class.getConstructor(String.class, HistoryPage.class).newInstance("", this.view.getHistoryPage());
            }
            catch (RuntimeException ex1) {
                throw ex1;
            }
            catch (Exception ex1) {
                throw new RuntimeException(ex1);
            }
        }
        compare.selectionChanged((IStructuredSelection)new StructuredSelection(newSelection));
        compare.setCurrentFileRevision((IFileRevision)new SVNLocalFileRevision((IFile)this.view.getResource()));
        compare.run();
    }

    protected IRepositoryResource getResourceForHeadRevision() {
        IRepositoryFile res = this.view.getRepositoryResource() instanceof IRepositoryFile ? ((IRepositoryRoot)this.view.getRepositoryResource().getRoot()).asRepositoryFile(this.view.getRepositoryResource().getUrl(), false) : ((IRepositoryRoot)this.view.getRepositoryResource().getRoot()).asRepositoryContainer(this.view.getRepositoryResource().getUrl(), false);
        res.setSelectedRevision(SVNRevision.HEAD);
        res.setPegRevision(SVNRevision.HEAD);
        return res;
    }

    protected String getCompareForceId() {
        return this.toString();
    }

    protected IRepositoryResource getResourceForSelectedRevision(SVNLogEntry item) {
        long revNum = item.revision;
        IRepositoryResource res = SVNUtility.copyOf((IRepositoryResource)this.view.getRepositoryResource());
        res.setSelectedRevision((SVNRevision)SVNRevision.fromNumber((long)revNum));
        res.setPegRevision(this.view.getRepositoryResource().getPegRevision());
        return res;
    }

    protected boolean confirmReplacement() {
        ReplaceWarningDialog dialog = new ReplaceWarningDialog(UIMonitorUtility.getShell());
        return dialog.open() == 0;
    }

    protected boolean checkSelectionForExistanceInPrev(IStructuredSelection selection) {
        for (Object next : selection) {
            if (!(next instanceof SVNChangedPathData)) continue;
            SVNChangedPathData current = (SVNChangedPathData)next;
            if (current.action == SVNLogPath.ChangeType.MODIFIED || current.action == SVNLogPath.ChangeType.REPLACED || current.copiedFromPath != null && !current.copiedFromPath.equals("")) continue;
            return false;
        }
        return true;
    }

    protected void createPatchToPrevious(Shell shell, IActionOperation preOp, IRepositoryResourceProvider provider) {
        if (UIMonitorUtility.doTaskNowDefault(shell, preOp, true).isCancelled()) {
            return;
        }
        IRepositoryResource current = provider.getRepositoryResources()[0];
        CreatePatchWizard wizard = new CreatePatchWizard(current.getName());
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        if (dialog.open() == 0) {
            IRepositoryContainer previous = current instanceof RepositoryFolder ? current.asRepositoryContainer(current.getUrl(), false) : current.asRepositoryFile(current.getUrl(), false);
            previous.setSelectedRevision((SVNRevision)SVNRevision.fromNumber((long)(this.selectedRevision - 1L)));
            previous.setPegRevision((SVNRevision)SVNRevision.fromNumber((long)this.selectedRevision));
            UIMonitorUtility.doTaskScheduledDefault(CreatePatchAction.getCreatePatchOperation((IRepositoryResource)previous, current, wizard));
        }
    }

    protected void createBranchTag(Shell shell, IActionOperation preOp, IRepositoryResourceProvider provider, int type) {
        if (UIMonitorUtility.doTaskNowDefault(shell, preOp, true).isCancelled()) {
            return;
        }
        IRepositoryResource[] resources = provider.getRepositoryResources();
        PreparedBranchTagOperation op = BranchTagAction.getBranchTagOperation(resources, shell, type);
        if (op != null) {
            CompositeOperation composite = new CompositeOperation(op.getId(), op.getMessagesClass());
            composite.add((IActionOperation)op);
            RefreshRemoteResourcesOperation refreshOp = new RefreshRemoteResourcesOperation(new IRepositoryResource[]{op.getDestination().getParent()});
            composite.add((IActionOperation)refreshOp, new IActionOperation[]{op});
            UIMonitorUtility.doTaskScheduledDefault((IActionOperation)op);
        }
    }

    protected void doExport(Shell shell, IActionOperation preOp, IRepositoryResourceProvider provider) {
        DirectoryDialog fileDialog = new DirectoryDialog(shell);
        fileDialog.setText(SVNUIMessages.ExportPanel_ExportFolder);
        fileDialog.setMessage(SVNUIMessages.ExportPanel_ExportFolder_Msg);
        String path = fileDialog.open();
        if (path != null) {
            boolean ignoreExternals = SVNTeamPreferences.getBehaviourBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "externals.ignore");
            ExportOperation mainOp = new ExportOperation(provider, path, SVNDepth.INFINITY, ignoreExternals);
            CompositeOperation op = new CompositeOperation(mainOp.getId(), mainOp.getMessagesClass());
            op.add(preOp);
            op.add((IActionOperation)mainOp, new IActionOperation[]{preOp});
            UIMonitorUtility.doTaskScheduledDefault((IActionOperation)op);
        }
    }

    protected void openRemoteResource(SVNChangedPathData selectedPath, int openType, String openWith) {
        FromChangedPathDataProvider provider = new FromChangedPathDataProvider(selectedPath, true);
        OpenRemoteFileOperation openOp = new OpenRemoteFileOperation(provider, openType, openWith);
        CompositeOperation composite = new CompositeOperation(openOp.getId(), openOp.getMessagesClass(), true);
        composite.add((IActionOperation)provider);
        composite.add((IActionOperation)openOp, new IActionOperation[]{provider});
        UIMonitorUtility.doTaskScheduledActive((IActionOperation)composite);
    }

    protected void showAnnotation(SVNChangedPathData selectedPath) {
        FromChangedPathDataProvider provider = new FromChangedPathDataProvider(selectedPath, true);
        RemoteShowAnnotationOperation mainOp = new RemoteShowAnnotationOperation(provider);
        CompositeOperation op = new CompositeOperation(mainOp.getId(), mainOp.getMessagesClass(), true);
        op.add((IActionOperation)provider);
        op.add((IActionOperation)mainOp, new IActionOperation[]{provider});
        UIMonitorUtility.doTaskScheduledActive((IActionOperation)op);
    }

    protected void showHistory(IActionOperation preOp, IRepositoryResourceProvider provider) {
        ShowHistoryViewOperation mainOp = new ShowHistoryViewOperation(provider, 0, 0);
        CompositeOperation op = new CompositeOperation(mainOp.getId(), mainOp.getMessagesClass());
        op.add(preOp);
        op.add((IActionOperation)mainOp, new IActionOperation[]{preOp});
        UIMonitorUtility.doTaskScheduledActive((IActionOperation)op);
    }

    protected void showProperties(IActionOperation preOp, IRepositoryResourceProvider provider) {
        GetRemotePropertiesOperation propertyProvider = new GetRemotePropertiesOperation(provider);
        ShowPropertiesOperation mainOp = new ShowPropertiesOperation(UIMonitorUtility.getActivePage(), provider, (IResourcePropertyProvider)propertyProvider);
        CompositeOperation op = new CompositeOperation(mainOp.getId(), mainOp.getMessagesClass());
        op.add(preOp);
        op.add((IActionOperation)mainOp, new IActionOperation[]{preOp});
        UIMonitorUtility.doTaskScheduledActive((IActionOperation)op);
    }

    protected void getContentAffected(IActionOperation preOp, IRepositoryResourceProvider provider, String remotePath) {
        IContainer resourceToLock;
        IContainer viewedResource;
        String rootUrl = SVNRemoteStorage.instance().asRepositoryResource(this.view.getResource()).getRepositoryLocation().getRepositoryRootUrl();
        String remoteViewedResourceUrl = SVNRemoteStorage.instance().asRepositoryResource(this.view.getResource()).getUrl();
        String remoteFoundPath = this.traceUrlToRevision(rootUrl, remotePath, this.view.getCurrentRevision(), this.selectedRevision);
        if (!remoteFoundPath.startsWith(remoteViewedResourceUrl)) {
            MessageDialog dialog = new MessageDialog(UIMonitorUtility.getShell(), SVNUIMessages.AffectedPathsActions_CantGetContent_Title, null, SVNUIMessages.AffectedPathsActions_CantGetContent_Message, 2, new String[]{IDialogConstants.OK_LABEL}, 0);
            dialog.open();
            return;
        }
        if (!this.confirmReplacement()) {
            return;
        }
        Path resourcePath = new Path(remoteFoundPath.substring(remoteViewedResourceUrl.length()));
        HashMap<String, String> remote2local = new HashMap<String, String>();
        if (this.view.getResource() instanceof IContainer) {
            viewedResource = (IContainer)this.view.getResource();
            remote2local.put(SVNUtility.encodeURL((String)(rootUrl + remotePath)), FileUtility.getWorkingCopyPath((IResource)viewedResource).concat(resourcePath.toString()));
            resourceToLock = viewedResource.findMember((IPath)resourcePath);
            while (resourceToLock == null) {
                resourcePath = resourcePath.removeLastSegments(1);
                resourceToLock = viewedResource.findMember((IPath)resourcePath);
            }
        } else {
            viewedResource = (IFile)this.view.getResource();
            remote2local.put(SVNUtility.encodeURL((String)(rootUrl + remotePath)), FileUtility.getWorkingCopyPath((IResource)viewedResource).concat(resourcePath.toString()));
            resourceToLock = viewedResource.getParent();
        }
        boolean ignoreExternals = SVNTeamPreferences.getBehaviourBoolean(SVNTeamUIPlugin.instance().getPreferenceStore(), "externals.ignore");
        GetRemoteContentsOperation mainOp = new GetRemoteContentsOperation(new IResource[]{resourceToLock}, provider, remote2local, ignoreExternals);
        CompositeOperation op = new CompositeOperation(mainOp.getId(), mainOp.getMessagesClass());
        op.add(preOp);
        op.add((IActionOperation)mainOp, new IActionOperation[]{preOp});
        op.add((IActionOperation)new RefreshResourcesOperation(new IResource[]{resourceToLock}));
        UIMonitorUtility.doTaskScheduledActive((IActionOperation)op);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String traceUrlToRevision(String rootUrl, String resourcePath, long currentRevision, long selectedRevision) {
        String url = rootUrl + resourcePath;
        SVNLogEntry[] entries = this.view.getFullRemoteHistory();
        if (currentRevision == selectedRevision || entries[entries.length - 1].revision > currentRevision) {
            return url;
        }
        if (currentRevision > selectedRevision) {
            int i = entries.length - 1;
            while (i > -1) {
                SVNLogEntry entry = entries[i];
                if (entry.revision >= selectedRevision) {
                    if (entry.revision > currentRevision) return url;
                    if (entry.changedPaths == null) {
                        return url;
                    }
                    SVNLogPath[] sVNLogPathArray = entry.changedPaths;
                    int n = entry.changedPaths.length;
                    int n2 = 0;
                    while (n2 < n) {
                        SVNLogPath path = sVNLogPathArray[n2];
                        if (path.copiedFromPath != null && url.endsWith(path.copiedFromPath)) {
                            url = rootUrl + path.path;
                            break;
                        }
                        ++n2;
                    }
                }
                --i;
            }
            return url;
        } else {
            SVNLogEntry[] sVNLogEntryArray = entries;
            int n = entries.length;
            int n3 = 0;
            while (n3 < n) {
                SVNLogEntry entry = sVNLogEntryArray[n3];
                if (entry.revision <= selectedRevision) {
                    if (entry.revision < currentRevision) return url;
                    if (entry.changedPaths == null) {
                        return url;
                    }
                    SVNLogPath[] sVNLogPathArray = entry.changedPaths;
                    int n4 = entry.changedPaths.length;
                    int n5 = 0;
                    while (n5 < n4) {
                        SVNLogPath path = sVNLogPathArray[n5];
                        if (path.copiedFromPath != null && url.endsWith(path.path)) {
                            url = rootUrl + path.copiedFromPath;
                            break;
                        }
                        ++n5;
                    }
                }
                ++n3;
            }
        }
        return url;
    }

    protected void addRevisionLink(IActionOperation preOp, IRepositoryResourceProvider provider) {
        CompositeOperation op = new CompositeOperation("Operation_HAddSelectedRevision", SVNUIMessages.class);
        op.add(preOp);
        IActionOperation[] condition = new IActionOperation[]{preOp};
        op.add((IActionOperation)new AddRevisionLinkOperation(() -> {
            IRepositoryResource[] resources = provider.getRepositoryResources();
            int[] dlgRes = new int[1];
            InputRevisionPanel panel = new InputRevisionPanel(null, false, null);
            UIMonitorUtility.getDisplay().syncExec(() -> {
                DefaultDialog dialog = new DefaultDialog(UIMonitorUtility.getShell(), panel);
                nArray[0] = dialog.open();
            });
            String comment = null;
            if (dlgRes[0] != 0) {
                return new IRevisionLink[0];
            }
            comment = panel.getRevisionComment();
            IRevisionLink[] links = new IRevisionLink[resources.length];
            int i = 0;
            while (i < resources.length) {
                links[i] = SVNUtility.createRevisionLink((IRepositoryResource)resources[i]);
                links[i].setComment(comment);
                ++i;
            }
            return links;
        }, this.selectedRevision), condition);
        op.add((IActionOperation)new SaveRepositoryLocationsOperation(), condition);
        op.add((IActionOperation)new RefreshRepositoryLocationsOperation(new IRepositoryLocation[]{this.view.getRepositoryResource().getRepositoryLocation()}, true), condition);
        UIMonitorUtility.doTaskScheduledDefault((IActionOperation)op);
    }

    protected void compareWithPreviousRevision(IActionOperation preOp, IRepositoryResourceProvider provider) {
        CompareRepositoryResourcesOperation mainOp = new CompareRepositoryResourcesOperation(() -> {
            IRepositoryResource next = provider.getRepositoryResources()[0];
            IRepositoryResource prev = SVNUtility.copyOf((IRepositoryResource)next);
            prev.setSelectedRevision((SVNRevision)SVNRevision.fromNumber((long)(((SVNRevision.Number)next.getSelectedRevision()).getNumber() - 1L)));
            return new IRepositoryResource[]{prev, next};
        });
        mainOp.setForceId(this.getCompareForceId());
        if (preOp != null) {
            CompositeOperation op = new CompositeOperation(mainOp.getId(), mainOp.getMessagesClass());
            op.add(preOp);
            op.add((IActionOperation)mainOp, new IActionOperation[]{preOp});
            UIMonitorUtility.doTaskScheduledActive((IActionOperation)op);
        } else {
            UIMonitorUtility.doTaskScheduledActive((IActionOperation)mainOp);
        }
    }

    protected class AffectedTableActionManager
    implements IControlActionManager {
        protected AffectedTableActionManager() {
        }

        @Override
        public void installKeyBindings(StructuredViewer viewer) {
        }

        @Override
        public void installDefaultAction(StructuredViewer viewer) {
            viewer.addDoubleClickListener(e -> {
                IStructuredSelection selection;
                if (e.getSelection() instanceof IStructuredSelection && (selection = (IStructuredSelection)e.getSelection()).size() == 1) {
                    SVNChangedPathData data = (SVNChangedPathData)selection.getFirstElement();
                    if ((HistoryActionManager.this.view.getOptions() & 2) != 0) {
                        boolean isPreviousExists;
                        boolean bl = isPreviousExists = data.action == SVNLogPath.ChangeType.MODIFIED || data.action == SVNLogPath.ChangeType.REPLACED || data.copiedFromPath != null && !data.copiedFromPath.equals("");
                        if (isPreviousExists) {
                            FromChangedPathDataProvider provider = new FromChangedPathDataProvider(data, false);
                            HistoryActionManager.this.compareWithPreviousRevision((IActionOperation)provider, provider);
                        } else {
                            MessageDialog dialog = new MessageDialog(e.getViewer().getControl().getShell(), SVNUIMessages.AffectedPathsComposite_NoPreviousRevision_Title, null, SVNUIMessages.AffectedPathsComposite_NoPreviousRevision_Message, 2, new String[]{IDialogConstants.OK_LABEL}, 0);
                            dialog.open();
                        }
                    } else {
                        HistoryActionManager.this.openRemoteResource(data, 0, null);
                    }
                }
            });
        }

        @Override
        public void installMenuActions(final StructuredViewer viewer, IWorkbenchPartSite site) {
            MenuManager menuMgr = new MenuManager();
            Menu menu = menuMgr.createContextMenu(viewer.getControl());
            menuMgr.addMenuListener(manager -> {
                IEditorDescriptor[] editors;
                manager.add((IContributionItem)new Separator("additions"));
                IStructuredSelection affectedTableSelection = (IStructuredSelection)viewer.getSelection();
                if (affectedTableSelection.size() == 0) {
                    return;
                }
                final SVNChangedPathData firstData = (SVNChangedPathData)affectedTableSelection.getFirstElement();
                HistoryAction tAction = null;
                IEditorRegistry editorRegistry = SVNTeamUIPlugin.instance().getWorkbench().getEditorRegistry();
                tAction = new HistoryAction(SVNUIMessages.HistoryView_Open){

                    public void run() {
                        HistoryActionManager.this.openRemoteResource(firstData, 0, null);
                    }
                };
                manager.add((IAction)tAction);
                String name = firstData.resourceName;
                tAction.setImageDescriptor(editorRegistry.getImageDescriptor(name));
                tAction.setEnabled(affectedTableSelection.size() == 1);
                MenuManager sub = new MenuManager(SVNUIMessages.HistoryView_OpenWith, "historyOpenWithMenu");
                sub.add((IContributionItem)new Separator("additions"));
                sub.add((IContributionItem)new Separator("nonDefaultTextEditors"));
                IEditorDescriptor[] iEditorDescriptorArray = editors = editorRegistry.getEditors(name);
                int n = editors.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorDescriptor editor = iEditorDescriptorArray[n2];
                    final String id = editor.getId();
                    if (!id.equals("org.eclipse.ui.DefaultTextEditor")) {
                        tAction = new HistoryAction(SVNUIMessages.getString(editor.getLabel())){

                            public void run() {
                                HistoryActionManager.this.openRemoteResource(firstData, 3, id);
                            }
                        };
                        sub.add((IAction)tAction);
                        tAction.setImageDescriptor(editor.getImageDescriptor());
                        tAction.setEnabled(affectedTableSelection.size() == 1);
                    }
                    ++n2;
                }
                sub.add((IContributionItem)new Separator("variousEditors"));
                IEditorDescriptor descriptor = null;
                tAction = new HistoryAction(SVNUIMessages.HistoryView_TextEditor){

                    public void run() {
                        HistoryActionManager.this.openRemoteResource(firstData, 3, "org.eclipse.ui.DefaultTextEditor");
                    }
                };
                sub.add((IAction)tAction);
                descriptor = editorRegistry.findEditor("org.eclipse.ui.DefaultTextEditor");
                tAction.setImageDescriptor(descriptor.getImageDescriptor());
                tAction.setEnabled(affectedTableSelection.size() == 1);
                tAction = new HistoryAction(SVNUIMessages.HistoryView_SystemEditor){

                    public void run() {
                        HistoryActionManager.this.openRemoteResource(firstData, 1, null);
                    }
                };
                sub.add((IAction)tAction);
                if (editorRegistry.isSystemExternalEditorAvailable(name)) {
                    tAction.setImageDescriptor(editorRegistry.getSystemExternalEditorImageDescriptor(name));
                    tAction.setEnabled(affectedTableSelection.size() == 1);
                } else {
                    tAction.setEnabled(false);
                }
                tAction = new HistoryAction(SVNUIMessages.HistoryView_InplaceEditor){

                    public void run() {
                        HistoryActionManager.this.openRemoteResource(firstData, 2, null);
                    }
                };
                sub.add((IAction)tAction);
                if (editorRegistry.isSystemInPlaceEditorAvailable(name)) {
                    tAction.setImageDescriptor(editorRegistry.getSystemExternalEditorImageDescriptor(name));
                    tAction.setEnabled(affectedTableSelection.size() == 1);
                } else {
                    tAction.setEnabled(false);
                }
                tAction = new HistoryAction(SVNUIMessages.HistoryView_DefaultEditor){

                    public void run() {
                        HistoryActionManager.this.openRemoteResource(firstData, 0, null);
                    }
                };
                sub.add((IAction)tAction);
                tAction.setImageDescriptor(editorRegistry.getImageDescriptor(name));
                tAction.setEnabled(affectedTableSelection.size() == 1);
                manager.add((IContributionItem)sub);
                manager.add((IContributionItem)new Separator());
                boolean isPreviousExists = false;
                if (affectedTableSelection.size() > 0) {
                    isPreviousExists = HistoryActionManager.this.checkSelectionForExistanceInPrev(affectedTableSelection);
                }
                tAction = new HistoryAction(SVNUIMessages.HistoryView_CompareWithPrevious){

                    public void run() {
                        FromChangedPathDataProvider provider = new FromChangedPathDataProvider(firstData, false);
                        HistoryActionManager.this.compareWithPreviousRevision((IActionOperation)provider, provider);
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(isPreviousExists);
                manager.add((IContributionItem)new Separator());
                tAction = new HistoryAction(SVNUIMessages.ShowPropertiesAction_label, "icons/views/propertiesedit.gif"){

                    public void run() {
                        FromChangedPathDataProvider provider = new FromChangedPathDataProvider(firstData, false);
                        HistoryActionManager.this.showProperties((IActionOperation)provider, provider);
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(affectedTableSelection.size() == 1);
                tAction = new HistoryAction(SVNUIMessages.ShowResourceHistoryCommand_label, "icons/views/history.gif"){

                    public void run() {
                        FromChangedPathDataProvider provider = new FromChangedPathDataProvider(firstData, false);
                        HistoryActionManager.this.showHistory((IActionOperation)provider, provider);
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(affectedTableSelection.size() == 1);
                tAction = new HistoryAction(SVNUIMessages.ShowAnnotationCommand_label){

                    public void run() {
                        HistoryActionManager.this.showAnnotation(firstData);
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(affectedTableSelection.size() == 1);
                manager.add((IContributionItem)new Separator());
                tAction = new HistoryAction(SVNUIMessages.ExportCommand_label, "icons/common/export.gif"){

                    public void run() {
                        FromChangedPathDataProvider provider = new FromChangedPathDataProvider(firstData, false);
                        HistoryActionManager.this.doExport(viewer.getControl().getShell(), (IActionOperation)provider, provider);
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(affectedTableSelection.size() > 0 && firstData.action != SVNLogPath.ChangeType.DELETED);
                tAction = new HistoryAction(SVNUIMessages.CreatePatchCommand_label){

                    public void run() {
                        FromChangedPathDataProvider provider = new FromChangedPathDataProvider(firstData, false);
                        HistoryActionManager.this.createPatchToPrevious(viewer.getControl().getShell(), (IActionOperation)provider, provider);
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(isPreviousExists);
                if (HistoryActionManager.this.view.getResource() != null) {
                    tAction = new HistoryAction(SVNUIMessages.HistoryView_GetContents){

                        public void run() {
                            FromChangedPathDataProvider provider = new FromChangedPathDataProvider(firstData, false);
                            HistoryActionManager.this.getContentAffected((IActionOperation)provider, provider, "/" + firstData.getFullResourcePath());
                        }
                    };
                    manager.add((IAction)tAction);
                    tAction.setEnabled(affectedTableSelection.size() > 0 && firstData.action != SVNLogPath.ChangeType.DELETED);
                }
                manager.add((IContributionItem)new Separator());
                String branchFrom = BaseMessages.format((String)SVNUIMessages.HistoryView_BranchFrom, (Object[])new String[]{String.valueOf(HistoryActionManager.this.selectedRevision)});
                String tagFrom = BaseMessages.format((String)SVNUIMessages.HistoryView_TagFrom, (Object[])new String[]{String.valueOf(HistoryActionManager.this.selectedRevision)});
                tAction = new HistoryAction(branchFrom, "icons/common/actions/branch.gif"){

                    public void run() {
                        FromChangedPathDataProvider provider = new FromChangedPathDataProvider(firstData, false);
                        HistoryActionManager.this.createBranchTag(viewer.getControl().getShell(), (IActionOperation)provider, provider, 0);
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(affectedTableSelection.size() > 0 && firstData.action != SVNLogPath.ChangeType.DELETED);
                tAction = new HistoryAction(tagFrom, "icons/common/actions/tag.gif"){

                    public void run() {
                        FromChangedPathDataProvider provider = new FromChangedPathDataProvider(firstData, false);
                        HistoryActionManager.this.createBranchTag(viewer.getControl().getShell(), (IActionOperation)provider, provider, 1);
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(affectedTableSelection.size() > 0 && firstData.action != SVNLogPath.ChangeType.DELETED);
                tAction = new HistoryAction(SVNUIMessages.AddRevisionLinkAction_label){

                    public void run() {
                        FromChangedPathDataProvider provider = new FromChangedPathDataProvider(firstData, false);
                        HistoryActionManager.this.addRevisionLink((IActionOperation)provider, provider);
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(affectedTableSelection.size() > 0 && firstData.action != SVNLogPath.ChangeType.DELETED);
            });
            menuMgr.setRemoveAllWhenShown(true);
            viewer.getControl().setMenu(menu);
            site.registerContextMenu(menuMgr, (ISelectionProvider)viewer);
        }
    }

    protected class AffectedTreeActionManager
    implements IControlActionManager {
        protected AffectedTreeActionManager() {
        }

        @Override
        public void installKeyBindings(StructuredViewer viewer) {
        }

        @Override
        public void installDefaultAction(StructuredViewer viewer) {
        }

        @Override
        public void installMenuActions(final StructuredViewer viewer, IWorkbenchPartSite site) {
            MenuManager menuMgr = new MenuManager();
            Menu menu = menuMgr.createContextMenu(viewer.getControl());
            menuMgr.addMenuListener(manager -> {
                manager.add((IContributionItem)new Separator("additions"));
                IStructuredSelection affectedTableSelection = (IStructuredSelection)viewer.getSelection();
                if (affectedTableSelection.size() == 0) {
                    return;
                }
                final AffectedPathsNode node = (AffectedPathsNode)affectedTableSelection.getFirstElement();
                HistoryAction tAction = null;
                tAction = new HistoryAction(SVNUIMessages.HistoryView_CompareWithPrevious){

                    public void run() {
                        FromAffectedPathsNodeProvider provider = new FromAffectedPathsNodeProvider(node);
                        HistoryActionManager.this.compareWithPreviousRevision((IActionOperation)provider, provider);
                    }
                };
                manager.add((IAction)tAction);
                boolean isCompareFoldersAllowed = CoreExtensionsManager.instance().getSVNConnectorFactory().getSVNAPIVersion() >= 5;
                tAction.setEnabled(isCompareFoldersAllowed && HistoryActionManager.this.selectedRevision != 0L && affectedTableSelection.size() == 1 && (node.getStatus() == null || node.getStatus() == SVNLogPath.ChangeType.MODIFIED || node.getStatus() == SVNLogPath.ChangeType.REPLACED));
                manager.add((IContributionItem)new Separator());
                tAction = new HistoryAction(SVNUIMessages.ShowPropertiesAction_label, "icons/views/propertiesedit.gif"){

                    public void run() {
                        FromAffectedPathsNodeProvider provider = new FromAffectedPathsNodeProvider(node);
                        HistoryActionManager.this.showProperties((IActionOperation)provider, provider);
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(HistoryActionManager.this.selectedRevision != 0L && affectedTableSelection.size() == 1);
                tAction = new HistoryAction(SVNUIMessages.ShowResourceHistoryCommand_label, "icons/views/history.gif"){

                    public void run() {
                        FromAffectedPathsNodeProvider provider = new FromAffectedPathsNodeProvider(node);
                        HistoryActionManager.this.showHistory((IActionOperation)provider, provider);
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(HistoryActionManager.this.selectedRevision != 0L && affectedTableSelection.size() == 1);
                manager.add((IContributionItem)new Separator());
                tAction = new HistoryAction(SVNUIMessages.ExportCommand_label, "icons/common/export.gif"){

                    public void run() {
                        FromAffectedPathsNodeProvider provider = new FromAffectedPathsNodeProvider(node);
                        HistoryActionManager.this.doExport(viewer.getControl().getShell(), (IActionOperation)provider, provider);
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(affectedTableSelection.size() > 0 && node.getStatus() != SVNLogPath.ChangeType.DELETED);
                tAction = new HistoryAction(SVNUIMessages.CreatePatchCommand_label){

                    public void run() {
                        FromAffectedPathsNodeProvider provider = new FromAffectedPathsNodeProvider(node);
                        HistoryActionManager.this.createPatchToPrevious(viewer.getControl().getShell(), (IActionOperation)provider, provider);
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(affectedTableSelection.size() == 1 && HistoryActionManager.this.selectedRevision != 0L && affectedTableSelection.size() == 1 && (node.getStatus() == null || node.getStatus() == SVNLogPath.ChangeType.MODIFIED));
                if (HistoryActionManager.this.view.getResource() != null) {
                    tAction = new HistoryAction(SVNUIMessages.HistoryView_GetContents){

                        public void run() {
                            FromAffectedPathsNodeProvider provider = new FromAffectedPathsNodeProvider(node);
                            HistoryActionManager.this.getContentAffected((IActionOperation)provider, provider, node.getFullPath());
                        }
                    };
                    manager.add((IAction)tAction);
                    tAction.setEnabled(affectedTableSelection.size() > 0 && node.getStatus() != SVNLogPath.ChangeType.DELETED);
                }
                manager.add((IContributionItem)new Separator());
                tAction = new HistoryAction(SVNUIMessages.HistoryView_BranchFrom, new String[]{String.valueOf(HistoryActionManager.this.selectedRevision)}, "icons/common/actions/branch.gif"){

                    public void run() {
                        FromAffectedPathsNodeProvider provider = new FromAffectedPathsNodeProvider(node);
                        HistoryActionManager.this.createBranchTag(viewer.getControl().getShell(), (IActionOperation)provider, provider, 0);
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(affectedTableSelection.size() > 0 && node.getStatus() != SVNLogPath.ChangeType.DELETED);
                tAction = new HistoryAction(SVNUIMessages.HistoryView_TagFrom, new String[]{String.valueOf(HistoryActionManager.this.selectedRevision)}, "icons/common/actions/tag.gif"){

                    public void run() {
                        FromAffectedPathsNodeProvider provider = new FromAffectedPathsNodeProvider(node);
                        HistoryActionManager.this.createBranchTag(viewer.getControl().getShell(), (IActionOperation)provider, provider, 1);
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(affectedTableSelection.size() > 0 && node.getStatus() != SVNLogPath.ChangeType.DELETED);
                tAction = new HistoryAction(SVNUIMessages.AddRevisionLinkAction_label){

                    public void run() {
                        FromAffectedPathsNodeProvider provider = new FromAffectedPathsNodeProvider(node);
                        HistoryActionManager.this.addRevisionLink((IActionOperation)provider, provider);
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(affectedTableSelection.size() > 0 && node.getStatus() != SVNLogPath.ChangeType.DELETED);
            });
            menuMgr.setRemoveAllWhenShown(true);
            viewer.getControl().setMenu(menu);
            site.registerContextMenu(menuMgr, (ISelectionProvider)viewer);
        }
    }

    protected class FromAffectedPathsNodeProvider
    extends AbstractActionOperation
    implements IRepositoryResourceProvider {
        protected AffectedPathsNode affectedPathsItem;
        protected IRepositoryResource returnResource;

        public FromAffectedPathsNodeProvider(AffectedPathsNode affectedPathsItem) {
            super("Operation_GetRepositoryResource", SVNUIMessages.class);
            this.affectedPathsItem = affectedPathsItem;
        }

        protected void runImpl(IProgressMonitor monitor) throws Exception {
            String rootUrl = HistoryActionManager.this.view.getRepositoryResource().getRepositoryLocation().getRepositoryRootUrl();
            String path = this.affectedPathsItem.getFullPath();
            String resourceUrl = rootUrl + (path.startsWith("/") ? "" : "/") + path;
            SVNRevision.Number revision = SVNRevision.fromNumber((long)HistoryActionManager.this.selectedRevision);
            IRepositoryLocation location = HistoryActionManager.this.view.getRepositoryResource().getRepositoryLocation();
            this.returnResource = location.asRepositoryContainer(resourceUrl, false);
            this.returnResource.setSelectedRevision((SVNRevision)revision);
            this.returnResource.setPegRevision((SVNRevision)revision);
        }

        public IRepositoryResource[] getRepositoryResources() {
            return new IRepositoryResource[]{this.returnResource};
        }
    }

    protected class FromChangedPathDataProvider
    extends AbstractActionOperation
    implements IRepositoryResourceProvider {
        protected IRepositoryResource[] repositoryResources;
        protected SVNChangedPathData affectedPathsItem;
        protected boolean filesOnly;

        public FromChangedPathDataProvider(SVNChangedPathData affectedPathsItem, boolean filesOnly) {
            super("Operation_GetRepositoryResource", SVNUIMessages.class);
            this.affectedPathsItem = affectedPathsItem;
            this.filesOnly = filesOnly;
        }

        protected void runImpl(IProgressMonitor monitor) throws Exception {
            String affectedPath = this.affectedPathsItem.getFullResourcePath();
            String rootUrl = HistoryActionManager.this.view.getRepositoryResource().getRepositoryLocation().getRepositoryRootUrl();
            String resourceUrl = rootUrl + "/" + affectedPath;
            SVNRevision.Number revision = SVNRevision.fromNumber((long)(this.affectedPathsItem.action == SVNLogPath.ChangeType.DELETED ? HistoryActionManager.this.selectedRevision - 1L : HistoryActionManager.this.selectedRevision));
            SVNEntryInfo info = null;
            IRepositoryLocation location = HistoryActionManager.this.view.getRepositoryResource().getRepositoryLocation();
            ISVNConnector proxy = location.acquireSVNProxy();
            try {
                SVNEntryInfo[] infos = SVNUtility.info((ISVNConnector)proxy, (SVNEntryRevisionReference)new SVNEntryRevisionReference(SVNUtility.encodeURL((String)resourceUrl), (SVNRevision)revision, (SVNRevision)revision), (SVNDepth)SVNDepth.EMPTY, (ISVNProgressMonitor)new SVNProgressMonitor((IActionOperation)this, monitor, null));
                if (infos == null || infos.length == 0) {
                    return;
                }
                info = infos[0];
            }
            finally {
                location.releaseSVNProxy(proxy);
            }
            if (info.kind == SVNEntry.Kind.DIR && this.filesOnly) {
                String message = BaseMessages.format((String)SVNUIMessages.AffectedPathsComposite_Open_Message, (Object[])new String[]{SVNUtility.decodeURL((String)info.url)});
                UIMonitorUtility.getDisplay().syncExec(() -> {
                    MessageDialog dialog = new MessageDialog(UIMonitorUtility.getDisplay().getActiveShell(), SVNUIMessages.AffectedPathsComposite_Open_Title, null, message, 2, new String[]{IDialogConstants.OK_LABEL}, 0);
                    dialog.open();
                });
                this.reportStatus((IStatus)new Status(2, "org.eclipse.team.svn.core.svnnature", 0, message, null));
                return;
            }
            this.repositoryResources = new IRepositoryResource[1];
            this.repositoryResources[0] = info.kind == SVNEntry.Kind.FILE ? location.asRepositoryFile(resourceUrl, false) : location.asRepositoryContainer(resourceUrl, false);
            this.repositoryResources[0].setSelectedRevision((SVNRevision)revision);
            this.repositoryResources[0].setPegRevision((SVNRevision)revision);
        }

        public IRepositoryResource[] getRepositoryResources() {
            return this.repositoryResources;
        }
    }

    public static class HistoryAction
    extends Action {
        protected HistoryAction(String text) {
            super(text);
        }

        protected HistoryAction(String text, Object[] args) {
            this(text, args, null);
        }

        protected HistoryAction(String text, Object[] args, String imageDescriptor) {
            super(BaseMessages.format((String)text, (Object[])args));
            this.setImageDescriptor(imageDescriptor == null ? null : SVNTeamUIPlugin.instance().getImageDescriptor(imageDescriptor));
        }

        protected HistoryAction(String text, String imageDescriptor) {
            this(text);
            this.setImageDescriptor(imageDescriptor == null ? null : SVNTeamUIPlugin.instance().getImageDescriptor(imageDescriptor));
        }

        protected HistoryAction(String text, String imageDescriptor, int style) {
            super(SVNUIMessages.getString(text), style);
            this.setImageDescriptor(imageDescriptor == null ? null : SVNTeamUIPlugin.instance().getImageDescriptor(imageDescriptor));
        }
    }

    public static interface IControlActionManager {
        public void installKeyBindings(StructuredViewer var1);

        public void installDefaultAction(StructuredViewer var1);

        public void installMenuActions(StructuredViewer var1, IWorkbenchPartSite var2);
    }

    protected class LogMessagesActionManager
    implements IControlActionManager {
        protected LogMessagesActionManager() {
        }

        @Override
        public void installKeyBindings(final StructuredViewer viewer) {
            viewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent event) {
                    ILogNode[] selection;
                    if (event.keyCode == 0x100000E) {
                        ((LogMessagesActionManager)LogMessagesActionManager.this).HistoryActionManager.this.view.refresh(3);
                    }
                    if (event.stateMask == 262144 && (event.keyCode == 99 || event.keyCode == 67) && (selection = LogMessagesActionManager.this.getSelection(viewer)).length > 0) {
                        HistoryActionManager.this.handleCopy(selection);
                    }
                }
            });
        }

        @Override
        public void installDefaultAction(StructuredViewer viewer) {
            viewer.addDoubleClickListener(e -> {
                IStructuredSelection structured;
                ISelection selection = e.getSelection();
                if (selection instanceof IStructuredSelection && (structured = (IStructuredSelection)selection).size() == 1) {
                    HistoryActionManager.this.handleDoubleClick((TreeViewer)viewer, (ILogNode)structured.getFirstElement(), true);
                }
            });
        }

        @Override
        public void installMenuActions(StructuredViewer viewer, IWorkbenchPartSite site) {
            MenuManager menuMgr = new MenuManager();
            Menu menu = menuMgr.createContextMenu(viewer.getControl());
            menuMgr.addMenuListener(manager -> {
                manager.add((IContributionItem)new Separator("additions"));
                HistoryAction refreshAction = new HistoryAction(SVNUIMessages.HistoryView_Refresh, "icons/common/refresh.gif"){

                    public void run() {
                        ((LogMessagesActionManager)LogMessagesActionManager.this).HistoryActionManager.this.view.refresh(3);
                    }
                };
                ILogNode[] selection = this.getSelection(viewer);
                if (selection.length == 0 || selection[0].getType() == 0) {
                    if (!HistoryActionManager.this.view.isPending() && HistoryActionManager.this.view.isFilterEnabled() && HistoryActionManager.this.view.getMode() != 64) {
                        this.addFilterPart(viewer, manager);
                    }
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)refreshAction);
                    return;
                }
                boolean onlyLogEntries = true;
                boolean onlyLocalEntries = true;
                boolean containsCategory = false;
                boolean containsMergeHistory = false;
                ILogNode[] iLogNodeArray = selection;
                int n = selection.length;
                int n2 = 0;
                while (n2 < n) {
                    ILogNode node = iLogNodeArray[n2];
                    int type = node.getType();
                    if (type != 2) {
                        onlyLogEntries = false;
                    } else if (node.getParent() instanceof SVNLogNode) {
                        containsMergeHistory = true;
                    }
                    if (type != 3) {
                        onlyLocalEntries = false;
                    }
                    if (type == 1) {
                        onlyLogEntries = false;
                        onlyLocalEntries = false;
                        containsCategory = true;
                    }
                    ++n2;
                }
                if (onlyLogEntries) {
                    this.addRemotePart(viewer, manager, selection, containsMergeHistory);
                    this.addFilterPart(viewer, manager);
                    manager.add((IContributionItem)new Separator());
                }
                if (onlyLocalEntries) {
                    this.addLocalPart(viewer, manager, selection);
                    manager.add((IContributionItem)new Separator());
                }
                if (!(onlyLogEntries || onlyLocalEntries || containsCategory)) {
                    this.addLocalOrRemotePart(viewer, manager, selection, containsMergeHistory);
                    manager.add((IContributionItem)new Separator());
                }
                if (!onlyLogEntries) {
                    this.addCommonPart(viewer, manager, selection, containsMergeHistory);
                    manager.add((IContributionItem)new Separator());
                }
                manager.add((IAction)refreshAction);
            });
            menuMgr.setRemoveAllWhenShown(true);
            viewer.getControl().setMenu(menu);
            site.registerContextMenu(menuMgr, (ISelectionProvider)viewer);
        }

        protected void addRemotePart(final StructuredViewer viewer, IMenuManager manager, final ILogNode[] selection, boolean containsMergeHistory) {
            String revision;
            final Shell shell = viewer.getControl().getShell();
            Action tAction = null;
            SVNLogEntry[] entries = HistoryActionManager.this.view.getFullRemoteHistory();
            boolean existsInPrevious = entries[entries.length - 1] != selection[0].getEntity() || !HistoryActionManager.this.view.isAllRemoteHistoryFetched();
            final SVNLogEntry current = (SVNLogEntry)selection[0].getEntity();
            String string = revision = HistoryActionManager.this.view.getResource() != null ? String.valueOf(current.revision) : SVNUIMessages.HistoryView_HEAD;
            if (!containsMergeHistory) {
                if (HistoryActionManager.this.view.getRepositoryResource() instanceof IRepositoryFile) {
                    IEditorDescriptor[] editors;
                    String name = HistoryActionManager.this.view.getRepositoryResource().getName();
                    tAction = new HistoryAction(SVNUIMessages.HistoryView_Open){

                        public void run() {
                            HistoryActionManager.this.handleDoubleClick((TreeViewer)viewer, selection[0], false);
                        }
                    };
                    manager.add((IAction)tAction);
                    tAction.setEnabled(selection.length == 1);
                    tAction.setImageDescriptor(SVNTeamUIPlugin.instance().getWorkbench().getEditorRegistry().getImageDescriptor(name));
                    MenuManager sub = new MenuManager(SVNUIMessages.HistoryView_OpenWith, "historyOpenWithMenu");
                    sub.add((IContributionItem)new Separator("additions"));
                    sub.add((IContributionItem)new Separator("nonDefaultTextEditors"));
                    IEditorDescriptor[] iEditorDescriptorArray = editors = SVNTeamUIPlugin.instance().getWorkbench().getEditorRegistry().getEditors(name);
                    int n = editors.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IEditorDescriptor editor = iEditorDescriptorArray[n2];
                        if (!editor.getId().equals("org.eclipse.ui.DefaultTextEditor")) {
                            HistoryActionManager.this.addMenuItem(viewer, sub, editor.getLabel(), new OpenFileWithAction(editor.getId(), false));
                        }
                        ++n2;
                    }
                    sub.add((IContributionItem)new Separator("variousEditors"));
                    HistoryActionManager.this.addMenuItem(viewer, sub, SVNUIMessages.HistoryView_TextEditor, new OpenFileWithAction());
                    HistoryActionManager.this.addMenuItem(viewer, sub, SVNUIMessages.HistoryView_SystemEditor, new OpenFileWithExternalAction());
                    HistoryActionManager.this.addMenuItem(viewer, sub, SVNUIMessages.HistoryView_InplaceEditor, new OpenFileWithInplaceAction());
                    HistoryActionManager.this.addMenuItem(viewer, sub, SVNUIMessages.HistoryView_DefaultEditor, new OpenFileAction());
                    manager.add((IContributionItem)sub);
                    manager.add((IContributionItem)new Separator());
                }
                boolean isCompareAllowed = CoreExtensionsManager.instance().getSVNConnectorFactory().getSVNAPIVersion() >= 5 || HistoryActionManager.this.view.getRepositoryResource() instanceof IRepositoryFile;
                tAction = new HistoryAction(SVNUIMessages.HistoryView_CompareEachOther){

                    public void run() {
                        SVNLogEntry msg0 = (SVNLogEntry)selection[0].getEntity();
                        SVNLogEntry msg1 = (SVNLogEntry)selection[1].getEntity();
                        IRepositoryResource next = HistoryActionManager.this.getResourceForSelectedRevision(msg0);
                        IRepositoryResource prev = HistoryActionManager.this.getResourceForSelectedRevision(msg1);
                        if (msg0.revision < msg1.revision) {
                            IRepositoryResource tmp = prev;
                            prev = next;
                            next = tmp;
                        }
                        CompareRepositoryResourcesOperation op = new CompareRepositoryResourcesOperation(prev, next);
                        op.setForceId(HistoryActionManager.this.getCompareForceId());
                        UIMonitorUtility.doTaskScheduledActive((IActionOperation)op);
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(selection.length == 2 && isCompareAllowed);
                tAction = new HistoryAction(SVNUIMessages.HistoryView_CompareCurrentWith, new String[]{revision}){

                    public void run() {
                        HistoryActionManager.this.compareWithCurrent(current);
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(selection.length == 1 && isCompareAllowed);
                tAction = new HistoryAction(SVNUIMessages.HistoryView_CompareWithPrevious){

                    public void run() {
                        HistoryActionManager.this.compareWithPreviousRevision(null, () -> {
                            SVNLogEntry current1 = (SVNLogEntry)selection[0].getEntity();
                            return new IRepositoryResource[]{HistoryActionManager.this.getResourceForSelectedRevision(current1)};
                        });
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(selection.length == 1 && isCompareAllowed && existsInPrevious);
                manager.add((IContributionItem)new Separator());
                tAction = new HistoryAction(SVNUIMessages.ShowPropertiesAction_label, "icons/views/propertiesedit.gif"){

                    public void run() {
                        SVNLogEntry current = (SVNLogEntry)selection[0].getEntity();
                        IRepositoryResource resource = HistoryActionManager.this.getResourceForSelectedRevision(current);
                        GetRemotePropertiesOperation provider = new GetRemotePropertiesOperation(resource);
                        ShowPropertiesOperation op = new ShowPropertiesOperation(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IAdaptable)resource, (IResourcePropertyProvider)provider);
                        UIMonitorUtility.doTaskScheduledActive((IActionOperation)op);
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(selection.length == 1);
                tAction = new HistoryAction(SVNUIMessages.SynchronizeActionGroup_CompareProperties){

                    public void run() {
                        IRepositoryResource remote;
                        SVNLogEntry first = (SVNLogEntry)selection[0].getEntity();
                        SVNLogEntry second = (SVNLogEntry)selection[1].getEntity();
                        if (first.revision < second.revision) {
                            SVNLogEntry tmp = second;
                            second = first;
                            first = tmp;
                        }
                        if ((remote = ((LogMessagesActionManager)LogMessagesActionManager.this).HistoryActionManager.this.view.getRepositoryResource()) == null) {
                            remote = SVNRemoteStorage.instance().asRepositoryResource(((LogMessagesActionManager)LogMessagesActionManager.this).HistoryActionManager.this.view.getResource());
                        }
                        TwoWayPropertyCompareInput input = new TwoWayPropertyCompareInput(new CompareConfiguration(), new SVNEntryRevisionReference(remote.getUrl(), (SVNRevision)SVNRevision.fromNumber((long)((LogMessagesActionManager)LogMessagesActionManager.this).HistoryActionManager.this.view.getCurrentRevision()), (SVNRevision)SVNRevision.fromNumber((long)first.revision)), new SVNEntryRevisionReference(remote.getUrl(), (SVNRevision)SVNRevision.fromNumber((long)((LogMessagesActionManager)LogMessagesActionManager.this).HistoryActionManager.this.view.getCurrentRevision()), (SVNRevision)SVNRevision.fromNumber((long)second.revision)), remote.getRepositoryLocation());
                        CompareUI.openCompareEditor((CompareEditorInput)input);
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(selection.length == 2);
            }
            tAction = new HistoryAction(SVNUIMessages.ShowRevisionProperties_label){

                public void run() {
                    SVNRevision.Number selectedRevision = SVNRevision.fromNumber((long)HistoryActionManager.this.getSelectedRevision());
                    IRepositoryLocation location = HistoryActionManager.this.getResourceForHeadRevision().getRepositoryLocation();
                    ShowRevisionPropertiesOperation op = new ShowRevisionPropertiesOperation(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), location, (SVNRevision)selectedRevision);
                    UIMonitorUtility.doTaskScheduledActive((IActionOperation)op);
                }
            };
            manager.add((IAction)tAction);
            tAction.setEnabled(selection.length == 1);
            if (!containsMergeHistory) {
                if (HistoryActionManager.this.view.getRepositoryResource() instanceof IRepositoryFile) {
                    tAction = new HistoryAction(SVNUIMessages.ShowAnnotationCommand_label){

                        public void run() {
                            IRepositoryResource remote = HistoryActionManager.this.getResourceForSelectedRevision((SVNLogEntry)selection[0].getEntity());
                            UIMonitorUtility.doTaskScheduledDefault((IActionOperation)new RemoteShowAnnotationOperation(remote));
                        }
                    };
                    manager.add((IAction)tAction);
                    tAction.setEnabled(selection.length == 1);
                }
                manager.add((IContributionItem)new Separator());
                tAction = new HistoryAction(SVNUIMessages.ExportCommand_label, "icons/common/export.gif"){

                    public void run() {
                        HistoryActionManager.this.doExport(selection[0]);
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(selection.length == 1);
                tAction = new HistoryAction(SVNUIMessages.CreatePatchCommand_label){

                    public void run() {
                        HistoryActionManager.this.createPatch(selection);
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(selection.length == 1 && existsInPrevious || selection.length == 2);
                if (HistoryActionManager.this.view.getResource() != null) {
                    tAction = new HistoryAction(SVNUIMessages.HistoryView_GetContents){

                        public void run() {
                            if (HistoryActionManager.this.confirmReplacement()) {
                                HistoryActionManager.this.getRevisionContents((SVNLogEntry)selection[0].getEntity(), shell);
                            }
                        }
                    };
                    manager.add((IAction)tAction);
                    tAction.setEnabled(selection.length == 1);
                }
                if (HistoryActionManager.this.view.getResource() != null) {
                    tAction = new HistoryAction(SVNUIMessages.HistoryView_UpdateTo){

                        public void run() {
                            if (HistoryActionManager.this.confirmReplacement()) {
                                HistoryActionManager.this.updateTo((SVNLogEntry)selection[0].getEntity());
                            }
                        }
                    };
                    manager.add((IAction)tAction);
                    tAction.setEnabled(selection.length == 1);
                }
                tAction = new Action(SVNUIMessages.ExtractToAction_Label){

                    public void run() {
                        HistoryActionManager.this.runExtractTo(selection);
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(selection.length == 1 && existsInPrevious || selection.length == 2);
                manager.add((IContributionItem)new Separator());
                String branchFrom = SVNUIMessages.HistoryView_BranchFromRevision;
                String tagFrom = SVNUIMessages.HistoryView_TagFromRevision;
                if (selection.length == 1) {
                    revision = String.valueOf(((SVNLogEntry)selection[0].getEntity()).revision);
                    branchFrom = BaseMessages.format((String)SVNUIMessages.HistoryView_BranchFrom, (Object[])new String[]{revision});
                    tagFrom = BaseMessages.format((String)SVNUIMessages.HistoryView_TagFrom, (Object[])new String[]{revision});
                }
                tAction = new HistoryAction(branchFrom, "icons/common/actions/branch.gif"){

                    public void run() {
                        PreparedBranchTagOperation op = BranchTagAction.getBranchTagOperation(new IRepositoryResource[]{HistoryActionManager.this.getResourceForSelectedRevision((SVNLogEntry)selection[0].getEntity())}, UIMonitorUtility.getShell(), 0);
                        if (op != null) {
                            UIMonitorUtility.doTaskScheduledActive((IActionOperation)op);
                        }
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(selection.length == 1);
                tAction = new HistoryAction(tagFrom, "icons/common/actions/tag.gif"){

                    public void run() {
                        PreparedBranchTagOperation op = BranchTagAction.getBranchTagOperation(new IRepositoryResource[]{HistoryActionManager.this.getResourceForSelectedRevision((SVNLogEntry)selection[0].getEntity())}, UIMonitorUtility.getShell(), 1);
                        if (op != null) {
                            UIMonitorUtility.doTaskScheduledActive((IActionOperation)op);
                        }
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(selection.length == 1);
                tAction = new HistoryAction(SVNUIMessages.AddRevisionLinkAction_label){

                    public void run() {
                        HistoryActionManager.this.addRevisionLinks(selection);
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(selection.length > 0);
            }
            manager.add((IContributionItem)new Separator());
            tAction = new HistoryAction(SVNUIMessages.HistoryView_CopyHistory, "icons/common/copy.gif"){

                public void run() {
                    HistoryActionManager.this.handleCopy(selection);
                }
            };
            manager.add((IAction)tAction);
            tAction.setEnabled(selection.length > 0);
        }

        protected void addFilterPart(StructuredViewer viewer, IMenuManager manager) {
            manager.add((IContributionItem)new Separator());
            HistoryAction tAction = null;
            tAction = new HistoryAction(SVNUIMessages.HistoryView_QuickFilter, "icons/views/history/filter.gif"){

                public void run() {
                    ((LogMessagesActionManager)LogMessagesActionManager.this).HistoryActionManager.this.view.setFilter();
                }
            };
            manager.add((IAction)tAction);
            tAction = new HistoryAction(SVNUIMessages.HistoryView_ClearFilter, "icons/views/history/clear_filter.gif"){

                public void run() {
                    ((LogMessagesActionManager)LogMessagesActionManager.this).HistoryActionManager.this.view.clearFilter();
                }
            };
            manager.add((IAction)tAction);
            tAction.setEnabled(HistoryActionManager.this.view.isFilterEnabled());
        }

        protected void addLocalPart(final StructuredViewer viewer, IMenuManager manager, final ILogNode[] selection) {
            HistoryAction tAction = null;
            tAction = new HistoryAction(SVNUIMessages.HistoryView_Open){

                public void run() {
                    HistoryActionManager.this.handleDoubleClick((TreeViewer)viewer, selection[0], false);
                }
            };
            manager.add((IAction)tAction);
            tAction.setEnabled(selection.length == 1);
            tAction.setImageDescriptor(SVNTeamUIPlugin.instance().getWorkbench().getEditorRegistry().getImageDescriptor(((SVNLocalFileRevision)((Object)selection[0].getEntity())).getName()));
            manager.add((IContributionItem)new Separator());
            tAction = new HistoryAction(SVNUIMessages.HistoryView_CompareEachOther){

                public void run() {
                    HistoryActionManager.this.runCompareForLocal(selection);
                }
            };
            manager.add((IAction)tAction);
            tAction.setEnabled(selection.length == 2);
            tAction = new HistoryAction(SVNUIMessages.HistoryView_CompareCurrentWith, new String[]{SVNUIMessages.HistoryView_RevisionLocal}){

                public void run() {
                    HistoryActionManager.this.runCompareForLocal(selection);
                }
            };
            manager.add((IAction)tAction);
            tAction.setEnabled(selection.length == 1);
            tAction = new HistoryAction(SVNUIMessages.HistoryView_CompareWithPrevious){

                public void run() {
                    SVNLocalFileRevision[] localHistory = ((LogMessagesActionManager)LogMessagesActionManager.this).HistoryActionManager.this.view.getLocalHistory();
                    SVNLocalFileRevision currentSelected = (SVNLocalFileRevision)((Object)selection[0].getEntity());
                    ArrayList<SVNLocalFileRevision> toOperate = new ArrayList<SVNLocalFileRevision>();
                    toOperate.add(currentSelected);
                    int i = 0;
                    while (i < localHistory.length - 1) {
                        if (currentSelected.equals((Object)localHistory[i])) {
                            toOperate.add(localHistory[i + 1]);
                            break;
                        }
                        ++i;
                    }
                    HistoryActionManager.this.runCompareForLocal(toOperate.toArray());
                }
            };
            manager.add((IAction)tAction);
            tAction.setEnabled(selection.length == 1 && !selection[0].getEntity().equals((Object)HistoryActionManager.this.view.getLocalHistory()[HistoryActionManager.this.view.getLocalHistory().length - 1]));
            manager.add((IContributionItem)new Separator());
            tAction = new HistoryAction(SVNUIMessages.ExportCommand_label, "icons/common/export.gif"){

                public void run() {
                    HistoryActionManager.this.doExport(selection[0]);
                }
            };
            manager.add((IAction)tAction);
            tAction.setEnabled(selection.length == 1);
            tAction = new HistoryAction(SVNUIMessages.HistoryView_GetContents){

                public void run() {
                    try {
                        ((IFile)((LogMessagesActionManager)LogMessagesActionManager.this).HistoryActionManager.this.view.getResource()).setContents(((SVNLocalFileRevision)((Object)selection[0].getEntity())).getState(), true, true, (IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (CoreException ex) {
                        UILoggedOperation.reportError(this.getText(), ex);
                    }
                }
            };
            manager.add((IAction)tAction);
            tAction.setEnabled(selection.length == 1 && !((SVNLocalFileRevision)((Object)selection[0].getEntity())).isCurrentState());
        }

        protected void addLocalOrRemotePart(StructuredViewer viewer, IMenuManager manager, final ILogNode[] selection, boolean containsMergeHistory) {
            HistoryAction tAction = null;
            if (!containsMergeHistory) {
                tAction = new HistoryAction(SVNUIMessages.HistoryView_CompareEachOther){

                    public void run() {
                        ArrayList<ILogNode> selected = new ArrayList<ILogNode>();
                        ILogNode[] iLogNodeArray = selection;
                        int n = selection.length;
                        int n2 = 0;
                        while (n2 < n) {
                            ILogNode item = iLogNodeArray[n2];
                            if (item.getType() == 3) {
                                selected.add(item);
                            } else {
                                selected.add((ILogNode)new SVNRemoteResourceRevision(HistoryActionManager.this.getResourceForSelectedRevision((SVNLogEntry)item.getEntity()), (SVNLogEntry)item.getEntity()));
                            }
                            ++n2;
                        }
                        HistoryActionManager.this.runCompareForLocal(selected.toArray());
                    }
                };
                manager.add((IAction)tAction);
                tAction.setEnabled(selection.length == 2);
            }
        }

        protected void addCommonPart(StructuredViewer viewer, IMenuManager manager, final ILogNode[] selection, boolean containsMergeHistory) {
            HistoryAction tAction = null;
            tAction = new HistoryAction(SVNUIMessages.HistoryView_CopyHistory, "icons/common/copy.gif"){

                public void run() {
                    HistoryActionManager.this.handleCopy(selection);
                }
            };
            manager.add((IAction)tAction);
            tAction.setEnabled(selection.length > 0);
        }

        protected ILogNode[] getSelection(StructuredViewer viewer) {
            List selection = ((IStructuredSelection)viewer.getSelection()).toList();
            return selection.toArray(new ILogNode[selection.size()]);
        }
    }
}

