/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.debugmail;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.extension.factory.ISVNConnectorFactory;
import org.eclipse.team.svn.ui.extension.factory.IReportingDescriptor;

public class ReportPartsFactory {
    public static boolean checkStatus(IStatus status, IStatusVisitor visitor) {
        IStatus[] children;
        if (!status.isMultiStatus()) {
            return visitor.visit(status);
        }
        IStatus[] iStatusArray = children = status.getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus child = iStatusArray[n2];
            if (ReportPartsFactory.checkStatus(child, visitor)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String getStackTrace(IStatus operationStatus) {
        String[] stackTrace = new String[]{""};
        ReportPartsFactory.checkStatus(operationStatus, status -> {
            String trace = ReportPartsFactory.getOutput(status);
            stringArray[0] = String.valueOf(stackTrace[0]) + trace + "\n";
            return false;
        });
        return stackTrace[0];
    }

    public static String getOutput(IStatus status) {
        Throwable t = status.getException();
        String message = "";
        if (t != null) {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            PrintWriter writer = new PrintWriter(output);
            Throwable throwable = null;
            Object var6_7 = null;
            try {
                try {
                    t.printStackTrace(writer);
                }
                finally {
                    if (writer != null) {
                        writer.close();
                    }
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            message = output.toString();
        }
        return message;
    }

    public static String removeHTMLTags(String report) {
        report = report.replace("<b>", "");
        report = report.replace("</b> ", "\t");
        report = report.replace("</b>", "");
        report = report.replace("<i>", "");
        report = report.replace("</i>", "");
        report = report.replace("<br>", "\n");
        return report;
    }

    public static String getStatusPart(IStatus status) {
        String[] stackTraces;
        Object retVal = "";
        String[] stringArray = stackTraces = ReportPartsFactory.getStackTrace(status).split("\n\n");
        int n = stackTraces.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            int idx = element.indexOf(10);
            retVal = idx == -1 ? (String)retVal + element + "<br><br>" : (String)retVal + "<b>" + element.substring(0, idx) + "</b><br>" + element + "<br><br>";
            ++n2;
        }
        retVal = (String)retVal + "<br>";
        return retVal;
    }

    public static String getReportIdPart(String id) {
        return "<b>" + id + "</b><br><br>";
    }

    public static String getProductPart(IReportingDescriptor provider) {
        return "<b>Product:</b> " + provider.getProductName() + "<br><br>";
    }

    public static String getVersionPart(IReportingDescriptor provider) {
        return "<b>Version:</b> " + provider.getProductVersion() + "<br><br>";
    }

    public static String getAuthorPart(String email, String name) {
        Object author = (name != null ? name : "") + (String)(email != null && email.trim().length() > 0 ? " &lt;" + email + "&gt;" : "");
        author = ((String)author).trim().length() > 0 ? author : "<i>[not specified]</i>";
        return "<b>From:</b> " + (String)author + "<br><br>";
    }

    public static String getUserCommentPart(String userComment) {
        userComment = userComment != null && userComment.trim().length() > 0 ? userComment : "<i>[empty]</i>";
        return "<b>User comment:</b><br>" + userComment + "<br><br>";
    }

    public static String getSVNClientPart() {
        ISVNConnectorFactory factory = CoreExtensionsManager.instance().getSVNConnectorFactory();
        return "<b>SVN Client:</b> " + factory.getId() + " " + factory.getVersion() + " " + factory.getClientVersion() + "<br><br>";
    }

    public static String getJVMPropertiesPart() {
        String[] keys;
        Properties systemProps = System.getProperties();
        Properties props = new Properties();
        String[] stringArray = keys = new String[]{"os.name", "os.version", "os.arch", "user.timezone", "file.separator", "line.separator", "path.separator", "file.encoding", "user.language", "user.country", "java.version", "java.runtime.version", "java.class.version", "java.vm.name", "java.vm.info", "java.vendor", "java.runtime.name", "osgi.framework.version", "eclipse.commands"};
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (systemProps.containsKey(key)) {
                props.put(key, systemProps.getProperty(key));
            }
            ++n2;
        }
        return "<b>JVM Properties:</b><br>" + props.toString().replace('\n', ' ') + "<br><br>";
    }

    public static interface IStatusVisitor {
        public boolean visit(IStatus var1);
    }
}

