/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.compare;

import org.eclipse.compare.CompareEditorInput;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.svn.core.operation.CompositeOperation;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.operation.local.RefreshResourcesOperation;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.panel.AbstractDialogPanel;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public class ComparePanel
extends AbstractDialogPanel {
    protected CompareEditorInput compareInput;
    protected IResource resource;

    public ComparePanel(CompareEditorInput compareInput, IResource resource) {
        super(new String[]{SVNUIMessages.CompareLocalPanel_Save, IDialogConstants.CANCEL_LABEL});
        this.compareInput = compareInput;
        this.resource = resource;
        this.dialogTitle = SVNUIMessages.CompareLocalPanel_Title;
        this.dialogDescription = SVNUIMessages.CompareLocalPanel_Description;
        this.defaultMessage = SVNUIMessages.CompareLocalPanel_Message;
    }

    @Override
    public void createControlsImpl(Composite parent) {
        Control control = this.compareInput.createContents(parent);
        control.setLayoutData((Object)new GridData(1808));
        Shell shell = control.getShell();
        shell.setText(this.compareInput.getTitle());
        shell.setImage(this.compareInput.getTitleImage());
    }

    @Override
    protected void cancelChangesImpl() {
    }

    @Override
    protected void saveChangesImpl() {
        RefreshResourcesOperation refreshOp = new RefreshResourcesOperation(new IResource[]{this.resource.getProject()});
        AbstractWorkingCopyOperation mainOp = new AbstractWorkingCopyOperation("Operation_SaveChanges", SVNUIMessages.class, new IResource[]{this.resource.getProject()}){

            protected void runImpl(IProgressMonitor monitor) throws Exception {
                ComparePanel.this.compareInput.saveChanges(monitor);
            }
        };
        CompositeOperation composite = new CompositeOperation(mainOp.getId(), mainOp.getMessagesClass());
        composite.add((IActionOperation)mainOp);
        composite.add((IActionOperation)refreshOp);
        UIMonitorUtility.doTaskBusyWorkspaceModify((IActionOperation)composite);
    }

    @Override
    public Point getPrefferedSizeImpl() {
        return new Point(650, 500);
    }
}

