/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui;

import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.team.FileModificationValidationContext;
import org.eclipse.core.resources.team.FileModificationValidator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.ui.utility.LockProposeUtility;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public class SVNTeamModificationValidator
extends FileModificationValidator {
    public IStatus validateEdit(IFile[] files, FileModificationValidationContext context) {
        IResource[] needsLockResources;
        if (FileUtility.isConnected((IResource)files[0]) && (needsLockResources = this.getNeedsLockResources((IResource[])files)).length > 0) {
            IStatus[] retVal = new IStatus[1];
            Shell shell = context.getShell() == null ? UIMonitorUtility.getShell() : (Shell)context.getShell();
            shell.getDisplay().syncExec(() -> {
                IStatus iStatus = LockProposeUtility.proposeLock(needsLockResources, shell, true);
            });
            return retVal[0];
        }
        return Status.OK_STATUS;
    }

    public IStatus validateSave(IFile file) {
        return Status.OK_STATUS;
    }

    protected IResource[] getNeedsLockResources(IResource[] files) {
        IResource[] needsLockResources;
        ArrayList<IResource> returnResources = new ArrayList<IResource>();
        IResource[] iResourceArray = needsLockResources = FileUtility.getResourcesRecursive((IResource[])files, (IStateFilter)IStateFilter.SF_NEEDS_LOCK, (int)0);
        int n = needsLockResources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource element = iResourceArray[n2];
            if (!SVNRemoteStorage.instance().asLocalResource(element).isLocked()) {
                returnResources.add(element);
            }
            ++n2;
        }
        return returnResources.toArray(new IResource[returnResources.size()]);
    }
}

