/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.utility;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.team.svn.core.SVNMessages;

public class SubProgressMonitorWithInfo
extends ProgressMonitorWrapper {
    protected double currentProgress;
    protected double unknownProgress;
    protected long lastTime;
    protected double parentTicks;
    protected double scale;
    protected int totalWork;
    protected String subTaskOp;

    public SubProgressMonitorWithInfo(IProgressMonitor monitor, double parentTicks) {
        super(monitor);
        this.parentTicks = parentTicks;
    }

    public void beginTask(String name, int totalWork) {
        this.lastTime = 0L;
        this.currentProgress = 0.0;
        this.unknownProgress = 0.0;
        this.totalWork = totalWork > 0 ? totalWork : 100;
        this.scale = this.parentTicks / (double)this.totalWork;
    }

    public void done() {
        this.subTaskOp = null;
        this.internalWorked((double)this.totalWork - this.currentProgress);
    }

    public void internalWorked(double work) {
        if (this.currentProgress + work > (double)this.totalWork) {
            work = (double)this.totalWork - this.currentProgress;
        }
        if (this.currentProgress < (double)this.totalWork) {
            this.currentProgress += work;
            super.internalWorked(work * this.scale);
        }
    }

    public void worked(int work) {
        if (work == -1) {
            double delta = ((double)this.totalWork - this.currentProgress) / (double)this.totalWork;
            this.unknownProgress += (delta /= this.unknownProgress < 25.0 ? 0.5 : (double)(this.unknownProgress < 50.0 ? 1 : (this.unknownProgress < 75.0 ? 2 : (this.unknownProgress < 85.0 ? 8 : (this.unknownProgress < 95.0 ? 25 : 100)))));
            int offset = (int)(this.unknownProgress - this.currentProgress);
            this.internalWorked(offset);
        } else {
            this.internalWorked(work);
        }
    }

    public void unknownProgress(int current) {
        this.worked(-1);
    }

    public void subTask(String name) {
        boolean operationChanged;
        long time = System.currentTimeMillis();
        boolean bl = operationChanged = this.subTaskOp == null || !name.startsWith(this.subTaskOp) || name.charAt(this.subTaskOp.length()) != ':' || name.endsWith(SVNMessages.Progress_Done);
        if (this.lastTime == 0L || time - this.lastTime >= 250L || operationChanged) {
            this.lastTime = time;
            int idx = name.indexOf(58);
            if (idx != -1) {
                this.subTaskOp = name.endsWith(SVNMessages.Progress_Running) ? name.substring(0, idx) : null;
            }
            super.subTask(name);
        }
    }

    public int getCurrentProgress() {
        return (int)this.currentProgress;
    }
}

