/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.synchronize;

import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.variants.IResourceVariantComparator;
import org.eclipse.team.svn.core.IStateFilter;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IResourceChange;
import org.eclipse.team.svn.core.synchronize.AbstractSVNSyncInfo;

public class UpdateSyncInfo
extends AbstractSVNSyncInfo {
    public UpdateSyncInfo(ILocalResource local, IResourceChange remote, IResourceVariantComparator comparator) {
        super(local, remote, comparator);
    }

    protected int calculateKind() throws TeamException {
        int remoteMask;
        int localMask;
        String localKind = this.local == null ? IStateFilter.ST_NOTEXISTS : this.local.getStatus();
        int n = localMask = this.local == null ? 0 : this.local.getChangeMask();
        String remoteKind = this.remoteStatus == null ? (this.isNonVersioned(localKind, localMask) ? IStateFilter.ST_NOTEXISTS : "Normal") : this.remoteStatus.getStatus();
        int n2 = remoteMask = this.remoteStatus == null ? 0 : this.remoteStatus.getChangeMask();
        if (this.isLinked(localKind, localMask)) {
            if (this.isAdded(remoteKind, remoteMask)) {
                this.localKind = 5;
                this.remoteKind = 9;
                return 13;
            }
            return 0;
        }
        if (this.isTreeConflicted(localKind, localMask)) {
            this.localKind = 7;
            this.remoteKind = 11;
            return 15;
        }
        if (this.isReplaced(remoteKind, remoteMask)) {
            this.remoteKind = 11;
            if (this.isNotModified(localKind, localMask)) {
                return 11;
            }
            this.localKind = 7;
            return 15;
        }
        if (this.isAdded(remoteKind, remoteMask)) {
            this.remoteKind = 9;
            if (this.isNotExists(localKind, localMask)) {
                return 9;
            }
            this.localKind = 5;
            return 13;
        }
        if (this.isModified(remoteKind, remoteMask)) {
            this.remoteKind = 11;
            if (this.isNotModified(localKind, localMask)) {
                return 11;
            }
            if (this.isDeleted(localKind, localMask)) {
                this.localKind = 6;
                return 14;
            }
            this.localKind = 7;
            return 15;
        }
        if (this.isDeleted(remoteKind, remoteMask)) {
            this.remoteKind = 10;
            if (this.isNotModified(localKind, localMask)) {
                return 10;
            }
            if (this.isDeleted(localKind, localMask)) {
                this.localKind = 6;
                return 14;
            }
            this.localKind = 7;
            return 14;
        }
        if (this.isNonVersioned(remoteKind, remoteMask)) {
            if (this.isIgnored(localKind, localMask) || this.isNotExists(localKind, localMask)) {
                return 0;
            }
            this.localKind = 5;
            return 5;
        }
        if (this.isConflicted(localKind, localMask)) {
            this.localKind = 7;
            this.remoteKind = 11;
            return 15;
        }
        if (this.isReplaced(localKind, localMask) || this.isModified(localKind, localMask)) {
            this.localKind = 7;
            return 7;
        }
        if (this.isDeleted(localKind, localMask)) {
            this.localKind = 6;
            return 6;
        }
        if (this.isAdded(localKind, localMask)) {
            this.localKind = 5;
            return 5;
        }
        return 0;
    }
}

