/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.remote;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNEntryReference;
import org.eclipse.team.svn.core.connector.SVNProperty;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.operation.AbstractActionOperation;
import org.eclipse.team.svn.core.operation.IRevisionProvider;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;

public class SetRevisionAuthorNameOperation
extends AbstractActionOperation {
    protected IRevisionProvider provider;
    protected long options;

    public SetRevisionAuthorNameOperation(IRevisionProvider.RevisionPair[] revisions, long options) {
        this(() -> revisions, options);
    }

    public SetRevisionAuthorNameOperation(IRevisionProvider provider, long options) {
        super("Operation_SetRevisionAuthorName", SVNMessages.class);
        this.provider = provider;
        this.options = options;
    }

    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IRevisionProvider.RevisionPair[] revisions = this.provider.getRevisions();
        if (revisions == null) {
            return;
        }
        int i = 0;
        while (i < revisions.length && !monitor.isCanceled()) {
            IRepositoryLocation location;
            if (revisions[i] != null && revisions[i].revision != -1L && (location = revisions[i].location).isAuthorNameEnabled()) {
                ISVNConnector proxy = location.acquireSVNProxy();
                SVNRevision.Number rev = SVNRevision.fromNumber(revisions[i].revision);
                this.protectStep(monitor1 -> proxy.setRevisionProperty(new SVNEntryReference(location.getUrl(), rev), new SVNProperty("svn:author", location.getAuthorName()), null, this.options, new SVNProgressMonitor(this, monitor1, null)), monitor, 1);
                location.releaseSVNProxy(proxy);
            }
            ++i;
        }
    }
}

