/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local.management;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.svn.core.BaseMessages;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.SVNTeamProvider;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.SVNChangeStatus;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.operation.SVNNullProgressMonitor;
import org.eclipse.team.svn.core.operation.SVNProgressMonitor;
import org.eclipse.team.svn.core.operation.local.AbstractWorkingCopyOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IResourceProvider;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class RelocateWorkingCopyOperation
extends AbstractWorkingCopyOperation
implements IResourceProvider {
    protected IRepositoryLocation location;
    protected List<IProject> resources;

    public RelocateWorkingCopyOperation(IResource[] resources, IRepositoryLocation location) {
        super("Operation_RelocateResources", SVNMessages.class, resources);
        this.location = location;
    }

    public RelocateWorkingCopyOperation(IResourceProvider provider, IRepositoryLocation location) {
        super("Operation_RelocateResources", SVNMessages.class, provider);
        this.location = location;
    }

    @Override
    public IResource[] getResources() {
        return this.resources == null ? new IResource[]{} : this.resources.toArray(new IResource[this.resources.size()]);
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void runImpl(IProgressMonitor monitor) throws Exception {
        this.resources = new ArrayList<IProject>();
        IResource[] projects = this.operableData();
        if (projects.length == 0) {
            return;
        }
        ISVNConnector proxy = this.location.acquireSVNProxy();
        try {
            block7: {
                int i;
                HashSet processedPaths;
                IRepositoryResource[] children;
                block6: {
                    children = this.location.getRepositoryRoot().getChildren();
                    processedPaths = new HashSet();
                    i = 0;
                    if (!true) break block6;
                    if (i >= projects.length) return;
                    if (monitor.isCanceled()) break block7;
                }
                do {
                    IProject current = (IProject)projects[i];
                    this.protectStep(monitor1 -> {
                        IPath fsLocation = FileUtility.getResourcePath((IResource)current);
                        if (fsLocation != FileUtility.getAlwaysIgnoredPath()) {
                            String path = this.getWCRootPath(fsLocation.toString());
                            if (!processedPaths.contains(path)) {
                                String newURL;
                                String url;
                                SVNChangeStatus[] stats = SVNUtility.status(proxy, path, SVNDepth.EMPTY, 128L, new SVNNullProgressMonitor());
                                if (stats.length > 0 && stats[0].url != null && !(url = SVNUtility.decodeURL(stats[0].url)).equals(newURL = this.remapURL(url, children))) {
                                    this.writeToConsole(0, "svn switch --relocate \"" + newURL + "\" \"" + FileUtility.normalizePath(path) + "\"" + FileUtility.getUsernameParam(this.location.getUsername()) + "\n");
                                    proxy.relocate(url, newURL, path, SVNDepth.INFINITY, new SVNProgressMonitor(this, monitor1, null));
                                }
                                processedPaths.add(path);
                            }
                            SVNTeamProvider provider = (SVNTeamProvider)RepositoryProvider.getProvider((IProject)current, (String)"org.eclipse.team.svn.core.svnnature");
                            provider.relocateResource();
                            this.resources.add(current);
                        }
                    }, monitor, projects.length);
                    ++i;
                    if (i >= projects.length) return;
                } while (!monitor.isCanceled());
            }
            return;
        }
        finally {
            this.location.releaseSVNProxy(proxy);
        }
    }

    public String remapURL(String oldUrl, IRepositoryResource[] rootChildren) {
        IRepositoryResource[] iRepositoryResourceArray = rootChildren;
        int n = rootChildren.length;
        int n2 = 0;
        while (n2 < n) {
            IRepositoryResource rootChild = iRepositoryResourceArray[n2];
            String childName = rootChild.getName();
            int idx = oldUrl.indexOf(childName);
            if (idx > 0 && oldUrl.charAt(idx - 1) == '/' && (oldUrl.endsWith(childName) || oldUrl.charAt(idx + childName.length()) == '/')) {
                return rootChild.getUrl() + oldUrl.substring(idx + childName.length());
            }
            ++n2;
        }
        return null;
    }

    protected String getWCRootPath(String path) {
        File wcDB = FileUtility.findWCDB(new File(path));
        if (wcDB != null) {
            return wcDB.getParentFile().getParent();
        }
        return path;
    }

    @Override
    protected String getShortErrorMessage(Throwable t) {
        return BaseMessages.format(super.getShortErrorMessage(t), new Object[]{this.location.getUrl()});
    }
}

