/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.history;

import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.team.core.history.IFileHistory;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.core.history.provider.FileHistoryProvider;
import org.eclipse.team.svn.core.connector.SVNRevision;
import org.eclipse.team.svn.core.history.SVNLocalResourceRevision;
import org.eclipse.team.svn.core.history.SVNResourceHistory;
import org.eclipse.team.svn.core.operation.remote.GetLogMessagesOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.svnstorage.SVNRemoteStorage;
import org.eclipse.team.svn.core.utility.ProgressMonitorUtility;

public class SVNFileHistoryProvider
extends FileHistoryProvider {
    public IFileHistory getFileHistoryFor(IResource resource, int flags, IProgressMonitor monitor) {
        IRepositoryResource remote = SVNRemoteStorage.instance().asRepositoryResource(resource);
        GetLogMessagesOperation logOp = new GetLogMessagesOperation(remote);
        ILocalResource local = SVNRemoteStorage.instance().asLocalResource(resource);
        if ((flags & 1) != 0) {
            if (local.getRevision() != -1L) {
                remote.setSelectedRevision(SVNRevision.fromNumber(local.getRevision()));
            }
            logOp.setLimit(1L);
        } else if ((flags & 2) != 0) {
            if (local.getRevision() != -1L) {
                remote.setSelectedRevision(SVNRevision.fromNumber(local.getRevision()));
            }
            logOp.setLimit(2L);
        }
        ProgressMonitorUtility.doTaskExternal(logOp, monitor);
        if (logOp.getExecutionState() == 0 && logOp.getMessages() != null) {
            return new SVNResourceHistory(local, remote, logOp.getMessages(), flags == 0);
        }
        return null;
    }

    public IFileRevision getWorkspaceFileRevision(IResource resource) {
        return new SVNLocalResourceRevision(SVNRemoteStorage.instance().asLocalResource(resource), SVNRevision.WORKING);
    }

    public IFileHistory getFileHistoryFor(IFileStore store, int flags, IProgressMonitor monitor) {
        return null;
    }
}

