/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.extension.crashrecovery;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.team.svn.core.extension.CoreExtensionsManager;
import org.eclipse.team.svn.core.extension.crashrecovery.ErrorDescription;
import org.eclipse.team.svn.core.extension.crashrecovery.IErrorHandlingFacility;
import org.eclipse.team.svn.core.extension.crashrecovery.IResolutionHelper;

public class DefaultErrorHandlingFacility
implements IErrorHandlingFacility {
    protected List<IResolutionHelper> helpers = new ArrayList<IResolutionHelper>();
    private boolean extensionsFetched = false;

    @Override
    public synchronized void addResolutionHelper(IResolutionHelper helper) {
        if (helper != this && !this.helpers.contains(helper)) {
            this.helpers.add(helper);
        }
    }

    @Override
    public synchronized void removeResolutionHelper(IResolutionHelper helper) {
        this.helpers.remove(helper);
    }

    @Override
    public boolean acquireResolution(ErrorDescription description) {
        IResolutionHelper[] helpers;
        IResolutionHelper[] iResolutionHelperArray = helpers = this.getHelpers();
        int n = helpers.length;
        int n2 = 0;
        while (n2 < n) {
            IResolutionHelper helper = iResolutionHelperArray[n2];
            if (helper.acquireResolution(description)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected synchronized IResolutionHelper[] getHelpers() {
        if (!this.extensionsFetched) {
            this.helpers.addAll(Arrays.asList(CoreExtensionsManager.instance().getResolutionHelpers()));
            this.extensionsFetched = true;
        }
        return this.helpers.toArray(new IResolutionHelper[this.helpers.size()]);
    }
}

