/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.plugin.core.util;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.io.Streams;

public final class AIFile {
    private AIFile() {
    }

    public static void writeToFile(IFile file, InputStream in) {
        try {
            if (file.exists()) {
                file.setCharset("UTF-8", (IProgressMonitor)new NullProgressMonitor());
                file.setContents(in, true, false, null);
            } else {
                file.create(in, true, null);
                if (in != null) {
                    in.close();
                }
            }
        }
        catch (Exception ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
    }

    public static void writeToFile(IFile file, String string) {
        AIFile.writeToFile(file, string, "UTF-8");
    }

    public static void writeToFile(IFile file, String string, String charcode) {
        try {
            AIFile.writeToFile(file, Streams.convertStringToInputStream((String)string, (String)charcode));
        }
        catch (UnsupportedEncodingException ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
    }

    public static IFile constructIFile(String fullPath) {
        return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(fullPath));
    }
}

