/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.plugin.core.server.task;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.Socket;
import org.eclipse.osee.framework.jdk.core.result.XConsoleLogger;
import org.eclipse.osee.framework.plugin.core.server.task.NativeCommand;

public class TaskRequester {
    private final NativeCommand nativeCommand;
    private final Socket taskSocket;
    private final BufferedReader fromServer;
    private final ObjectOutputStream toServer;

    public TaskRequester(String machine, int port) throws IOException {
        if (port < 1) {
            throw new IllegalArgumentException("port argument must be a natural number");
        }
        if (machine.equals("")) {
            throw new IllegalArgumentException("machine must be specified");
        }
        this.taskSocket = new Socket(machine, port);
        this.fromServer = new BufferedReader(new InputStreamReader(this.taskSocket.getInputStream()));
        this.toServer = new ObjectOutputStream(this.taskSocket.getOutputStream());
        this.toServer.writeInt(587289473);
        this.nativeCommand = new NativeCommand();
    }

    public void close() {
        try {
            this.toServer.close();
            this.taskSocket.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void executeCommand(String[] callAndArgs) throws IOException {
        this.nativeCommand.sendNativeCommand(this.toServer, callAndArgs);
    }

    private static void printUsage() {
        XConsoleLogger.err((String)"Usage: java TaskRequester <cmd> [args]", (Object[])new Object[0]);
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            TaskRequester.printUsage();
            return;
        }
        TaskRequester app = new TaskRequester(InetAddress.getLocalHost().getHostName(), 8140);
        app.executeCommand(args);
        String line = null;
        while ((line = app.fromServer.readLine()) != null) {
            System.out.printf(line, new Object[0]);
        }
        app.close();
    }
}

