/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.swt.hex;

import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osee.framework.ui.swt.hex.HexTableRow;

class HexTableContentProvider
implements ILazyContentProvider {
    private final TableViewer viewer;
    private byte[] array;
    private final int bytesPerRow;
    private HexTableRow[] elements;

    HexTableContentProvider(TableViewer viewer, int bytesPerRow) {
        this.viewer = viewer;
        this.bytesPerRow = bytesPerRow;
    }

    HexTableRow[] getElements() {
        return this.elements;
    }

    int getBytesPerRow() {
        return this.bytesPerRow;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        byte[] newArray;
        byte[] oldArray;
        if (oldInput != null && newInput != null && (oldArray = (byte[])oldInput).length == (newArray = (byte[])newInput).length) {
            this.array = newArray;
            return;
        }
        if (newInput != null) {
            this.array = (byte[])newInput;
            int rowCOunt = (this.array.length + this.bytesPerRow - 1) / this.bytesPerRow;
            this.elements = new HexTableRow[rowCOunt];
            int offset = 0;
            int bytesLeft = this.array.length;
            int i = 0;
            while (i < rowCOunt) {
                this.elements[i] = new HexTableRow(offset, bytesLeft >= this.bytesPerRow ? this.bytesPerRow : bytesLeft, this.array);
                offset += this.bytesPerRow;
                bytesLeft -= this.bytesPerRow;
                ++i;
            }
        }
    }

    TableViewer getViewer() {
        return this.viewer;
    }

    public void updateElement(int index) {
        this.viewer.replace((Object)this.elements[index], index);
    }
}

