/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.swt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class FormattedText
extends Composite {
    private final List<StyleRange> styleArray;
    private StyledText textArea;
    private final int height;
    private final int width;
    private final boolean editable;

    public FormattedText(Composite parent, int style) {
        this(parent, style, 300, 300, false);
    }

    public FormattedText(Composite parent, int style, boolean editable) {
        this(parent, style, 300, 300, editable);
    }

    public FormattedText(Composite parent, int style, int height, int width) {
        this(parent, style, height, width, false);
    }

    public FormattedText(Composite parent, int style, int height, int width, boolean editable) {
        super(parent, style);
        this.editable = editable;
        this.height = height;
        this.width = width;
        this.styleArray = new ArrayList<StyleRange>();
        this.createTextArea();
    }

    private void createTextArea() {
        this.setLayout((Layout)new GridLayout());
        this.setLayoutData(new GridData(4, 4, true, true));
        this.textArea = new StyledText((Composite)this, 2882);
        GridData gd = new GridData(4, 4, true, true);
        gd.heightHint = this.height;
        gd.widthHint = this.width;
        this.textArea.setLayoutData((Object)gd);
        this.textArea.setEditable(this.editable);
        this.textArea.setBackground(Displays.getSystemColor(1));
        this.textArea.setBackground(Displays.getSystemColor(15));
        this.textArea.setText("");
    }

    public String[] getCmdList() {
        return this.textArea.getText().split("\n");
    }

    public void setTextAreaBackground(int swtColor) {
        this.textArea.setBackground(Displays.getSystemColor(swtColor));
    }

    public StyledText getStyledText() {
        return this.textArea;
    }

    public void clearTextArea() {
        this.textArea.setText("");
        this.styleArray.clear();
    }

    public void addText(String textToAdd) {
        this.addText(textToAdd, 0, 2);
    }

    public void addText(String textToAdd, int swtFontStyle, int swtColor) {
        this.addText(textToAdd, swtFontStyle, swtColor, false);
    }

    public void addText(String textToAdd, int swtFontStyle, int swtColor, boolean underline) {
        if (textToAdd != null) {
            String temp = this.textArea.getText();
            int startIndex = temp.length();
            temp = String.valueOf(temp) + textToAdd;
            this.textArea.setText(temp);
            StyleRange tempStyle = new StyleRange();
            this.styleArray.add(tempStyle);
            tempStyle.fontStyle = swtFontStyle;
            tempStyle.start = startIndex;
            tempStyle.length = textToAdd.length();
            tempStyle.underline = underline;
            tempStyle.foreground = Displays.getSystemColor(swtColor);
            this.textArea.setStyleRanges(this.styleArray.toArray(new StyleRange[this.styleArray.size()]));
            this.textArea.redraw();
        }
    }

    public void dispose() {
        super.dispose();
        this.textArea.dispose();
    }
}

