/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.swt;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class Displays {
    private Displays() {
    }

    public static void ensureInDisplayThread(Runnable runnable) {
        Displays.ensureInDisplayThread(runnable, false);
    }

    public static void pendInDisplayThread(Runnable runnable) {
        Displays.ensureInDisplayThread(runnable, true);
    }

    public static void ensureInDisplayThread(Runnable runnable, boolean forcePend) {
        if (Displays.isDisplayThread()) {
            runnable.run();
        } else if (forcePend) {
            Display.getDefault().syncExec(runnable);
        } else {
            Display.getDefault().asyncExec(runnable);
        }
    }

    public static boolean isDisplayThread() {
        boolean isDisplayTh = false;
        Display currentDisplay = Display.getCurrent();
        if (currentDisplay != null) {
            isDisplayTh = currentDisplay.getThread() == Thread.currentThread();
        }
        return isDisplayTh;
    }

    public static Shell getActiveShell() {
        return Display.getDefault().getActiveShell();
    }

    public static Color getSystemColor(int colorId) {
        return Display.getDefault().getSystemColor(colorId);
    }

    public static Color getColor(int red, int green, int blue) {
        return new Color((Device)Display.getDefault(), red, green, blue);
    }

    public static Image getSystemImage(int id) {
        return Display.getDefault().getSystemImage(id);
    }
}

