/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.swt;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class ColumnSorter
extends ViewerSorter {
    private final ITableLabelProvider labelProvider;
    private int columnToSort;
    private boolean ascending;

    public ColumnSorter(ITableLabelProvider labelProvider) {
        this(labelProvider, 0);
    }

    public ColumnSorter(ITableLabelProvider labelProvider, int columnToSort) {
        this.labelProvider = labelProvider;
        this.columnToSort = columnToSort;
        this.ascending = true;
    }

    public int compare(Viewer viewer, Object o1, Object o2) {
        int value;
        String str1 = this.labelProvider.getColumnText(o1, this.columnToSort);
        String str2 = this.labelProvider.getColumnText(o2, this.columnToSort);
        Integer val1 = null;
        Integer val2 = null;
        try {
            val1 = this.getIntValue(str1);
        }
        catch (NumberFormatException numberFormatException) {}
        try {
            val2 = this.getIntValue(str2);
        }
        catch (NumberFormatException numberFormatException) {}
        if (val1 != null && val2 != null) {
            value = val1 - val2;
        } else {
            if (val1 == null ^ val2 == null) {
                return val1 == null ? 1 : -1;
            }
            value = this.getComparator().compare(str1, str2);
        }
        return value * (this.ascending ? 1 : -1);
    }

    private int getIntValue(String string) throws NumberFormatException {
        int elipseIndex = string.indexOf("...");
        if (elipseIndex != -1) {
            return Integer.parseInt(string.substring(0, elipseIndex));
        }
        return Integer.parseInt(string);
    }

    public void setColumnToSort(int columnToSort) {
        if (this.columnToSort == columnToSort) {
            this.ascending = !this.ascending;
        } else {
            this.columnToSort = columnToSort;
            this.ascending = true;
        }
    }

    public boolean isAscending() {
        return this.ascending;
    }

    public void setAscending(boolean ascending) {
        this.ascending = ascending;
    }
}

