/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.core.access.context;

import org.eclipse.osee.framework.core.access.AccessTypeMatch;
import org.eclipse.osee.framework.core.access.context.AccessType;
import org.eclipse.osee.framework.core.access.context.AllowDeny;
import org.eclipse.osee.framework.core.access.context.ArtifactAndChildrenArtifactTypesAccessType;
import org.eclipse.osee.framework.core.access.context.IParentProvider;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.RelationTypeToken;

public class ArtifactAndChildrenRelationTypesAccessType
implements AccessType {
    private AllowDeny allowDeny;
    private ArtifactToken artifact;
    private RelationTypeToken relationType;
    private ArtifactTypeToken artAandBType;

    public ArtifactAndChildrenRelationTypesAccessType(AllowDeny allowDeny, ArtifactToken artifact, RelationTypeToken relationType, ArtifactTypeToken artAandBType) {
        this.allowDeny = allowDeny;
        this.artifact = artifact;
        this.relationType = relationType;
        this.artAandBType = artAandBType;
    }

    public AllowDeny getAllowDeny() {
        return this.allowDeny;
    }

    public void setAllowDeny(AllowDeny allowDeny) {
        this.allowDeny = allowDeny;
    }

    @Override
    public boolean isArtifactType() {
        return true;
    }

    public ArtifactToken getArtifact() {
        return this.artifact;
    }

    public void setArtifact(ArtifactToken artifact) {
        this.artifact = artifact;
    }

    public RelationTypeToken getRelationType() {
        return this.relationType;
    }

    public void setRelationType(RelationTypeToken relationType) {
        this.relationType = relationType;
    }

    public ArtifactTypeToken getArtAandBType() {
        return this.artAandBType;
    }

    public void setArtAandBType(ArtifactTypeToken artAandBType) {
        this.artAandBType = artAandBType;
    }

    public String toString() {
        return "ArtAndChildRelTypes [allow=" + (Object)((Object)this.allowDeny) + ", art=" + this.artifact + ", relType=" + this.relationType + ", artAandBType=" + this.artAandBType + "]";
    }

    @Override
    public AccessTypeMatch computeMatch(ArtifactToken otherArt, AttributeTypeToken attrType, RelationTypeToken relType, IParentProvider parentProvider) {
        boolean match = false;
        boolean computed = false;
        if (otherArt.equals(this.artifact)) {
            match = true;
            computed = true;
        } else if (this.artifact.getArtifactType().inheritsFrom(this.artAandBType) && ArtifactAndChildrenArtifactTypesAccessType.checkIfDecendentOf(otherArt, this.artifact, parentProvider)) {
            computed = true;
            match = true;
        }
        if (computed && match) {
            if (this.allowDeny == AllowDeny.Allow) {
                return AccessTypeMatch.Allow;
            }
            if (this.allowDeny == AllowDeny.Deny) {
                return AccessTypeMatch.Deny;
            }
        }
        return AccessTypeMatch.NotComputed;
    }
}

