/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.utility;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.ws.rs.core.Response;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.TransactionId;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.DeletionFlag;
import org.eclipse.osee.framework.core.exception.ArtifactDoesNotExist;
import org.eclipse.osee.framework.core.model.event.DefaultBasicGuidArtifact;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.NullOperationLogger;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.skynet.core.change.Change;
import org.eclipse.osee.framework.skynet.core.event.OseeEventManager;
import org.eclipse.osee.framework.skynet.core.event.model.TransactionChange;
import org.eclipse.osee.framework.skynet.core.event.model.TransactionEvent;
import org.eclipse.osee.framework.skynet.core.event.model.TransactionEventType;
import org.eclipse.osee.framework.skynet.core.internal.Activator;
import org.eclipse.osee.framework.skynet.core.internal.ServiceUtil;
import org.eclipse.osee.framework.skynet.core.revision.ChangeManager;
import org.eclipse.osee.orcs.rest.model.TransactionEndpoint;

public class PurgeTransactionOperation
extends AbstractOperation {
    private final Pair<TransactionEvent, Map<String, Long>> transEventAndIds;
    private final String deleteTxs;

    public static IOperation getPurgeTransactionOperation(TransactionToken txIdsToDelete) {
        return PurgeTransactionOperation.getPurgeTransactionOperation(Arrays.asList(txIdsToDelete));
    }

    public static IOperation getPurgeTransactionOperation(List<TransactionToken> txIdsToDelete) {
        return new PurgeTransactionOperation(txIdsToDelete, PurgeTransactionOperation.createPurgeTransactionEvent(txIdsToDelete));
    }

    private PurgeTransactionOperation(List<TransactionToken> txsToDelete, Pair<TransactionEvent, Map<String, Long>> transEventAndIds) {
        super("Purge transactions " + txsToDelete, "org.eclipse.osee.framework.skynet.core", NullOperationLogger.getSingleton());
        this.deleteTxs = Collections.toString((String)",", txsToDelete);
        this.transEventAndIds = transEventAndIds;
    }

    private static Pair<TransactionEvent, Map<String, Long>> createPurgeTransactionEvent(Collection<TransactionToken> purgedTransactions) {
        TransactionEvent transactionEvent = new TransactionEvent();
        transactionEvent.setEventType(TransactionEventType.Purged);
        HashMap<String, Long> guidToId = new HashMap<String, Long>();
        for (TransactionToken transId : purgedTransactions) {
            TransactionChange txChg = new TransactionChange();
            txChg.setBranch(transId.getBranch());
            txChg.setTransactionId((TransactionId)transId);
            transactionEvent.getTransactionChanges().add(txChg);
            ArrayList<Change> changes = new ArrayList<Change>();
            IOperation operation = ChangeManager.comparedToPreviousTx(transId, changes);
            Operations.executeWorkAndCheckStatus((IOperation)operation);
            if (changes.isEmpty()) continue;
            for (Change change : changes) {
                try {
                    Artifact art = ArtifactQuery.getArtifactFromId(change.getArtId(), transId.getBranch(), DeletionFlag.INCLUDE_DELETED);
                    guidToId.put(art.getGuid(), art.getId());
                    DefaultBasicGuidArtifact guidArt = new DefaultBasicGuidArtifact((BranchId)change.getBranch(), change.getArtifactType(), art.getGuid());
                    txChg.getArtifacts().add(guidArt);
                }
                catch (ArtifactDoesNotExist ex) {
                    OseeLog.log(Activator.class, (Level)Level.WARNING, (Throwable)ex);
                }
            }
        }
        return new Pair((Object)transactionEvent, guidToId);
    }

    protected void doWork(IProgressMonitor monitor) throws Exception {
        TransactionEndpoint txEndpoint = ServiceUtil.getOseeClient().getTransactionEndpoint();
        Throwable throwable = null;
        Object var4_5 = null;
        try (Response result = txEndpoint.purgeTxs(this.deleteTxs);){
            if (Response.Status.OK.getStatusCode() == result.getStatus()) {
                OseeEventManager.kickTransactionEvent((Object)this, (TransactionEvent)this.transEventAndIds.getFirst());
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

