/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.utility;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.exception.ArtifactDoesNotExist;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.ArtifactTypeManager;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;

public class CsvArtifact {
    private final Artifact artifact;

    public CsvArtifact(Artifact nativeArtifact) {
        this.artifact = nativeArtifact;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public void setCsvData(String csvData) {
        this.artifact.setSoleAttributeFromString((AttributeTypeId)CoreAttributeTypes.NativeContent, csvData);
    }

    public String getCsvData() {
        String csvData = null;
        if (this.artifact != null) {
            csvData = this.artifact.getSoleAttributeValueAsString((AttributeTypeToken)CoreAttributeTypes.NativeContent, null);
        }
        return csvData;
    }

    public void appendData(String csvData) {
        String data = this.getCsvData();
        if (Strings.isValid((String)data)) {
            data = data.replaceFirst("\n+$", "");
            data = String.valueOf(data) + "\n" + csvData;
        } else {
            data = csvData;
        }
        this.setCsvData(data);
    }

    public static CsvArtifact generateCsvArtifact(String staticId, String artifactName, String csvData, BranchToken branch) {
        Artifact artifact = ArtifactTypeManager.addArtifact(CoreArtifactTypes.GeneralDocument, branch);
        artifact.setName(artifactName);
        artifact.setSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.Extension, "csv");
        artifact.setSoleAttributeFromString((AttributeTypeId)CoreAttributeTypes.NativeContent, csvData);
        artifact.setSingletonAttributeValue((AttributeTypeId)CoreAttributeTypes.StaticId, staticId);
        return new CsvArtifact(artifact);
    }

    public static CsvArtifact getCsvArtifact(String staticId, BranchToken branch, boolean create) {
        Artifact art = null;
        try {
            art = ArtifactQuery.getArtifactFromTypeAndAttribute((ArtifactTypeId)CoreArtifactTypes.GeneralDocument, (AttributeTypeId)CoreAttributeTypes.StaticId, staticId, (BranchId)branch);
        }
        catch (ArtifactDoesNotExist artifactDoesNotExist) {}
        if (art != null) {
            return new CsvArtifact(art);
        }
        return CsvArtifact.generateCsvArtifact(staticId, staticId, "", branch);
    }

    public List<List<String>> getRows(boolean ignoreHeaderRow) {
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        String csvData = this.getCsvData();
        String[] csvLines = csvData.split("\n");
        int rowIndex = 0;
        String[] stringArray = csvLines;
        int n = csvLines.length;
        int n2 = 0;
        while (n2 < n) {
            String csvLine = stringArray[n2];
            if (ignoreHeaderRow && rowIndex > 0 || !ignoreHeaderRow) {
                String[] values = csvLine.split(",");
                ArrayList<String> row = new ArrayList<String>();
                String[] stringArray2 = values;
                int n3 = values.length;
                int n4 = 0;
                while (n4 < n3) {
                    String value = stringArray2[n4];
                    value = value.trim();
                    row.add(value);
                    ++n4;
                }
                rows.add(row);
            }
            ++rowIndex;
            ++n2;
        }
        return rows;
    }
}

