/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.utility;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcConnection;
import org.eclipse.osee.jdbc.JdbcService;
import org.eclipse.osee.jdbc.JdbcStatement;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public final class ConnectionHandler {
    private static JdbcService jdbcServiceInstance;

    private ConnectionHandler() {
    }

    public static JdbcClient getJdbcClient() {
        if (jdbcServiceInstance == null) {
            Bundle bundle = FrameworkUtil.getBundle(ConnectionHandler.class);
            BundleContext context = bundle.getBundleContext();
            jdbcServiceInstance = ConnectionHandler.findJdbcService(context);
        }
        return jdbcServiceInstance != null ? jdbcServiceInstance.getClient() : null;
    }

    private static JdbcService findJdbcService(BundleContext context) {
        JdbcService toReturn = null;
        try {
            Collection references = context.getServiceReferences(JdbcService.class, null);
            ServiceReference reference = null;
            if (references != null) {
                reference = (ServiceReference)Iterables.getFirst((Iterable)references, null);
            }
            if (reference != null) {
                toReturn = (JdbcService)context.getService(reference);
            }
        }
        catch (InvalidSyntaxException ex) {
            throw new OseeCoreException((Throwable)ex, "Error finding JdbcService reference", new Object[0]);
        }
        return toReturn;
    }

    public static JdbcStatement getStatement() {
        return ConnectionHandler.getJdbcClient().getStatement();
    }

    public static int runPreparedUpdate(String query, Object ... data) {
        return ConnectionHandler.getJdbcClient().runPreparedUpdate(query, data);
    }

    public static int runBatchUpdate(String query, List<Object[]> dataList) {
        return ConnectionHandler.getJdbcClient().runBatchUpdate(query, dataList);
    }

    public static int runPreparedUpdate(JdbcConnection connection, String query, Object ... data) {
        return ConnectionHandler.getJdbcClient().runPreparedUpdate(connection, query, data);
    }

    public static long getNextSequence(String sequenceName, boolean aggressiveFetch) {
        return ConnectionHandler.getJdbcClient().getNextSequence(sequenceName, aggressiveFetch);
    }
}

