/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.utility;

import com.google.common.escape.Escaper;
import com.google.common.html.HtmlEscapers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.model.TransactionRecord;
import org.eclipse.osee.framework.jdk.core.type.HashCollection;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.Attribute;
import org.eclipse.osee.framework.skynet.core.internal.Activator;
import org.eclipse.osee.framework.skynet.core.relation.RelationManager;

public final class Artifacts {
    private Artifacts() {
    }

    public static List<String> toGuids(Collection<? extends ArtifactToken> artifacts) {
        ArrayList<String> guids = new ArrayList<String>(artifacts.size());
        for (ArtifactToken artifactToken : artifacts) {
            guids.add(artifactToken.getGuid());
        }
        return guids;
    }

    public static <A extends Artifact> void getChildrenOfType(Artifact parentArtifact, Collection<A> children, Class<A> clazz, boolean recurse) {
        for (Artifact child : parentArtifact.getChildren()) {
            if (!((Object)((Object)child)).getClass().equals(clazz)) continue;
            children.add((A)((Object)child));
            if (!recurse) continue;
            Artifacts.getChildrenOfType(child, children, clazz, recurse);
        }
    }

    public static <A extends Artifact> Set<A> getChildrenOfTypeSet(Artifact parentArtifact, Class<A> clazz, boolean recurse) {
        HashSet<Artifact> children = new HashSet<Artifact>();
        for (Artifact child : parentArtifact.getChildren()) {
            if (!((Object)((Object)child)).getClass().equals(clazz)) continue;
            children.add(child);
            if (!recurse) continue;
            Artifacts.getChildrenOfType(child, children, clazz, recurse);
        }
        return children;
    }

    public static Map<String, String> getDetailsKeyValues(Artifact artifact) {
        Escaper htmlEscaper = HtmlEscapers.htmlEscaper();
        HashMap<String, String> details = new HashMap<String, String>();
        if (artifact != null) {
            details.put("Artifact Id", artifact.getIdString());
            details.put("GUID", String.valueOf(htmlEscaper.escape(artifact.getGuid())));
            details.put("Artifact Token", String.format("[%s]-[%d]", artifact.getSafeName(), artifact.getId()));
            details.put("Branch", String.valueOf(htmlEscaper.escape(artifact.getBranchToken().getName())));
            details.put("Branch Uuid", artifact.getBranch().getIdString());
            details.put("Artifact Type Name", String.valueOf(htmlEscaper.escape(artifact.getArtifactTypeName())));
            int x = 1;
            for (ArtifactTypeToken artType : artifact.getArtifactType().getSuperTypes()) {
                details.put("Artifact Type Super Type Name " + x++, String.valueOf(htmlEscaper.escape(artType.getName())));
            }
            details.put("Artifact Type Id", artifact.getArtifactType().getIdString());
            details.put("Gamma Id", String.valueOf(artifact.getGammaId()));
            details.put("Historical", String.valueOf(artifact.isHistorical()));
            details.put("Deleted", String.valueOf(artifact.isDeleted()));
            details.put("Revision", String.valueOf(artifact.isInDb() ? String.valueOf(artifact.getTransaction()) : "Not In Db"));
            details.put("Read Only", String.valueOf(artifact.isReadOnly()));
            details.put("Last Modified", artifact.isInDb() ? String.valueOf(artifact.getLastModified()) : "Not In Db");
            try {
                details.put("Last Modified By", artifact.isInDb() ? artifact.getLastModifiedBy().getName() : "Not In Db");
                TransactionRecord trans = (TransactionRecord)artifact.getTransaction();
                details.put("Last Modified Comment", artifact.isInDb() ? trans.getComment() : "Not In Db");
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                details.put("Last Modified By", "Exception " + ex.getLocalizedMessage());
            }
        } else {
            details.put("Artifact", "null");
        }
        return details;
    }

    public static String getDetailsFormText(Map<String, String> keyValues, String fontName, int fontSize) {
        Escaper htmlEscaper = HtmlEscapers.htmlEscaper();
        String template = "<b>%s:</b> %s<br/>";
        StringBuilder sb = new StringBuilder();
        sb.append("<body style='overflow:hidden'>");
        sb.append("<div style=\"font-size : ");
        sb.append(fontSize);
        sb.append("pt; font-family : ");
        sb.append(fontName);
        sb.append("\"> ");
        if (keyValues != null) {
            Object[] keys = keyValues.keySet().toArray(new String[keyValues.keySet().size()]);
            Arrays.sort(keys);
            Object[] objectArray = keys;
            int n = keys.length;
            int n2 = 0;
            while (n2 < n) {
                Object key = objectArray[n2];
                try {
                    sb.append(String.format(template, key, htmlEscaper.escape(keyValues.get(key))));
                }
                catch (Exception ex) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                }
                ++n2;
            }
        }
        sb.append("</div></body>");
        return sb.toString();
    }

    public static HashCollection<BranchId, Artifact> getBranchArtifactMap(Collection<Artifact> artifacts) {
        HashCollection branchMap = new HashCollection();
        for (Artifact artifact : artifacts) {
            branchMap.put((Object)artifact.getBranch(), (Object)artifact);
        }
        return branchMap;
    }

    public static boolean isOfType(Object object, ArtifactTypeToken artifactType) {
        if (object instanceof ArtifactToken) {
            return ((ArtifactToken)object).isOfType(new ArtifactTypeId[]{artifactType});
        }
        return false;
    }

    public static String getDirtyReport(Artifact artifact) {
        StringBuilder strB = new StringBuilder();
        for (Attribute<?> attribute : artifact.internalGetAttributes()) {
            if (!attribute.isDirty()) continue;
            strB.append("Attribute: ");
            strB.append(attribute.getNameValueDescription());
            strB.append("\n");
        }
        strB.append(RelationManager.reportHasDirtyLinks(artifact));
        return strB.toString();
    }

    public static Object toStringWithIds(Collection<? extends ArtifactToken> artifacts) {
        StringBuilder sb = new StringBuilder();
        for (ArtifactToken artifactToken : artifacts) {
            sb.append(artifactToken.toStringWithId());
            sb.append(", ");
        }
        return sb.toString().replaceFirst(", $", "");
    }
}

