/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.internal.users;

import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import org.eclipse.osee.cache.admin.Cache;
import org.eclipse.osee.framework.core.access.AccessTopicEventPayload;
import org.eclipse.osee.framework.core.client.AccessTopicEvent;
import org.eclipse.osee.framework.core.client.ClientSessionManager;
import org.eclipse.osee.framework.core.data.UserToken;
import org.eclipse.osee.framework.core.enums.SystemUser;
import org.eclipse.osee.framework.core.exception.OseeAuthenticationException;
import org.eclipse.osee.framework.core.exception.UserNotInDatabase;
import org.eclipse.osee.framework.jdk.core.type.LazyObject;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.User;
import org.eclipse.osee.framework.skynet.core.event.OseeEventManager;
import org.eclipse.osee.framework.skynet.core.internal.Activator;

public class CurrentUserProvider
extends LazyObject<User> {
    private final LazyObject<Cache<String, User>> cacheProvider;
    private final AtomicBoolean duringCreateUser = new AtomicBoolean(false);
    private final AtomicBoolean isAnonymousAuthenticationAllowed = new AtomicBoolean(true);
    private final AtomicBoolean isAnonymousNotificationAllowed = new AtomicBoolean(true);

    public CurrentUserProvider(LazyObject<Cache<String, User>> cacheProvider) {
        this.cacheProvider = cacheProvider;
    }

    protected FutureTask<User> createLoaderTask() {
        this.duringCreateUser.set(false);
        CurrentUserCreationCallable callable = new CurrentUserCreationCallable();
        return new FutureTask<User>(callable);
    }

    public boolean isDuringCurrentUserCreation() {
        return this.duringCreateUser.get();
    }

    private final class CurrentUserCreationCallable
    implements Callable<User> {
        private CurrentUserCreationCallable() {
        }

        @Override
        public User call() throws Exception {
            User currentUser = null;
            ClientSessionManager.ensureSessionCreated();
            if (ClientSessionManager.isSessionValid()) {
                UserToken currentUserToken = ClientSessionManager.getCurrentUserToken();
                try {
                    currentUser = this.getUser(currentUserToken);
                }
                catch (UserNotInDatabase userNotInDatabase) {
                    if (CurrentUserProvider.this.isAnonymousAuthenticationAllowed.compareAndSet(true, false)) {
                        ClientSessionManager.authenticateAsAnonymous();
                        currentUser = this.getUser(SystemUser.Anonymous);
                    }
                }
            } else if (CurrentUserProvider.this.isAnonymousAuthenticationAllowed.compareAndSet(true, false)) {
                ClientSessionManager.authenticateAsAnonymous();
                currentUser = this.getUser(SystemUser.Anonymous);
            }
            if (currentUser == null) {
                throw new OseeStateException("Setting current user to null.", new Object[0]);
            }
            if (currentUser.equals(SystemUser.Anonymous) && CurrentUserProvider.this.isAnonymousNotificationAllowed.compareAndSet(true, false)) {
                OseeLog.log(Activator.class, (Level)Level.INFO, (String)"You are logged into OSEE as \"Anonymous\".  If this is unexpected notify your OSEE admin");
            }
            if (ClientSessionManager.isSessionValid()) {
                AccessTopicEventPayload payload = new AccessTopicEventPayload();
                OseeEventManager.kickAccessTopicEvent(CurrentUserCreationCallable.class, payload, AccessTopicEvent.USER_AUTHENTICATED);
            }
            return currentUser;
        }

        private User getUser(UserToken token) {
            User user = null;
            try {
                user = (User)((Object)((Cache)CurrentUserProvider.this.cacheProvider.get()).get((Object)token.getUserId()));
            }
            catch (Exception ex) {
                throw new OseeAuthenticationException((Throwable)ex, "User [%s] is not authenticated", new Object[]{token.getUserId()});
            }
            return user;
        }
    }
}

