/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.internal;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.model.cache.BranchCache;
import org.eclipse.osee.framework.core.model.cache.IOseeCache;
import org.eclipse.osee.framework.core.model.cache.IOseeDataAccessor;
import org.eclipse.osee.framework.core.services.IOseeCachingService;
import org.eclipse.osee.framework.skynet.core.internal.accessors.DatabaseBranchAccessor;
import org.eclipse.osee.jdbc.JdbcClient;
import org.eclipse.osee.jdbc.JdbcService;

public class ClientCachingServiceProxy
implements IOseeCachingService {
    private JdbcService jdbcService;
    private OrcsTokenService tokenService;
    private BranchCache branchCache;
    private List<IOseeCache<?>> caches;

    public void setJdbcService(JdbcService jdbcService) {
        this.jdbcService = jdbcService;
    }

    public void setOrcsTokenService(OrcsTokenService tokenService) {
        this.tokenService = tokenService;
    }

    public void start() {
        JdbcClient jdbcClient = this.jdbcService.getClient();
        this.branchCache = new BranchCache((IOseeDataAccessor)new DatabaseBranchAccessor(jdbcClient));
        this.caches = new ArrayList();
        this.caches.add((IOseeCache<?>)this.branchCache);
    }

    public void stop() {
        this.caches.clear();
        this.branchCache = null;
    }

    public BranchCache getBranchCache() {
        return this.branchCache;
    }

    public OrcsTokenService getTokenService() {
        return this.tokenService;
    }

    public void clearAll() {
        this.getBranchCache().decacheAll();
    }
}

