/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.importing.resolvers;

import java.util.List;
import java.util.logging.Level;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.importing.RoughArtifact;
import org.eclipse.osee.framework.skynet.core.importing.resolvers.IRoughArtifactTranslator;
import org.eclipse.osee.framework.skynet.core.importing.resolvers.NewArtifactImportResolver;

public class GuidBasedArtifactResolver
extends NewArtifactImportResolver {
    private final boolean createNewIfNotExist;

    public GuidBasedArtifactResolver(IRoughArtifactTranslator translator, ArtifactTypeToken primaryArtifactType, ArtifactTypeToken secondaryArtifactType, boolean createNewIfNotExist, boolean deleteUnmatchedArtifacts) {
        super(translator, primaryArtifactType, secondaryArtifactType);
        this.createNewIfNotExist = createNewIfNotExist;
    }

    private boolean guidsMatch(RoughArtifact roughArt, Artifact realArt) {
        String roughGuid = roughArt.getGuid();
        String realGuid = realArt.getGuid();
        return realGuid.equals(roughGuid);
    }

    @Override
    public Artifact resolve(RoughArtifact roughArtifact, BranchToken branch, Artifact realParent, Artifact root) {
        List<Artifact> descendants = root.getDescendants();
        Artifact realArtifact = null;
        if (roughArtifact.getGuid() == null) {
            OseeLog.logf(GuidBasedArtifactResolver.class, (Level)Level.INFO, (String)"Guid based resolver is comparing a null GUID. roughArtifactifact: [%s]", (Object[])new Object[]{roughArtifact});
        }
        for (Artifact artifact : descendants) {
            if (!this.guidsMatch(roughArtifact, artifact)) continue;
            this.getTranslator().translate(roughArtifact, artifact);
            return artifact;
        }
        if (this.createNewIfNotExist) {
            realArtifact = super.resolve(roughArtifact, branch, null, root);
        }
        return realArtifact;
    }
}

