/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.importing.parsers;

import org.eclipse.osee.framework.jdk.core.util.Conditions;
import org.eclipse.osee.framework.skynet.core.importing.parsers.DoorsDataType;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Elements;

public class DoorsTableRow {
    private final Elements elements = new Elements();
    private RowType type = RowType.SINGLE;
    private DoorsDataType dataType = DoorsDataType.NOT_DEFINED;

    public void fill(Node row) {
        Conditions.checkNotNull((Object)row, (String)"Row data");
        for (Node n : row.childNodes()) {
            if (!(n instanceof Element)) continue;
            this.elements.add((Object)((Element)n));
        }
    }

    public Elements getRows() {
        return this.elements;
    }

    public Element getElement(int index) {
        return (Element)this.elements.get(index);
    }

    public void setRowType(RowType type) {
        Conditions.checkNotNull((Object)((Object)type), (String)"Row Type");
        this.type = type;
    }

    public RowType getType() {
        return this.type;
    }

    public boolean isMainRow() {
        boolean toReturn = false;
        if (this.type == RowType.SINGLE || this.type == RowType.MULTI_START) {
            toReturn = true;
        }
        return toReturn;
    }

    public DoorsDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(DoorsDataType dataType) {
        Conditions.checkNotNull((Object)((Object)dataType), (String)"Data Type");
        this.dataType = dataType;
    }

    public static enum RowType {
        SINGLE,
        MULTI_START,
        MULTI_MID,
        MULTI_END,
        FIRST_ROW;

    }
}

