/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.event.model;

import java.util.Collection;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.enums.EventTopicTransferType;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.skynet.core.event.model.EventModType;
import org.eclipse.osee.framework.skynet.core.event.model.EventTopicAttributeChangeTransfer;

public class EventTopicArtifactTransfer {
    private BranchId branch;
    private ArtifactId artifactId;
    private ArtifactTypeId artifactTypeId;
    private EventModType eventModType;
    private ArtifactTypeId fromArtTypeGuid;
    private Collection<EventTopicAttributeChangeTransfer> attributeChanges;
    private EventTopicTransferType transferType = EventTopicTransferType.BASE;

    public BranchId getBranch() {
        return this.branch;
    }

    public void setBranch(BranchId branch) {
        this.branch = branch;
    }

    public ArtifactId getArtifactId() {
        return this.artifactId;
    }

    public ArtifactToken getArtifactToken() {
        return ArtifactToken.valueOf((ArtifactId)this.artifactId, (BranchToken)BranchToken.valueOf((BranchId)this.branch));
    }

    public void setArtifactId(ArtifactId artifactId) {
        this.artifactId = artifactId;
    }

    public ArtifactTypeId getArtifactTypeId() {
        return this.artifactTypeId;
    }

    public void setArtifactTypeId(ArtifactTypeId artifactType) {
        this.artifactTypeId = artifactType;
    }

    public EventModType getEventModType() {
        return this.eventModType;
    }

    public void setEventModType(EventModType eventModType) {
        this.eventModType = eventModType;
    }

    public ArtifactTypeId getFromArtTypeGuid() {
        return this.fromArtTypeGuid;
    }

    public void setFromArtTypeGuid(ArtifactTypeId fromArtTypeGuid) {
        this.fromArtTypeGuid = fromArtTypeGuid;
    }

    public Collection<EventTopicAttributeChangeTransfer> getAttributeChanges() {
        return this.attributeChanges;
    }

    public void setAttributeChanges(Collection<EventTopicAttributeChangeTransfer> attributeChanges) {
        this.attributeChanges = attributeChanges;
    }

    public EventTopicTransferType getTransferType() {
        return this.transferType;
    }

    public void setTransferType(EventTopicTransferType transferType) {
        this.transferType = transferType;
    }

    public String toString() {
        String branchName = this.branch == null ? "null branch" : this.branch.getIdString();
        String artifactIdName = this.artifactId == null ? "null Artifact" : this.artifactId.getIdString();
        String artifactTypeIdName = this.artifactTypeId == null ? "null Artifact Type" : this.artifactTypeId.getIdString();
        String eventModTypeName = this.eventModType == null ? "null mod type" : this.eventModType.toString();
        String fromArtTypeGuidName = this.fromArtTypeGuid == null ? "null from Artifact Type" : this.fromArtTypeGuid.getIdString();
        String attributeChangesName = this.attributeChanges == null ? "null attributes" : this.attributeChanges.toString();
        switch (this.transferType) {
            case BASE: {
                return String.format("[BASE: %s - B:%s - A:%s]", eventModTypeName, branchName, artifactTypeIdName);
            }
            case CHANGE: {
                return String.format("[CHANGE: %s - %s from type [%s] to [%s]]", eventModTypeName, artifactIdName, fromArtTypeGuidName, artifactTypeIdName);
            }
            case MODIFICATION: {
                return String.format("[MOD: %s - G:%s - B:%s - A:%s - %s]", eventModTypeName, artifactIdName, branchName, artifactTypeIdName, attributeChangesName);
            }
        }
        throw new OseeArgumentException("Unknown transfer type in %", new Object[]{this.getClass().toString()});
    }

    public boolean is(EventModType ... eventModTypes) {
        EventModType[] eventModTypeArray = eventModTypes;
        int n = eventModTypes.length;
        int n2 = 0;
        while (n2 < n) {
            EventModType eventModType = eventModTypeArray[n2];
            if (this.eventModType == eventModType) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
        result = 31 * result + (this.artifactTypeId == null ? 0 : this.artifactTypeId.hashCode());
        result = 31 * result + (this.attributeChanges == null ? 0 : this.attributeChanges.hashCode());
        result = 31 * result + (this.branch == null ? 0 : this.branch.hashCode());
        result = 31 * result + (this.eventModType == null ? 0 : this.eventModType.hashCode());
        result = 31 * result + (this.fromArtTypeGuid == null ? 0 : this.fromArtTypeGuid.hashCode());
        result = 31 * result + (this.transferType == null ? 0 : this.transferType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EventTopicArtifactTransfer other = (EventTopicArtifactTransfer)obj;
        if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
            return false;
        }
        if (this.artifactTypeId == null ? other.artifactTypeId != null : !this.artifactTypeId.equals(other.artifactTypeId)) {
            return false;
        }
        if (this.attributeChanges == null ? other.attributeChanges != null : !this.attributeChanges.equals(other.attributeChanges)) {
            return false;
        }
        if (this.branch == null ? other.branch != null : !this.branch.equals(other.branch)) {
            return false;
        }
        if (this.eventModType != other.eventModType) {
            return false;
        }
        if (this.fromArtTypeGuid == null ? other.fromArtTypeGuid != null : !this.fromArtTypeGuid.equals(other.fromArtTypeGuid)) {
            return false;
        }
        return this.transferType == other.transferType;
    }
}

