/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.change;

import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.model.change.ChangeType;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.change.Change;

public final class ErrorChange
extends Change {
    private static final String ERROR_STRING = "!Error -";
    private final String errorMessage;
    private final String name;

    public ErrorChange(BranchToken branch, ArtifactId artId, String exception) {
        super(branch, GammaId.valueOf((Long)0L), artId, null, null, false, Artifact.SENTINEL, null);
        this.errorMessage = String.format("%s %s", ERROR_STRING, exception);
        this.name = String.format("%s ArtID: %s BranchUuid: %s - %s", ERROR_STRING, this.getArtId(), branch == null ? null : branch.getIdString(), exception);
    }

    @Override
    public String getIsValue() {
        return this.errorMessage;
    }

    public ArtifactId getItemId() {
        return ArtifactId.valueOf((Long)0L);
    }

    @Override
    public String getItemKind() {
        return this.errorMessage;
    }

    @Override
    public Id getItemTypeId() {
        return ArtifactTypeId.SENTINEL;
    }

    @Override
    public String getItemTypeName() {
        return this.errorMessage;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getNameOrToken() {
        return this.name;
    }

    @Override
    public String getWasValue() {
        return this.errorMessage;
    }

    @Override
    public ChangeType getChangeType() {
        return null;
    }
}

