/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.change;

import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.model.TransactionDelta;
import org.eclipse.osee.framework.core.model.TransactionDeltaSupplier;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;

public class ArtifactDelta
implements TransactionDeltaSupplier {
    private final Artifact startArt;
    private final Artifact endArt;
    private final Artifact baseArt;
    private final TransactionDelta txDelta;

    public ArtifactDelta(TransactionDelta txDelta, Artifact startArt, Artifact endArt) {
        if (startArt == null && endArt == null) {
            throw new OseeArgumentException("the start and end artifacts can not both be null.", new Object[0]);
        }
        this.startArt = startArt;
        this.endArt = endArt;
        this.baseArt = startArt;
        this.txDelta = txDelta;
    }

    public ArtifactDelta(TransactionDelta txDelta, Artifact startArt, Artifact endArt, Artifact baseArt) {
        if (startArt == null && endArt == null) {
            throw new OseeArgumentException("the start and end artifacts can not both be null.", new Object[0]);
        }
        this.startArt = startArt;
        this.endArt = endArt;
        this.baseArt = baseArt;
        this.txDelta = txDelta;
    }

    public ArtifactDelta(Artifact startArt, Artifact endArt) {
        this(null, startArt, endArt);
    }

    public TransactionDelta getTxDelta() {
        return this.txDelta;
    }

    public Artifact getStartArtifact() {
        return this.startArt;
    }

    public Artifact getEndArtifact() {
        return this.endArt;
    }

    public Artifact getBaseArtifact() {
        return this.baseArt;
    }

    public BranchToken getBranch() {
        return this.getStartArtifact() != null ? this.getStartArtifact().getBranchToken() : this.getEndArtifact().getBranchToken();
    }

    public boolean equals(Object obj) {
        boolean result = false;
        if (obj instanceof ArtifactDelta) {
            boolean left;
            ArtifactDelta other = (ArtifactDelta)obj;
            boolean bl = this.startArt == null ? other.startArt == null : (left = this.startArt.equals((Object)other.startArt));
            boolean right = this.endArt == null ? other.endArt == null : this.endArt.equals((Object)other.endArt);
            result = left && right;
        }
        return result;
    }

    public int hashCode() {
        int result = 17;
        result = this.startArt != null ? 37 * result + this.startArt.hashCode() : (result *= 37);
        result = this.endArt != null ? 37 * result + this.endArt.hashCode() : (result *= 37);
        return result;
    }

    public String toString() {
        String firstString = String.valueOf((Object)this.getStartArtifact());
        String secondString = String.valueOf((Object)this.getEndArtifact());
        return String.format("[start:%s, end:%s]", firstString, secondString);
    }
}

