/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.attribute;

import java.io.InputStream;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.io.xml.XmlTextInputStream;
import org.eclipse.osee.framework.skynet.core.attribute.CharacterBackedAttribute;
import org.eclipse.osee.framework.skynet.core.word.WordCoreUtilClient;

public class StringAttribute
extends CharacterBackedAttribute<String> {
    public String getValue() {
        return this.getAttributeDataProvider().getValueAsString();
    }

    @Override
    public String convertStringToValue(String value) {
        return value;
    }

    @Override
    public String getDisplayableString() {
        if (this.isOfType((AttributeTypeId)CoreAttributeTypes.WordTemplateContent)) {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (XmlTextInputStream inputStream = new XmlTextInputStream(this.getValue());){
                    return Lib.inputStreamToString((InputStream)new XmlTextInputStream(this.getValue()));
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (Exception ex) {
                OseeCoreException.wrapAndThrow((Throwable)ex);
            }
        }
        return this.getValue();
    }

    @Override
    protected String modifyWordValue(String value) {
        value = WordCoreUtilClient.checkForTrackedChanges(value, this.getArtifact());
        value = WordCoreUtilClient.removeWordMarkupSmartTags(value);
        return value;
    }
}

