/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.attribute;

import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.validation.IOseeValidator;

public class ParagraphNumberAttributeValidation
implements IOseeValidator {
    @Override
    public int getQualityOfService() {
        return 0;
    }

    @Override
    public boolean isApplicable(Artifact artifact, AttributeTypeToken attributeType) {
        return attributeType.equals(CoreAttributeTypes.ParagraphNumber);
    }

    @Override
    public XResultData validate(Artifact artifact, AttributeTypeToken attributeType, Object proposedObject) {
        if (artifact.getSoleAttributeValueAsString(attributeType, "").matches(".*[a-zA-Z].*")) {
            return XResultData.valueOf((XResultData.Type)XResultData.Type.Severe, (String)ParagraphNumberAttributeValidation.class.getName(), (String)"Invalid Paragraph Number - letters are not allowed");
        }
        return XResultData.OK_STATUS;
    }
}

