/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.attribute;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.plugin.core.util.ExtensionPoints;
import org.eclipse.osee.framework.skynet.core.artifact.Attribute;
import org.osgi.framework.Bundle;

public class AttributeExtensionManager {
    private static final String CLASS_ID = "class";
    private static final String ATTRIBUTE_TYPE = "org.eclipse.osee.framework.skynet.core.AttributeType";
    private static final String ATTRIBUTE_DATA_PROVIDER_TYPE = "org.eclipse.osee.framework.skynet.core.AttributeDataProvider";
    private static final String[] attributeBaseTypes = new String[]{"CharacterBackedAttributeType", "BinaryBackedAttributeType"};
    private static final String[] attributeProviderBaseTypes = new String[]{"CharacterAttributeDataProvider", "BinaryAttributeDataProvider"};
    private static final AttributeExtensionManager instance = new AttributeExtensionManager();
    private Map<String, Pair<String, String>> attributeTypeClasses = null;
    private Map<String, Pair<String, String>> attributeDataProviderClasses = null;

    private AttributeExtensionManager() {
    }

    private static String fullyQualifyName(String name) {
        return name.contains(".") ? name : "org.eclipse.osee.framework.skynet.core." + name;
    }

    public static Class<? extends Attribute<?>> getAttributeClassFor(String name) {
        String resolved;
        Pair<String, String> entry;
        if (AttributeExtensionManager.instance.attributeTypeClasses == null) {
            AttributeExtensionManager.instance.attributeTypeClasses = instance.loadExtensions(ATTRIBUTE_TYPE, attributeBaseTypes, CLASS_ID);
        }
        if ((entry = AttributeExtensionManager.instance.attributeTypeClasses.get(resolved = AttributeExtensionManager.fullyQualifyName(name))) == null) {
            throw new OseeArgumentException("Unable to find class for: [%s]", new Object[]{resolved});
        }
        return instance.loadClass((String)entry.getFirst(), (String)entry.getSecond());
    }

    private <T> Class<T> loadClass(String bundleName, String className) {
        Class toReturn = null;
        try {
            Bundle bundle = Platform.getBundle((String)bundleName);
            toReturn = bundle.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            OseeCoreException.wrapAndThrow((Throwable)ex);
        }
        return toReturn;
    }

    private Map<String, Pair<String, String>> loadExtensions(String extensionPointId, String[] elementNames, String classNameAttribute) {
        HashMap<String, Pair<String, String>> toReturn = new HashMap<String, Pair<String, String>>();
        String[] stringArray = elementNames;
        int n = elementNames.length;
        int n2 = 0;
        while (n2 < n) {
            String elementName = stringArray[n2];
            List elements = ExtensionPoints.getExtensionElements((String)extensionPointId, (String)elementName);
            for (IConfigurationElement element : elements) {
                IExtension extension = (IExtension)element.getParent();
                String name = extension.getUniqueIdentifier();
                String className = Strings.intern((String)element.getAttribute(classNameAttribute));
                String bundleName = Strings.intern((String)element.getContributor().getName());
                if (!Strings.isValid((String)bundleName) || !Strings.isValid((String)className)) continue;
                toReturn.put(name, (Pair<String, String>)new Pair((Object)bundleName, (Object)className));
            }
            ++n2;
        }
        if (toReturn.isEmpty()) {
            throw new OseeStateException("No Objects loaded for [%s] with element names %s and attribute [%s]", new Object[]{extensionPointId, Arrays.asList(elementNames), classNameAttribute});
        }
        return toReturn;
    }

    public String toString() {
        return super.toString();
    }

    public static Set<String> getAttributeProviders() {
        if (AttributeExtensionManager.instance.attributeDataProviderClasses == null) {
            AttributeExtensionManager.instance.attributeDataProviderClasses = instance.loadExtensions(ATTRIBUTE_DATA_PROVIDER_TYPE, attributeProviderBaseTypes, CLASS_ID);
        }
        return AttributeExtensionManager.instance.attributeDataProviderClasses.keySet();
    }
}

