/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.artifact.search;

import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.RelationSide;
import org.eclipse.osee.framework.skynet.core.artifact.search.ISearchPrimitive;
import org.eclipse.osee.framework.skynet.core.artifact.search.QueryBuilderArtifact;

public class InRelationSearch
implements ISearchPrimitive {
    private static final String TOKEN = ";";
    private final RelationTypeToken relationType;
    private final Boolean sideA;

    public InRelationSearch(RelationTypeToken relationType, Boolean sideA) {
        this.relationType = relationType;
        this.sideA = sideA;
    }

    public String toString() {
        return "In Relation: " + this.relationType + " from";
    }

    @Override
    public String getStorageString() {
        return this.sideA + TOKEN + this.relationType.getId();
    }

    public static InRelationSearch getPrimitive(String storageString, OrcsTokenService tokenService) {
        String[] values = storageString.split(TOKEN);
        if (values.length < 2) {
            throw new IllegalStateException("Value for " + InRelationSearch.class.getSimpleName() + " not parsable");
        }
        RelationTypeToken type = tokenService.getRelationType(Long.valueOf(values[1]));
        return new InRelationSearch(type, Boolean.parseBoolean(values[0]));
    }

    @Override
    public void addToQuery(QueryBuilderArtifact builder) {
        if (this.sideA == null) {
            builder.andExists(this.relationType);
        } else {
            RelationSide side = this.sideA != false ? RelationSide.SIDE_A : RelationSide.SIDE_B;
            RelationTypeSide rts = RelationTypeSide.create((RelationTypeToken)this.relationType, (RelationSide)side);
            builder.andExists(rts);
        }
    }
}

