/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.artifact;

import java.util.Collection;
import org.eclipse.osee.framework.core.OrcsTokenService;
import org.eclipse.osee.framework.core.data.ApplicabilityId;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.GammaId;
import org.eclipse.osee.framework.core.data.RelationId;
import org.eclipse.osee.framework.core.data.RelationTypeToken;
import org.eclipse.osee.framework.core.enums.LoadLevel;
import org.eclipse.osee.framework.core.enums.ModificationType;
import org.eclipse.osee.framework.core.sql.OseeSql;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.internal.ServiceUtil;
import org.eclipse.osee.framework.skynet.core.relation.RelationManager;
import org.eclipse.osee.framework.skynet.core.utility.ConnectionHandler;
import org.eclipse.osee.jdbc.JdbcStatement;

class RelationLoader {
    RelationLoader() {
    }

    public static void loadRelationData(Long joinQueryId, Collection<Artifact> artifacts, boolean historical, LoadLevel loadLevel, OrcsTokenService tokenservice) {
        ApplicabilityId applicabilityId;
        ModificationType modificationType;
        String sqlQuery;
        if (loadLevel == LoadLevel.ARTIFACT_DATA || loadLevel == LoadLevel.ARTIFACT_AND_ATTRIBUTE_DATA) {
            return;
        }
        if (historical) {
            return;
        }
        try (JdbcStatement chStmt = ConnectionHandler.getStatement();){
            sqlQuery = ServiceUtil.getSql(OseeSql.LOAD_RELATIONS);
            chStmt.runPreparedQuery(artifacts.size() * 8, sqlQuery, new Object[]{joinQueryId});
            while (chStmt.next()) {
                RelationId relationId = RelationId.valueOf((Long)chStmt.getLong("rel_link_id"));
                BranchId branch = BranchId.valueOf((Long)chStmt.getLong("branch_id"));
                ArtifactToken aArtifactId = ArtifactToken.valueOf((long)chStmt.getLong("a_art_id"), (BranchId)branch);
                ArtifactToken bArtifactId = ArtifactToken.valueOf((long)chStmt.getLong("b_art_id"), (BranchId)branch);
                RelationTypeToken relationType = tokenservice.getRelationType(Long.valueOf(chStmt.getLong("rel_link_type_id")));
                GammaId gammaId = GammaId.valueOf((Long)chStmt.getLong("gamma_id"));
                String rationale = chStmt.getString("rationale");
                modificationType = ModificationType.valueOf((long)chStmt.getInt("mod_type"));
                applicabilityId = ApplicabilityId.valueOf((Long)chStmt.getLong("app_id"));
                RelationManager.getOrCreate(aArtifactId, bArtifactId, relationType, relationId, gammaId, rationale, modificationType, applicabilityId, 0, ArtifactId.SENTINEL);
            }
        }
        try {
            sqlQuery = ServiceUtil.getSql(OseeSql.LOAD_RELATIONS2);
            chStmt.runPreparedQuery(artifacts.size() * 8, sqlQuery, new Object[]{joinQueryId});
            while (chStmt.next()) {
                BranchId branch = BranchId.valueOf((Long)chStmt.getLong("branch_id"));
                ArtifactToken aArtifactId = ArtifactToken.valueOf((long)chStmt.getLong("a_art_id"), (BranchId)branch);
                ArtifactToken bArtifactId = ArtifactToken.valueOf((long)chStmt.getLong("b_art_id"), (BranchId)branch);
                RelationTypeToken relationType = tokenservice.getRelationType(Long.valueOf(chStmt.getLong("rel_type")));
                GammaId gammaId = GammaId.valueOf((Long)chStmt.getLong("gamma_id"));
                int relOrder = chStmt.getInt("rel_order");
                ArtifactId relArtId = ArtifactId.valueOf((Long)chStmt.getLong("rel_art_id"));
                modificationType = ModificationType.valueOf((long)chStmt.getInt("mod_type"));
                applicabilityId = ApplicabilityId.valueOf((Long)chStmt.getLong("app_id"));
                RelationManager.getOrCreate(aArtifactId, bArtifactId, relationType, RelationId.valueOf((Long)0L), gammaId, "", modificationType, applicabilityId, relOrder, relArtId);
            }
        }
        finally {
            chStmt.close();
        }
        for (Artifact artifact : artifacts) {
            artifact.setLinksLoaded(true);
        }
    }
}

